<?php
/**
 * @package Helix Ultimate Framework
 * @author JoomShaper https://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2018 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
*/

defined ('_JEXEC') or die();

require_once JPATH_PLUGINS. '/system/helixultimate/core/classes/menu.php';

class HelixUltimateFeatureMenu
{

	private $params;

	public function __construct($params)
	{
		$this->params = $params;
		$this->position = 'menu';
		$this->load_pos = $this->params->get('menu_load_pos', 'default');

	}

	public function renderFeature()
	{

		$menu_type = $this->params->get('menu_type');
		$offcanvs_position = $this->params->get('offcanvas_position', 'right');

		$output = '';

		if($menu_type === 'mega_offcanvas')
		{
			$output .= '<nav class="sp-megamenu-wrapper" role="navigation">';
			
			$output .= '<div class="jn-user-menu">';
				$output .= '<jdoc:include type="modules" name="user-menu" style="sp_xhtml" />';
			$output .= '</div>';
			
			if($offcanvs_position === 'right') 
			{
				$output .= '<a id="offcanvas-toggler" aria-label="'. JText::_('HELIX_ULTIMATE_NAVIGATION') .'" class="offcanvas-toggler-right" href="#"><i class="fa fa-bars" aria-hidden="true" title="'. JText::_('HELIX_ULTIMATE_NAVIGATION') .'"></i></a>';
			}
			$menu = new HelixUltimateMenu('d-none d-lg-block','');
			$output .= $menu->render();
			$output .= '</nav>';
		}
		elseif ($menu_type === 'mega')
		{
			$output .= '<nav class="sp-megamenu-wrapper" role="navigation">';
			
			$output .= '<div class="jn-user-menu">';
				$output .= '<jdoc:include type="modules" name="user-menu" style="sp_xhtml" />';
			$output .= '</div>';
		
			if($offcanvs_position === 'right') 
			{
				$output .= '<a id="offcanvas-toggler" aria-label="'. JText::_('HELIX_ULTIMATE_NAVIGATION') .'" class="offcanvas-toggler-right d-block d-lg-none" href="#"><i class="fa fa-bars" aria-hidden="true" title="'. JText::_('HELIX_ULTIMATE_NAVIGATION') .'"></i></a>';
			}
			$menu = new HelixUltimateMenu('d-none d-lg-block','');
			$output .= $menu->render();
			$output .= '</nav>';
		} else {
			if($offcanvs_position === 'right') 
			{
				$output .= '<a id="offcanvas-toggler" aria-label="'. JText::_('HELIX_ULTIMATE_NAVIGATION') .'" class="offcanvas-toggler-right" href="#"><i class="fa fa-bars" aria-hidden="true" title="'. JText::_('HELIX_ULTIMATE_NAVIGATION') .'"></i></a>';
			}
		}


		return $output;

	}
	/**
	 * Render login/sign in option in header
	 *
	 * @return	string	The login HTML string.
	 * @since	2.0.0
	 */
	public function renderLogin()
	{
		$user = Factory::getUser();

		$html = [];
		$html[] = '<div class="sp-module">';

		if ($user->id === 0)
		{
			$html[] = '<a class="sp-sign-in" href="' . Route::_('index.php?option=com_users&view=login') . '" ><span class="far fa-user me-1" aria-hidden="true"></span><span class="signin-text d-none d-lg-inline-block">' . Text::_('HELIX_ULTIMATE_SIGN_IN_MENU') . '</span></a>';
		}
		else
		{
			$html[] = '<div class="sp-profile-wrapper">';
			$html[] = '<a href="#" class="sp-sign-in"><i class="fas fa-user-circle" aria-hidden="true"></i> <span class="user-text d-none d-xl-inline-block"> ' . ($user->name ?? '') . '</span> <i class="fas fa-chevron-down arrow-icon" aria-hidden="true"></i></a>';
			$html[] = '<ul class="sp-profile-dropdown">';
			$html[] = '	<li class="sp-profile-dropdown-item">';
			$html[] = '		<a href="' . Route::_('index.php?option=com_users&view=profile') . '">' . Text::_('HELIX_ULTIMATE_USER_PROFILE') . '</a>';
			$html[] = '	</li>';
			$html[] = '	<li class="sp-profile-dropdown-item">';
			$html[] = '		<a href="' . Route::_('index.php?option=com_users&view=login&layout=logout') . '">' . Text::_('HELIX_ULTIMATE_USER_LOGOUT') . '</a>';
			$html[] = '	</li>';
			$html[] = '</ul>';
			$html[] = '</div>';
		}

		$html[] = '</div>';

		return implode("\n", $html);
	}
}
