<?php

/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2016 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct accees
defined('_JEXEC') or die('restricted aceess');

class SppagebuilderAddonLatest_posts extends SppagebuilderAddons {
	
	public function render() {
		
		$settings = $this->addon->settings;
		
		//Add js
		$app = JFactory::getApplication();
		$doc = JFactory::getDocument();

		// Database Query
		require_once JPATH_SITE . '/components/com_content/src/Helper/RouteHelper.php';
		// Access filter
		$access     = !JComponentHelper::getParams('com_content')->get('show_noauth');
		$authorised = JAccess::getAuthorisedViewLevels(JFactory::getUser()->get('id'));

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		$query
		->select('a.*')
		->from($db->quoteName('#__content', 'a'))
		->select($db->quoteName('b.alias', 'category_alias'))
		->select($db->quoteName('b.title', 'category'))
		->join('LEFT', $db->quoteName('#__categories', 'b') . ' ON (' . $db->quoteName('a.catid') . ' = ' . $db->quoteName('b.id') . ')')
		->where($db->quoteName('b.extension') . ' = ' . $db->quote('com_content'))
		->where($db->quoteName('a.state') . ' = ' . $db->quote(1))
		
		->where($db->quoteName('a.access')." IN (" . implode( ',', $authorised ) . ")")
		->order($db->quoteName('a.id') . ' DESC')
		->setLimit(3);

		if(!empty($settings->category)){
			$query->where($db->quoteName('a.catid')." IN (" . implode( ',', $this->getCategories($settings->category) ) . ")");
		}

		$db->setQuery($query);

		$items = $db->loadObjectList();

		// End Database Query
		$class = (isset($settings->class) && $settings->class) ? ' ' . $settings->class : '';
		$output  = '<div class="sppb-addon sppb-addon-latest-posts ' . $class . '">';
		$output .= '<div class="sppb-addon-content">';
		$output .= '<div class="blog-list-container">';
		$output .= '<div class="row">';
		foreach ($items as $item) {

			$item->slug    = $item->id . ':' . $item->alias;
			$item->catslug = $item->catid . ':' . $item->category_alias;
			$item->user    = JFactory::getUser($item->created_by)->name;

			if ($access || in_array($item->access, $authorised))
			{
				// We know that user has the privilege to view the article
				$item->link = JRoute::_(ContentHelperRoute::getArticleRoute($item->slug, $item->catid, $item->language));
			}
			else
			{
				$item->link = JRoute::_('index.php?option=com_users&view=login');
			}

			$images = json_decode($item->images);

			$image = '';

			if (isset($images->image_intro) && !empty($images->image_intro)) {
				$image = $images->image_intro;
			} elseif (isset($images->image_fulltext) && !empty($images->image_fulltext)) {
				$image = $images->image_fulltext;
			}

			$item->introtext = JHtml::_('content.prepare', $item->introtext, '', 'mod_articles_news.content');
			$output .= '<div class="col-lg-4 col-md-6 col-12 my-3">';
				$output .= '<div class="blog-list-item-inner">';
					if(!empty($image)){
						$output .= '<div class="item-image-wrap">';
							$output .= '<a class="item-image-link" href="' . $item->link . '"></a>';
							$output .= '<img src="'.$image.'"/>';
						$output .= '</div>';
					}
					$output .= '<div class="item-text-holder">';
						$output .= '<div class="info-section">';
							$output .= '<div class="post-info-category">';
								$output .= $item->category;
							$output .= '</div>';
						$output .= '</div>';
								
						$output .= '<h3 class="item-title"><a href="' . $item->link . '">'.$item->title.'</a></h3>';
						$output .= '<div class="item-intro">'.$item->introtext.'</div>';
						$output .= '<div class="item-info-section bottom">';
							$output .= '<div class="post-info-date"><span class="entry-date"><i class="fa fa-calendar-o"></i> ' . JHtml::_('date', $item->created, 'DATE_FORMAT_LC3') . '</span></div>';
							$output .= '<div class="post-info-author">	<span class="entry-author"><i class="fa fa-user"></i> ' . $item->user . '</span></div>';
						$output .= '</div>';	
					$output .= '</div>';
				$output .= '</div>';
			$output .= '</div>';
		}
		$output .= '</div>';
		$output .= '</div>';
		$output .= '</div>';
		$output .= '</div>';

		return $output;
	}

	public function getCategories($parent=1) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		$query
		->select('*')
		->from($db->quoteName('#__categories'))
		->where($db->quoteName('extension') . ' = ' . $db->quote('com_content'))
		->where($db->quoteName('published') . ' = ' . $db->quote(1))
		->where($db->quoteName('parent_id') . ' = ' . $db->quote($parent))
		->order($db->quoteName('created_time') . ' DESC');

		$db->setQuery($query);

		$cats = $db->loadObjectList();

		$categories = array($parent);

		foreach ($cats as $key => $cat) {
			$categories[] = $cat->id;
		}

		return $categories;
	}
	
	public function css() {
		return '';
	}
}