<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');
// Include the syndicate functions only once
require_once(dirname(__FILE__).'/helper.php');
require_once JPATH_SITE.'/components/com_jbusinessdirectory/helpers/defines.php';
require_once HELPERS_PATH.'/utils.php';
require_once HELPERS_PATH.'/translations.php';

JHtml::_('jquery.framework', true, true);

JHtml::_('stylesheet', 'modules/mod_jbusinesscategoriesevents/assets/style.css');
JHtml::_('script', 'modules/mod_jbusinesscategoriesevents/assets/js/script.js');
JBusinessUtil::loadBaseScripts();

if ($params->get('viewtype') == 'slider') {
	JBusinessUtil::enqueueStyle('libraries/slick/slick.css');
	JBusinessUtil::enqueueScript('libraries/slick/slick.js');
} else {
	JBusinessUtil::enqueueStyle('libraries/metis-menu/metisMenu.css');
	JBusinessUtil::enqueueScript('libraries/metis-menu/metisMenu.js');
}

$helper = new modJBusinessCategoriesEventsHelper();

JBusinessUtil::includeCSSLibraries();
JBusinessUtil::loadSiteLanguage();
$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));

$categoriesIds = $params->get('categoryIds');

if ($params->get('viewtype') == 'slider') {
	$categories = $helper->getCategoriesByIdsOnSlider($categoriesIds);
} elseif ($params->get('viewtype') == 'menu') {
	$categories = $helper->getCategoriesByIdsOnMenu($categoriesIds);
} else {
	$categories = $helper->getCategories($categoriesIds, true);
}

$appSettings = JBusinessUtil::getApplicationSettings();

if ($appSettings->enable_multilingual) {
	JBusinessDirectoryTranslations::updateCategoriesTranslation($categories);
}

$viewAllLink = JRoute::_('index.php?option=com_jbusinessdirectory&view=categories&categoryType='.CATEGORY_TYPE_EVENT);
$span = $params->get('phoneGridOption', 'col-12').' '.$params->get('tabletGridOption', 'col-md-6').' '.$params->get('desktopGridOption', "col-lg-4");

require JModuleHelper::getLayoutPath('mod_jbusinesscategoriesevents', "default_".$params->get('viewtype'));
