<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_jbusiness_user
 *
 * @copyright   Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

// Include the login functions only once
JLoader::register('ModJBusinessUserHelper', __DIR__ . '/helper.php');
require_once JPATH_SITE.'/components/com_jbusinessdirectory/helpers/defines.php';
require_once HELPERS_PATH.'/utils.php';
require_once HELPERS_PATH.'/translations.php';

if(file_exists( BD_CLASSES_PATH.'/services/OfferSellingService.php')){
    require_once BD_CLASSES_PATH.'/services/OfferSellingService.php';
}
JHtml::_('jquery.framework', true, true);

JBusinessUtil::includeCSSLibraries();
JHtml::_('stylesheet', 'modules/mod_jbusiness_user/assets/css/style.css');

JBusinessUtil::loadJQueryUI();
JBusinessUtil::loadBaseScripts();

JBusinessUtil::enqueueStyle('libraries/modal/jquery.modal.css');
JBusinessUtil::enqueueScript('libraries/modal/jquery.modal.js');

$appSettings = JBusinessUtil::getApplicationSettings();
if ($appSettings->enable_multilingual) {
    JBusinessDirectoryTranslations::updateEntityTranslation($appSettings, TERMS_CONDITIONS_TRANSLATION);
    JBusinessDirectoryTranslations::updateEntityTranslation($appSettings, PRIVACY_POLICY_TRANSLATION);
}
$params->def('greeting', 1);

$type             = ModJBusinessUserHelper::getType();
$return           = ModJBusinessUserHelper::getReturnUrl($params, $type);
$twofactormethods = JAuthenticationHelper::getTwoFactorMethods();
$user             = JBusinessUtil::getUser();
$layout           = $params->get('layout', 'default');

$cartItemsCount = ModJBusinessUserHelper::getCartItemsCount();

$businesUserGroups = $params->get("business_usergroups");
$intersect = array();
if(!empty($businesUserGroups)){
    $intersect  = array_intersect($businesUserGroups, $user->groups);
}

$dashboardLink = JRoute::_('index.php?option=com_jbusinessdirectory&view=userdashboard');
if(!empty($intersect)){
    $dashboardLink = JRoute::_('index.php?option=com_jbusinessdirectory&view=useroptions');
}


require JModuleHelper::getLayoutPath('mod_jbusiness_user', $layout);
