<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Factory;

require_once JPATH_SITE.'/components/com_jbusinessdirectory/helpers/defines.php';
require_once HELPERS_PATH.'/utils.php';

JBusinessUtil::enqueueStyle('css/common.css');
JBusinessUtil::enqueueStyle('css/line-awesome.css');

$appSettings = JBusinessUtil::getApplicationSettings();

JHtml::_('stylesheet', 'modules/mod_jbusiness_offers/assets/style.css');
JHtml::_('script', 'modules/mod_jbusiness_offers/assets/js/script.js');

JHtml::_('jquery.framework', true, true);

if ($params->get('viewtype') == 'slider') {
	JBusinessUtil::enqueueStyle('libraries/slick/slick.css');
	JBusinessUtil::enqueueScript('libraries/slick/slick.js');
}

JBusinessUtil::enqueueStyle('libraries/modal/jquery.modal.css');
JBusinessUtil::enqueueScript('libraries/modal/jquery.modal.js');

if ($appSettings->enable_ratings) {
	JBusinessUtil::enqueueStyle('libraries/star-rating/star-rating.css');
	JBusinessUtil::enqueueScript('libraries/star-rating/star-rating.js');
}

JBusinessUtil::loadBaseScripts();

require_once HELPERS_PATH.'/translations.php';

// Include the syndicate functions only once
require_once __DIR__ . '/helper.php';

JBusinessUtil::loadSiteLanguage();
JBusinessUtil::includeCSSLibraries();
JBusinessUtil::loadClasses();

//load items through cache mechanism
$cache = Factory::getCache('mod_jbusiness_offers', '');
if ($cache->contains($module->id)) {
	$items = $cache->get($module->id);
} else {
	$items = modJBusinessOffersHelper::getList($params);
	$cache->store($items, $module->id, 'mod_jbusiness_offers');
}

$showLocation = $params->get('showLocation');
$showListingName = $params->get('showlistingName');
$showFreeText = $params->get('showOfferFree');

$appSettings = JBusinessUtil::getApplicationSettings();
if ($appSettings->enable_multilingual) {
	JBusinessDirectoryTranslations::updateOffersTranslation($items);
}

$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));

$backgroundCss="";
if ($params->get('backgroundColor')) {
	$backgroundCss = "background-color:".$params->get('backgroundColor').";";
}

$borderCss="";
if ($params->get('borderColor')) {
	$borderCss="border-color:".$params->get('borderColor').";";
}

$categoryParam = "";
$categoriesIds = $params->get('categoryIds');
if (isset($categoriesIds) && count($categoriesIds)>0 && $categoriesIds[0]!= 0 && $categoriesIds[0]!= "") {
	$categoryParam="&categorySearch=".$categoriesIds[0];
}

$itemType ="";
if ($params->get('itemType')) {
	$itemType="&itemType=".$params->get('itemType');
}

$menuItemId ="";
if ($params->get('mItemId')) {
	$menuItemId="&Itemid=".$params->get('mItemId');
}
$viewAllLink = JRoute::_('index.php?option=com_jbusinessdirectory&view=offers&resetSearch=1'.$menuItemId.$categoryParam.$itemType);

$newTab = ($appSettings->open_listing_on_new_tab)?" target='_blank'":"";
$span = $params->get('layout-type')=="vertical"?"col-12":$params->get('phoneGridOption', 'col-12').' '.$params->get('tabletGridOption', 'col-md-6').' '.$params->get('desktopGridOption', "col-lg-4");

echo OfferSellingService::getCartModal();

require JModuleHelper::getLayoutPath('mod_jbusiness_offers', "default_".$params->get('viewtype'));
