<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');

require_once JPATH_SITE.'/components/com_jbusinessdirectory/helpers/defines.php';
require_once HELPERS_PATH.'/utils.php';
require_once HELPERS_PATH.'/translations.php';

// Include the syndicate functions only once
require_once(dirname(__FILE__).DS.'helper.php');

JHtml::_('jquery.framework', true, true);

JBusinessUtil::includeCSSLibraries();

JText::script('LNG_SELECT_OPTION');

JBusinessUtil::enqueueStyle('libraries/range-slider/ion.rangeSlider.css');
JBusinessUtil::enqueueStyle('libraries/range-slider/ion.rangeSlider.skinFlat.css');
JHtml::_('stylesheet', 'media/com_jbusinessdirectory/css/search-module.css');

JBusinessUtil::loadJQueryUI();
JBusinessUtil::loadJQueryChosen();

JBusinessUtil::loadBaseScripts();
JBusinessUtil::loadMapScripts();

JBusinessUtil::enqueueScript('libraries/range-slider/ion.rangeSlider.js');
JHtml::_('script', 'modules/mod_jbusiness_offer_search/assets/js/script.js');

$session = JFactory::getSession();
JBusinessUtil::loadSiteLanguage();
$appSettings = JBusinessUtil::getApplicationSettings();
$geoLocation = $session->get("geolocation");

$jsSettings = JBusinessUtil::addJSSettings();
$jsSettings->isProfile = 1;
$appSettings = JBusinessUtil::getApplicationSettings();
$key="";
if (!empty($appSettings->google_map_key)) {
	$key="&key=".$appSettings->google_map_key;
}
$lang = JBusinessUtil::getLanguageTag();

if (!defined('JBD_UTILS_LOADED')) {
	$document = JFactory::getDocument();
	$document->addScriptDeclaration('
		window.addEventListener("load",function() {
	        jbdUtils.setProperties(' . json_encode($jsSettings) . ');
			jbdUtils .renderRadioButtons();
		});
	');
	define('JBD_UTILS_LOADED', 1);
}


if ($params->get('showCountries')) {
	$countries = modJBusinessOfferSearchHelper::getCountries();
	if ($appSettings->enable_multilingual) {
		JBusinessDirectoryTranslations::updateCountriesTranslation($countries);
	}
}

$choices = 0;
if ($params->get('linklocation')) {
	if ($params->get('showCountries') && !$params->get('showRegions')) {
		$choices = 1;
	} elseif ($params->get('showCountries')) {
		$choices = 2;
	} elseif ($params->get('showRegions')) {
		$choices = 3;
	}
}

$categories = array();
$subCategories = array();
$separateCategories  = $params->get('separateCategories');
$availableCategories = $params->get('availableCategories');
if (is_array($availableCategories) && !($availableCategories[0]==0 && count($availableCategories)==1)) {
	$categories = modJBusinessOfferSearchHelper::getMainCategories();
	$subCategories = modJBusinessOfferSearchHelper::getSubCategories();

	if ($appSettings->enable_multilingual) {
		JBusinessDirectoryTranslations::updateCategoriesTranslation($categories);
		JBusinessDirectoryTranslations::updateCategoriesTranslation($subCategories);
	}

	$availableCategories = array_filter($availableCategories);
	if (!empty($availableCategories)) {
		foreach ($categories as $key => $category) {
			if (!in_array($category->id, $availableCategories)) {
				unset($categories[$key]);
			}
		}
		foreach ($subCategories as $key => $category) {
			if (!in_array($category->id, $availableCategories)) {
				unset($subCategories[$key]);
			}
		}
	}
	foreach ($categories as $category) {
		foreach ($subCategories as $key => $subCat) {
			if ($category->id == $subCat->parent_id) {
				if (!isset($category->subcategories)) {
					$category->subcategories = array();
				}
				$category->subcategories[] = $subCat;
				unset($subCategories[$key]);
			}
		}
	}
	$params->set('separateCategories', 0);
	$separateCategories = 0;
} elseif ($params->get('showCategories')) {
	$categories = modJBusinessOfferSearchHelper::getMainCategories();
	$subCategories = modJBusinessOfferSearchHelper::getSubCategories();

	if ($appSettings->enable_multilingual) {
		JBusinessDirectoryTranslations::updateCategoriesTranslation($categories);
		JBusinessDirectoryTranslations::updateCategoriesTranslation($subCategories);
	}

	if ($params->get('showSubCategories') && !$separateCategories) {
		foreach ($categories as $category) {
			foreach ($subCategories as $key => $subCat) {
				if ($category->id == $subCat->parent_id) {
					if (!isset($category->subcategories)) {
						$category->subcategories = array();
					}
					$category->subcategories[] = $subCat;
				}
			}
		}
	}
}

if ($appSettings->category_order == ORDER_ALPHABETICALLY && count($categories)>0) {
	require_once HELPERS_PATH.'/category_lib.php';
	$categoryService = new JBusinessDirectorCategoryLib();
	$categories = $categoryService->sortCategories($categories, false, true);
}

if (is_array($availableCategories)) {
	reset($availableCategories);
	if (!(current($availableCategories)==0 && count($availableCategories)==1)) {
		foreach ($subCategories as $key => $subCat) {
			end($categories)->subcategories[] = $subCat;
		}
	}
}

if ($appSettings->enable_multilingual) {
	JBusinessDirectoryTranslations::updateCategoriesTranslation($categories);
}

$attributes = $params->get('customAttributes');
$atrributesValues = $session->get('customAtrributes');
if (!$params->get('preserve')) {
	$atrributesValues = array();
}

if (!empty($attributes)) {
	$customAttributes = modJBusinessOfferSearchHelper::getCustomAttributes($attributes, $atrributesValues);
}

if ($params->get('showCities')) {
	if ($appSettings->limit_cities_regions ==1) {
		$cities =  modJBusinessOfferSearchHelper::getActivityCities();
	} else {
		$cities =  modJBusinessOfferSearchHelper::getCities();
	}
}

if ($params->get('showTypes')) {
	$types =  modJBusinessOfferSearchHelper::getTypes();
	JBusinessDirectoryTranslations::updateOfferMainTypesTranslation($types);
}

if ($params->get('showRegions')) {
	if ($appSettings->limit_cities_regions == 1) {
		$regions = modJBusinessOfferSearchHelper::getActivityRegions();
	} else {
		$regions = modJBusinessOfferSearchHelper::getRegions();
	}
}

if ($params->get('showProvince')) {
	$provinces = modJBusinessOfferSearchHelper::getProvinces();
}

if ($params->get('showMap')) {
	$maxOffers = $params->get('maxOffers');
	if (empty($maxOffers)) {
		$maxOffers = 200;
	}
	$offers =  modJBusinessOfferSearchHelper::getOffers($maxOffers, $params->get('itemType'));
}

$menuItemId ="";
if ($params->get('mItemId')) {
	$menuItemId="&Itemid=".$params->get('mItemId');
}

$maxPrice = $params->get("max-price");
if (empty($maxPrice)) {
	$maxPrice = 1000;
}

$layoutType = $params->get('layout-type', 'horizontal');
$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));

$radius = JFactory::getApplication()->input->getInt("radius");
if (!isset($radius)) {
	$radius = $params->get('radius');
}

$bgStyle = !empty($params->get('bg-color'))?"padding: 20px;background-color:".$params->get('bg-color'):"";
	
require(JModuleHelper::getLayoutPath('mod_jbusiness_offer_search', $params->get('base-layout', 'default')));
