<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');


JBusinessUtil::includeValidation();

class JBusinessDirectoryViewPayment extends JViewLegacy {
	public function __construct() {
		parent::__construct();
	}
	
	
	public function display($tpl = null) {
		$layout = JFactory::getApplication()->input->get('layout', null);
		if (isset($layout)) {
			$tpl = $layout;
		}
		
		$this->order = $this->get('Order');
		
		if(empty($this->order) && $tpl=="response" ){
			$app =JFactory::getApplication();
			$app->redirect(JRoute::_('index.php'));
		}
		
		$this->paymentMethods = PaymentService::getPaymentProcessors(true, JBD_PACKAGES, DEFAULT_PAYMENT_PROCESSOR);
		$this->paymentMethods = JBusinessUtil::filterPaymentMethods($this->order, $this->paymentMethods);
		
		$this->state = $this->get('State');
		$this->appSettings = JBusinessUtil::getApplicationSettings();
		$this->companyId = JFactory::getApplication()->input->get("companyId");
		$this->discount_code = JFactory::getApplication()->input->get("discount_code", "");
		
		parent::display($tpl);
	}
	
	public function getPaymentMethodFormHtml($paymentMethod) {
		return JText::_("LNG_PAYMENT_REDIRECT");
	}
}
