<?php // no direct access
/**
* @copyright	Copyright (C) 2008-2009 CMSJunkie. All rights reserved.
* 
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
* See the GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

defined('_JEXEC') or die('Restricted access');

$document = JFactory::getDocument();
$config = JBusinessUtil::getSiteConfig();

$title = JText::_("LNG_PACKAGES").' | '.$config->sitename;
$title = JBusinessUtil::getPageTitle($title);
JBusinessUtil::setMetaData($title, "", "", true);
$appSettings = JBusinessUtil::getApplicationSettings();

if (!isset($packages)) {
    $packages = $this->packages;
}
if (!isset($packageInfo)) {
    $packageInfo = $this->packageInfo;
}

if (!isset($claimListingId)) {
    $claimListingId = $this->claimListingId;
}

if(!$appSettings->enable_packages){
	JFactory::getApplication()->enqueueMessage(JText::_('LNG_PACKAGES_ARE_NOT_ENABLED'),"notice");
}
	
$task = "managecompany.addListing";
if($appSettings->user_login_position != 2 || JFactory::getApplication()->input->get("packageType") == PACKAGE_TYPE_USER){
	$task = "businessuser.checkUser";
}
if(!empty($claimListingId)){
    $task = "managecompany.createOrder";
}

$gridClass="col-lg-4";
if(!empty($packages) && count($packages)>3){
    $gridClass="col-lg-3";
}

$prices = array("paid"=>1,"free"=>0);
$recurringPeriod = array("monthly"=>"M","yearly"=>"Y");
if(!$appSettings->display_packages_by_period){
	$recurringPeriod = array(""=>"");
}
?>

<?php
    if (!empty($packages)){
        $nrPackages = count($packages);
?>
	<div class="jbd-container">
		<div id="plans-container">
			<?php if(empty($claimListingId)){?>
				<div id="process-container" class="process-container">
					<ol class="process-steps">
						<li class="is-active inbox" data-step="1">
							<p><?php echo JText::_("LNG_CHOOSE_PACKAGE")?></p>
						</li>
						<li class="user" data-step="2">
							<p><?php echo JText::_("LNG_BASIC_INFO")?></p>
						</li>
						<li class="progress__last file-text" data-step="3">
							<p><?php echo JText::_("LNG_LISTING_INFO")?></p>
						</li>
					</ol>
					<div class="clear"></div>
				</div>
			<?php }?>
		
			<?php if(!empty($packageInfo)) { ?>
				<div class="package-header">
					<p><?php echo $packageInfo ?></p>
				</div>
			<?php } ?>

			<div class="packages-info-container">
				<div class="packages-info-title">
					<?php echo JText::_("LNG_PACKAGES_INFO_TITLE")?>
				</div>
				<div class="packages-info-text">
					<?php echo JText::_("LNG_PACKAGES_INFO_TEXT")?>
				</div>
			</div>

			<?php if($appSettings->display_packages_by_period){ ?>
				<div class="d-flex pb-2">
					<div class="period-toggle">
						<span><?php echo JText::_("LNG_MONTHLY")?></span>
						<div class="jtoggle-text">
							<input id="jtoggle-period" type="checkbox">
							<label for="jtoggle-period">
								<span class="jtoggle-text-on">&nbsp;</span>
								<span class="jtoggle-text-on">&nbsp;</span>
							</label>
						</div>
						<span><?php echo JText::_("LNG_YEARLY")?> <span class="small"><?php echo JText::_("LNG_YEARLY_DISCUNT_INFO")?> </span></span>
					</div>
				</div>
			<?php } ?>

			<form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=businessuser'); ?>" method="post" name="package-form" id="package-form" >
				<?php foreach($prices as $index=>$price){?>
					<?php if($price == 0 && $appSettings->display_free_packages_bellow){ ?>
						<div class="badge badge-success">
							<?php echo JText::_("LNG_FREE")?>
						</div>
					<?php } ?>
					<?php foreach($recurringPeriod as $index2=>$period){?>
						<div class="jpackage-container row justify-content-md-center packages-<?php echo $index ?> packages-<?php echo $index2 ?>">
							<?php $k=0;?>  
							<?php foreach($packages as $package){?>
								<?php if($appSettings->display_free_packages_bellow && ((floatval($price)!=0 && floatval($package->price)==0) || (floatval($price)==0 && floatval($package->price)!=0))) {continue;}?>
								<?php if($appSettings->display_packages_by_period && $period != $package->time_unit && floatval($price)!=0){ continue; }?>
								<?php $k= $k+1; ?>
								<div class="<?php echo $gridClass ?>">
									<?php require "default_package.php" ?>
								</div>
								
								<?php if($k%4==0 && count($packages)>4){ ?>
									</div>
									<div class="jpackage-container row justify-content-md-center">
								<?php } ?>
							<?php } ?>
						</div>
						<?php if(floatval($price)==0 || !$appSettings->display_packages_by_period) break; ?>
					<?php } ?>
					<?php if(!$appSettings->display_free_packages_bellow) break; ?>
				<?php } ?>

				<input type="hidden" name="option" value="<?php echo JBusinessUtil::getComponentName()?>" /> 
				<input type="hidden" name="filter_package" id="filter_package" value="" />
				<input type="hidden" name="packageType" id="packageType" value="" />
				<input type="hidden" name="claim_listing_id" value="<?php echo $this->claimListingId ?>" />
				<input type="hidden" name="task" value="<?php echo $task ?>" />
			</form>

			<div class="packages-info-text">
				<?php echo JText::_("LNG_PACKAGES_INFO_TEXT_BOTTOM")?>
			</div>
		</div>
	</div>
<?php } ?>
<script>

window.addEventListener('load', function(){
	//jQuery('div.featured-product-col').removeClass("highlight");
	jQuery('div.higlight-enable').mouseenter(function() {
		jQuery(this).addClass("highlight");
	}).mouseleave(function() {
		jQuery(this).removeClass("highlight");
	});

	calibrateElements();
	jQuery(window).resize(function(){
		calibrateElements();
	});

	<?php if($appSettings->display_packages_by_period){ ?>
		jQuery('.packages-paid.packages-yearly').hide();
		jQuery("#jtoggle-period").change(function(){
			let val = jQuery(this).prop("checked");
			console.debug(val);
			if(val){
				jQuery('.packages-paid.packages-yearly').show();
				jQuery('.packages-paid.packages-monthly').hide();
			}else{
				jQuery('.packages-paid.packages-yearly').hide();
				jQuery('.packages-paid.packages-monthly').show();
			}
		});
	<?php } ?>
});


function calibrateElements(){

	var height=0;
	jQuery(".jpackage-desc").each(function(){
		if(height<jQuery(this).height()){
			height = jQuery(this).height();
		}
	});

	jQuery(".jpackage-desc").each(function(){
		jQuery(this).height(height);
	});

	var height=0;
	jQuery(".jpackage-title").each(function(){
		if(height<jQuery(this).height()){
			height = jQuery(this).height();
		}
	});

	jQuery(".jpackage-title").each(function(){
		jQuery(this).height(height);
	});
};	

function selectPackage(packageId, packageType){
		jQuery("#filter_package").val(packageId);
		jQuery("#packageType").val(packageType);
		jQuery("#package-form").submit();
}

</script>