<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');

JBusinessUtil::loadJQueryChosen();

// following translations will be used in js
JText::script('LNG_SHOW_FILTER');
JText::script('LNG_DISTANCE');
JText::script('LNG_MILES');
JText::script('LNG_KM');
JText::script('LNG_CATEGORIES');
JText::script('LNG_MORE');
JText::script('LNG_LESS');
JText::script('LNG_TYPES');
JText::script('LNG_COUNTRIES');
JText::script('LNG_REGIONS');
JText::script('LNG_CITIES');
JText::script('LNG_AREA');
JText::script('LNG_PROVINCE');

class JBusinessDirectoryViewOffers extends JViewLegacy {
	public function __construct() {
		parent::__construct();
	}
	
	public function display($tpl = null) {
		$session = JFactory::getSession();
		$this->appSettings =  JBusinessUtil::getApplicationSettings();
		$this->defaultAttributes = JBusinessUtil::getAttributeConfiguration(DEFAULT_ATTRIBUTE_TYPE_OFFER);
		$state = $this->get('State');
		$this->params = $state->get("parameters.menu");
		
		$this->offers = $this->get('Items');
		$this->location = $this->get("Location");
		$jinput = JFactory::getApplication()->input;
		$this->zipCode = $jinput->getString('zipcode');
		
		$this->orderBy = $jinput->getString("orderBy", $this->appSettings->order_search_offers);
		$this->categoryOptions = JBusinessUtil::getCategoriesOptions(true, CATEGORY_TYPE_OFFER);

		$this->categorySearch = $jinput->getInt('categorySearch', null);
		$this->citySearch = $jinput->getString('citySearch', null);
		$this->regionSearch = $jinput->getString('regionSearch', null);
		$this->areaSearch = $jinput->getString('areaSearch', null);
		$this->countrySearch = $jinput->getInt('countrySearch', null);
		$this->country = $this->get('Country');
		$this->provinceSearch = $jinput->getString('provinceSearch', null);
		$this->minPrice = $jinput->get('minprice', null);
		$this->maxPrice = $jinput->get('maxprice', null);
		$this->type = $this->get("OfferType");

		$this->typeSearch = $jinput->getInt('typeSearch', null);
		if (!empty($this->typeSearch)) {
			$this->typeSearchName = $this->get('Type')->name;
		}

		$searchkeyword = $jinput->getString('searchkeyword');
		if (isset($searchkeyword)) {
			$this->searchkeyword=  $searchkeyword;
		}
		$this->selectedParams = $this->get('SelectedParams');
		$this->categories = implode(";", $this->get("SelectedCategories"));
		if (!empty($this->categories)) {
			$this->categories.=";";
		}
		
		$this->selectedCategories = $this->get("SelectedCategories");
		
		$this->preserve = $jinput->get('preserve', null);

		$this->customAtrributes = $session->get('customAtrributes');
		$this->customAtrributesValues = $this->get("CustomAttributeValues");

		$categoryId= $this->get('CategoryId');
		if (!empty($categoryId)) {
			$this->categoryId=$categoryId;
			$this->category = $this->get('Category');
		}
		
		if ($this->appSettings->enable_search_filter_offers) {
			$this->searchFilter = $this->get('SeachFilter');
		}

		$session = JFactory::getSession();
		$this->radius= $session->get('of-radius');
		$this->geoLatitude = $session->get('geo-latitude');
		
		$this->pagination = $this->get('Pagination');
		$this->sortByOptions = $this->get('SortByConfiguration');
		
		parent::display($tpl);
	}
}
