<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');
$user = JBusinessUtil::getUser();
?>

<div id="offer-list-view" itemscope itemtype="http://schema.org/OfferCatalog" class="offer-list-style-2 list-style-8" <?php echo $this->appSettings->offers_view_mode ?'style="display: none"':'' ?>>
    <?php if(!empty($this->offers)){?>
        <?php foreach ($this->offers as $offer){?>
            <div itemscope itemprop="itemListElement" itemtype="http://schema.org/Offer">
                <div class="result-item shadow-border <?php echo !empty($offer->featured)?"featured":"" ?>">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="item-image">
                                <a href="<?php echo $offer->link ?>" itemprop="image" itemscope itemtype="http://schema.org/ImageObject"> </a>
                                <?php if(!empty($offer->picture_path)){?>
                                    <img  alt="<?php $this->escape($offer->subject) ?>" src="<?php echo BD_PICTURES_PATH.$offer->picture_path?>" itemprop="">
                                <?php }else{?>
                                    <img title="<?php echo $this->escape($offer->subject)?>" alt="<?php echo $this->escape($offer->subject)?>" src="<?php echo BD_PICTURES_PATH.'/no_image.jpg' ?>" itemprop="">
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-md">
                            <div class="row">
                                <div class="col-md">
                                    <h3 itemprop="url">
                                        <a title="<?php echo $this->escape($offer->subject)?>"
                                           href="<?php echo $this->escape($offer->link) ?>"><span itemprop="name"><?php echo $this->escape($offer->subject) ?></span>
                                        </a>
                                    </h3>

                                    <?php if((!empty($offer->startDate) && $offer->startDate!="0000-00-00") || (!empty($offer->endDate) && $offer->endDate!="0000-00-00")){?>
                                        <div>
                                            <i class="icon calendar"></i>
                                            <?php
                                            echo JBusinessUtil::getDateGeneralFormat($offer->startDate)." - ". JBusinessUtil::getDateGeneralFormat($offer->endDate);
                                            ?>
                                        </div>
                                    <?php } ?>
                                    <?php if(!empty($offer->show_time) && JBusinessUtil::getRemainingtime($offer->endDate, $offer->time_zone)!=""){?>
                                        <div>
                                            <span ><i class="icon clock"></i> <?php echo JBusinessUtil::getRemainingtime($offer->endDate, $offer->time_zone)?></span>
                                        </div>
                                    <?php } ?>

                                    <?php if(!empty($offer->offerType)){?>
                                        <div>
                                            <span ><i class="la la-file-alt"></i> <?php echo $this->escape($offer->offerType)?></span>
                                        </div>
                                    <?php } ?>


                                    <?php if(!empty($offer->categories)){?>
                                        <div>
                                            <?php foreach($offer->categories as $i=>$category){ ?>
                                                <a href="<?php echo JBusinessUtil::getOfferCategoryLink($category[0], $category[2]) ?>"><?php echo $this->escape($category[1])?></a><?php echo $i<(count($offer->categories)-1)? ',&nbsp;':'' ?>
                                            <?php } ?>
                                        </div>
                                    <?php } ?>

                                    <?php if(!empty($offer->distance)){?>
                                        <div>
                                            <?php echo JText::_("LNG_DISTANCE").": ".round($offer->distance,1)." ". ($this->appSettings->metric==1?JText::_("LNG_MILES"):JText::_("LNG_KM")) ?>
                                        </div>
                                    <?php } ?>
                                </div>
                                <div class="col-md-3">
                                    <div class="offer-price">
                                        <div>
                                            <?php if(!empty($offer->price) ){ ?>
                                                <span class="<?php echo $offer->specialPrice>0 ?"old-price":"" ?>"><?php echo JBusinessUtil::getPriceFormat($offer->price, $offer->currencyId) ?></span>
                                            <?php } ?>
                                            <?php if(!empty($offer->specialPrice)){?>
                                                <span class="price red"><?php echo JBusinessUtil::getPriceFormat($offer->specialPrice, $offer->currencyId); ?></span>
                                            <?php }?>
                                            <?php if(!empty($offer->specialPrice) && !empty($offer->price) && $offer->specialPrice < $offer->price){ ?>
                                                <br />
                                                <span class="price discount"><?php echo JText::_('LNG_DISCOUNT') ?></span>
                                                <span class="price red"><?php echo JBusinessUtil::getPriceDiscount($offer->specialPrice, $offer->price) ?>%</span>
                                            <?php } ?>
                                        </div>
                                        
                                        <br/>
                                        <?php if ($this->defaultAttributes["price_text"]!=ATTRIBUTE_NOT_SHOW) { ?>
                                            <div class="price-text-list">
                                                <?php if (!empty($offer->price_text)) { ?>
                                                    <div class="clear"></div>
                                                    <span  class="price red"><?php echo $offer->price_text ?></span>
                                                <?php }elseif (empty($offer->price) && empty($offer->specialPrice) && ($appSettings->show_offer_free)){ ?>
                                                    <div class="clear"></div>
                                                    <span class="price red"><?php echo JText::_('LNG_FREE') ?></span>
                                                <?php } ?>
                                            </div>
                                        <?php } ?>

                                    </div>
                                    
                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
	                                <?php //echo OfferSellingService::getAddToCartBtn($offer, 'w-50') ?>
                                </div>
                                <div class="col">
                                    <div class="right m-1">
                                            <?php if(!empty($company->bookmark)) { ?>
                                                <!-- Business Bookmarks -->
                                                <a id="bookmark-<?php echo $offer->id ?>" href="javascript:jbdUtils.showUpdateBookmarkDialog(<?php echo $user->id==0?"1":"0"?>, <?php echo $offer->id ?>,<?php echo BOOKMARK_TYPE_OFFER ?>)"  title="<?php echo JText::_("LNG_UPDATE_BOOKMARK")?>" class="bookmark"><i class="la la-heart"></i></a>
                                            <?php } else {?>
                                                <a id="bookmark-<?php echo $offer->id ?>" href="javascript:jbdUtils.showAddBookmark(<?php echo $user->id==0?"1":"0"?>, <?php echo $offer->id ?>,<?php echo BOOKMARK_TYPE_OFFER ?>)" title="<?php echo JText::_("LNG_ADD_BOOKMARK")?>" class="bookmark"><i class="la la-heart-o"></i></a>
                                            <?php } ?>
                                        </div>
                                    <?php if(isset($offer->featured) && $offer->featured==1){ ?>
                                        <div class="featured-text mr-5">
                                            <?php echo JText::_("LNG_FEATURED")?>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    <?php }?>
</div>
<?php require_once JPATH_COMPONENT_SITE . '/include/bookmark_utils.php'; ?>