<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');
?>

<div id="offer-list-view" itemscope itemtype="http://schema.org/OfferCatalog" class="" <?php echo $this->appSettings->offers_view_mode?'style="display: none"':'' ?>>
	<?php if(!empty($this->offers)) { ?>
		<?php foreach ($this->offers as $offer) { ?>
			<div itemscope itemprop="itemListElement" itemtype="http://schema.org/Offer">
				<div class="result-item <?php echo !empty($offer->featured)?"featured":"" ?>">
					<div class="row">
						<div class="col-md-3">
							<div class="item-image">
	    						<a href="<?php echo $offer->link ?>">
	    							<?php if(!empty($offer->picture_path) && $offer->picture_path!=''){?>
	    								<img itemprop="image" title="<?php echo $offer->picture_title ?>" alt="<?php echo $offer->picture_info ?>" src="<?php echo BD_PICTURES_PATH.$offer->picture_path?>" itemprop="">
	    							<?php }else{?>
	    								<img itemprop="image" title="<?php echo $this->escape($offer->subject)?>" alt="<?php echo $this->escape($offer->subject)?>" src="<?php echo BD_PICTURES_PATH.'/no_image.jpg' ?>" itemprop="">
	    							<?php } ?>
	    						</a>
								<?php if(isset($offer->featured) && $offer->featured==1){ ?>
									<div class="featured-text">
										<?php echo JText::_("LNG_FEATURED")?>
									</div>
								<?php } ?>
	    					</div>
						</div>
						<div class="col-md">
							<div class="result-content">
								<div class="row">
									<div class="col-md">
										<h3 itemprop="url">
											<a title="<?php echo $this->escape($offer->subject)?>"
												href="<?php echo $this->escape($offer->link) ?>"><span itemprop="name"><?php echo $this->escape($offer->subject)?></span>
											</a>
										</h3>
										<div class="short-description" itemprop="description">
											<?php echo $offer->short_description ?>
										</div>
									</div>
								</div>
								<div class="row align-items-end">
									<div class="col-md">

										<?php if(!empty($offer->company_name)){?>
											<div itemprop="offeredBy" itemscope itemtype="http://schema.org/Organization">
												<span><i class="icon business"></i><span itemprop="name"> <?php echo $this->escape($offer->company_name) ?></span></span>
											</div>
										<?php } ?>
														
										<?php $address =JBusinessUtil::getShortAddress($offer); ?>
										<?php if(!empty($address)){ ?>
											<div itemprop="address" itemscope itemtype="https://schema.org/PostalAddress">
												<span><i class="icon map-marker"></i> <?php echo $address ?></span>
												
												<?php if(!empty($offer->latitude) && !empty($offer->longitude)){?>
													- <a target="_blank" class="nowrap" href="<?php echo JBusinessUtil::getDirectionURL($this->location, $offer) ?>"><?php echo JText::_("LNG_GET_MAP_DIRECTIONS")?></a>
												<?php }?>
												
											</div>
										<?php } ?>
										
										<?php if((!empty($offer->startDate) && $offer->startDate!="0000-00-00") || (!empty($offer->endDate) && $offer->endDate!="0000-00-00")){?>
											<div>
												<i class="icon calendar"></i>
												<?php 
													echo JBusinessUtil::getDateGeneralFormat($offer->startDate)." - ". JBusinessUtil::getDateGeneralFormat($offer->endDate);
												?>
											</div>
										<?php } ?>
										<?php if(!empty($offer->show_time) && JBusinessUtil::getRemainingtime($offer->endDate, $offer->time_zone)!=""){?>
											<div>
												<span ><i class="icon clock"></i> <?php echo JBusinessUtil::getRemainingtime($offer->endDate, $offer->time_zone)?></span>
											</div>
										<?php } ?>
			
										<?php if(!empty($offer->distance)){?>
											<div>
												<?php echo JText::_("LNG_DISTANCE").": ".round($offer->distance,1)." ". ($this->appSettings->metric==1?JText::_("LNG_MILES"):JText::_("LNG_KM")) ?>
											</div>
										<?php } ?>
									</div>
									<div class="col-md-4">
										<div class="offer-price">
											<div>
												<?php if(!empty($offer->specialPrice)){?>
													<span style="display:none;" itemprop="price" content="<?php echo $offer->specialPrice ?>"/>
													<span style="display:none;" itemprop="priceCurrency" content="<?php echo JBusinessUtil::getCurrency($offer->currencyId)->currency_name ?>"/>
													<span style="display:none;" itemprop="priceValidUntil" content="<?php echo $offer->endDate ?>"/>
													
													<span class="price"><?php echo JBusinessUtil::getPriceFormat($offer->specialPrice, $offer->currencyId); ?></span>
												<?php }?>

												<?php if(!empty($offer->price) ){ ?>
													<span class="price <?php echo $offer->specialPrice>0 ?"old-price":"" ?>"><?php echo JBusinessUtil::getPriceFormat($offer->price, $offer->currencyId) ?></span>
												<?php } ?>


												<?php if(!empty($offer->specialPrice) && !empty($offer->price) && $offer->specialPrice < $offer->price){ ?>
													<div class="offer-discount">
														<span class="discount"><?php echo JBusinessUtil::getPriceDiscount($offer->specialPrice, $offer->price) ?>%</span>	
														<span class=""><?php echo JText::_('LNG_DISCOUNT') ?></span>
													</div>
												<?php } ?>
											</div>
											
											<?php if ($this->defaultAttributes["price_text"]!=ATTRIBUTE_NOT_SHOW) { ?>
												<div class="price-text-list">
													<?php if (!empty($offer->price_text)) { ?>
														<span class="price-text"><?php echo $offer->price_text ?></span>
													<?php }elseif (empty($offer->price) && empty($offer->specialPrice) && ($appSettings->show_offer_free)){ ?>
														<span class="price-text"><?php echo JText::_('LNG_FREE') ?></span>
													<?php } ?>
												</div>
											<?php } ?>
											<?php //echo OfferSellingService::getAddToCartBtn($offer) ?>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		<?php } ?>
	<?php }?>
</div>
