<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );

if (! defined ( 'BD_COMPONENT_IMAGE_PATH' ))
	define ( "BD_COMPONENT_IMAGE_PATH", BD_ASSETS_FOLDER_PATH."images/" );

$appSettings = JBusinessUtil::getApplicationSettings();
$lang        = JBusinessUtil::getLanguageTag();
$key         = JBusinessUtil::loadMapScripts();

$map_apply_search = $appSettings->map_apply_search;

$map_latitude = ( float ) $appSettings->map_latitude;
$map_longitude = ( float ) $appSettings->map_longitude;
$map_zoom = ( float ) $appSettings->map_zoom;

if (! is_numeric ( $map_latitude ))
	$map_latitude = 43.749156;

if (! is_numeric ( $map_longitude ))
	$map_longitude = - 79.411048;

if ((empty ( $map_zoom )) || (! is_numeric ( $map_zoom ))) {
    $map_zoom = 6;
}

if ($map_apply_search == '0') {
	$map_latitude = 43.749156;
	$map_longitude = - 79.411048;
	$map_zoom = 6;
}

$session = JFactory::getSession();
if (empty($radius)) {
	$radius = JFactory::getApplication()->input->get("radius");
	if (empty($radius)) {
		$radius = $session->get("radius");
	}
}

if ($appSettings->enable_map_clustering) {
    JBusinessUtil::enqueueScript('libraries/map/markercluster.js');
}

$mapId = rand ( 1000, 10000 );

$offer_locations = array ();

$db = JFactory::getDBO ();

if (! isset ( $offers ))
	$offers = $this->offers;

$index = 1;
foreach ( $offers as $offer ) {
    //if offer module is assigned on directory or events
    if (!isset($offer->subject)){
        $offer->subject = "";
    }
	$tmp = array ();
	$marker = 0;
	if (!empty($offer->categoryMaker)) {
		$marker = BD_PICTURES_PATH . $offer->categoryMaker;
	}
	
	$contentString = '<div class="info-box">' . '<div class="title">' . htmlspecialchars($offer->subject) . '</div>' . '<div class="info-box-content">' . '<div class="address" itemtype="http://schema.org/PostalAddress" itemscope="" itemprop="address">' .  JBusinessUtil::getAddressText ($offer) . '</div>';
	if (!empty($offer->phone)) {
		$contentString .= '<div class="info-phone"><i class="la la-phone"></i> ' . $db->escape($offer->phone) . '</div>';
	}

	$contentString .= '<a href="' . $db->escape(JBusinessUtil::getOfferLink ($offer->id, $offer->alias)) . '"><i class="la la-external-link"></i> ' . $db->escape(JText::_("LNG_MORE_INFO", true)) . '</a>' . '</div>' . '<div class="info-box-image">' . (!empty($offer->picture_path) ? '<img src="' . BD_PICTURES_PATH . $offer->picture_path . '" alt="' . htmlspecialchars($offer->subject) . '">' : "") . '</div>' . '</div>';
	
	if (! empty ( $offer->latitude ) && ! empty ( $offer->longitude )) {
		$tmp ['title'] = htmlspecialchars($offer->subject);
		$tmp ['latitude'] = $offer->latitude;
		$tmp ['longitude'] = $offer->longitude;
		$tmp ['zIndex'] = 4;
		$tmp ['content'] = $contentString;
		$tmp [] = $index;
		$tmp ['marker'] = $marker;
		$tmp ['in_range'] = 1;

		$offer_locations [] = $tmp;
	}
	
	$index ++;
}

// the params array that will be used on map.js
$initparams = array ();
$initparams ["tmapId"] = $mapId;
$initparams ["map_div"] = 'offers-map-';
$initparams ["map_latitude"] = ! empty ( $map_latitude ) ? $map_latitude : 0;
$initparams ["map_longitude"] = ! empty ( $map_longitude ) ? $map_longitude : 0;
$initparams ["map_zoom"] = $map_zoom;
$initparams ["has_location"] = (isset($this)) ? 1 : 0;
$initparams ["radius"] = ! empty ( $radius ) ? $radius : 0;
$initparams ["imagePath"] = BD_COMPONENT_IMAGE_PATH;
$initparams ["longitude"] = '';
$initparams ["latitude"] = '';
if (isset ( $this ) && ! empty ( $this->location ["latitude"] )) {
	$initparams ["longitude"] = $this->location ["longitude"];
	$initparams ["latitude"] = $this->location ["latitude"];
}

if ($appSettings->map_type == MAP_TYPE_BING) {
	$initparams["key"] = $key;
}

?>

<div id="offers-map-<?php echo $mapId ?>" style="position: relative;"></div>

<script>
    var mapInstance;

    window.addEventListener('load', function() {
        mapInstance = JBDMapHelper.loadMapScript(
		    <?php echo json_encode($offer_locations) ?>,
		    <?php echo json_encode($initparams) ?>,
		    <?php echo $appSettings->map_type ?>
        );
    });
</script>

<?php echo JBusinessUtil::getMapGDPRModal(); ?>