<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved. 
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');
?>

<div id="company-contact" class="jbd-container" style="display:none">
    <form id="contactCompanyFrm" name="contactCompanyFrm" action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory') ?>" method="post">
        <div class="jmodal-sm">
            <div class="jmodal-header">
                <p class="jmodal-header-title"><?php echo JText::_('LNG_CONTACT_OFFER_OWNER') ?></p>
                <a href="#close-modal" rel="modal:close" class="close-btn"><i class="la la-close "></i></a>
            </div>
            <div class="jmodal-body">
                <p>
                    <?php echo JText::_('LNG_OFFER_CONTACT_TEXT') ?>
                </p>
                <!-- First Step -->
                <div class="form-step-1">
                    <div class="row">
                        <div class="col-12">
                            <div class="jinput-outline jinput-hover">
                                <textarea rows="10" name="description" cols="50" class="form-control validate[required]" required=""></textarea>
                                <label for="description"><?php echo JText::_('LNG_CONTACT_TEXT')?>:</label>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Second Step -->
                <div class="form-step-2" style="display:none">
                    <div class="row">
                        <div class="col-md">
                            <div class="jinput-outline jinput-hover">
                                <input type="text" name="firstName" id="firstName" class="validate[required]" required="">
                                <label for="firstName"><?php echo JText::_('LNG_FIRST_NAME') ?></label>
                            </div>
                        </div>
                
                        <div class="col-md">
                            <div class="jinput-outline jinput-hover">
                                <input type="text" name="lastName" id="lastName" class="validate[required]" required="">
                                <label for="lastName"><?php echo JText::_('LNG_LAST_NAME') ?></label>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="jinput-outline jinput-hover">
                                <input type="text" name="email" id="jinput-email" class="validate[required,custom[email]]" required="">
                                <label for="jinput-email"><?php echo JText::_('LNG_EMAIL_ADDRESS') ?></label>
                            </div>
                        </div>
                    </div>                   

                    <div class="row">
                        <div class="col-12">
                            <div class="jbd-checkbox justify-content-end">
                                <label for="copy-me"><?php echo JText::_('LNG_COPY_ME')?></label>
                                <input type="checkbox"  name="copy-me" value="1">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <?php echo JBusinessUtil::renderTermsAndConditions('contact'); ?>
                    </div>

                    <?php if ($this->appSettings->captcha) { ?>
                        <div class="form-item">
                            <?php
                            $namespace = "jbusinessdirectory.contact";
                            $class = " required";

                            $captcha = JCaptcha::getInstance("recaptcha", array('namespace' => $namespace));

                            if (!empty($captcha)) {
                                echo $captcha->display("captcha", "captcha-div-contact", $class);
                            }
                            ?>
                        </div>
                    <?php } ?>
                    <?php echo JHTML::_('form.token'); ?>
                    <input type='hidden' name="option" value="com_jbusinessdirectory"/>
                    <input type='hidden' name='task' value='offer.contactCompany'/>
                    <input type="hidden" name="contact_id_offer" value="<?php echo $this->offer->company->email ?>"/>
                    <input type='hidden' name='userId' value='<?php echo $user->id ?>'/>
                    <input type="hidden" name="companyId" value="<?php echo $this->offer->company->id ?>"/>
                    <input type="hidden" name="offer_Id" value="<?php echo $this->offer->id ?>"/>
                    <input type="hidden" name="item_type" value="<?php echo $this->offer->item_type ?>"/>
                </div>
                <div class="jmodal-footer">
                    <div class="btn-group" role="group" aria-label="">
                        <div class="btn-step-1">
                            <button type="button" class="jmodal-btn jmodal-btn-outline" onclick="jQuery.jbdModal.close()"><?php echo JText::_("LNG_CANCEL")?></button>
                            <button type="button" class="jmodal-btn jbd-commit jbd-btn-next" disabled><?php echo JText::_("LNG_NEXT")?></button>                                
						</div>
						<div class="btn-step-2" style="display:none">
                            <button type="button" class="jmodal-btn jmodal-btn-outline jbd-btn-back"><?php echo JText::_("LNG_BACK")?></button>
                            <button type="button" class="jmodal-btn jbd-commit" onclick="jbdUtils.saveForm('contactCompanyFrm')"><?php echo JText::_("LNG_SEND")?></button>
						</div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>


<script>
window.addEventListener('load', function(){
    jbdUtils.renderContactFormSteps();
    
	<?php if (!empty($this->offer->latitude) && !empty($this->offer->longitude) || $this->offer->item_type == OFFER_TYPE_PRODUCT) { ?>
        loadOfferDetailsViewMap();
    <?php } ?>
});
</script>
