<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');

$user = JBusinessUtil::getUser();
?>
<?php
if($this->appSettings->enable_ratings) {
	require_once 'review_scorecard.php';
} else { ?>
    <a class="add-review-link btn btn-sm btn-success" href="javascript:void(0)" onclick="jbdReviews.addNewReview(<?php echo ($appSettings->enable_reviews_users && $user->id ==0) ?"1":"0"?>,false)"><?php echo JText::_("LNG_ADD_REVIEW") ?> <i class="la la-plus"></i></a>
<?php }?>

<?php if(count($this->reviews)==0){ ?>
	<p class="no-review"><?php echo JText::_('LNG_NO_REVIEWS') ?></p>
<?php } else { ?>
<ul id="reviews" itemprop="review" itemscope itemtype="https://schema.org/Review">
	<?php foreach($this->reviews as $review){?>
		<li class="review">
			<div class="review-content">

				<h3 itemprop="name"><?php echo $this->escape($review->subject) ?></h3>

				<div class="review-author">
					<p class="review-by-content">
					<span class="reviewer-name" itemprop="author"> <?php echo $this->escape($review->name) ?> </span>,
						<span class="review-date" itemprop="datePublished"><?php echo JBusinessUtil::getDateGeneralFormat($review->creationDate) ?></span>
					</p>
				</div>

				<div class="rating-block">
					<?php if(!empty($review->scores) && !empty($this->reviewCriterias)){ ?>
						<div class="review-rating" itemtype="http://schema.org/AggregateRating" itemscope="" itemprop="reviewRating">
							<span style="display:none;">
									<span itemprop="ratingValue"><?php echo number_format($review->rating,1) ?></span>
									<span itemprop="worstRating">0</span>
									<span itemprop="bestRating">5</span>
									<span itemprop="ratingCount"><?php echo count($this->reviewCriterias)?></span>
							</span>
							</div>
						<?php foreach($review->criteriaIds as $key=>$value){
								if(empty( $this->reviewCriterias[$value]))
									continue;
							?>
							<div class="review-criteria">
								<span class="review-criteria-name"><?php echo $this->reviewCriterias[$value]->name?></span>
								<span title="<?php echo $review->scores[$key] ?>" class="rating-review"></span>
							</div>
						<?php } ?>
					
					<?php }else{?>
						<div>
							<span title="<?php echo $review->rating ?>" class="rating-review"></span>
						</div>	
					<?php } ?>
					<div class="clear"></div>
				</div>

				<?php if(!empty($review->description)){?>
    				<div class="review-description" itemprop="description">
    					<pre class="review-text"><?php echo $review->description ?></pre>
    				</div>
				<?php }?>
				
				<?php if(isset($review->responses) && count($review->responses)>0) {
					foreach ($review->responses as $response) {
						?>
						<div class="review-response">
							<strong><?php echo JText::_('LNG_REVIEW_RESPONSE') ?></strong><br/>
							<span class="bold"><?php echo $response->firstName ?> </span>
							<p><?php echo $response->response ?></p>
						</div>
						<?php
					}
				}
				require 'review_gallery.php';
				?>

				<div class="review-actions">
					<ul>
						<li class="first">
							<a href="javascript:jbdReviews.reportReviewAbuse(<?php echo ($appSettings->enable_reviews_users && $user->id ==0)?"1":"0"; ?>,'<?php echo $review->id?>')"><?php echo JText::_('LNG_REPORT_ABUSE') ?></a>
						</li>
						<?php if ($this->allowReviewResponse){ ?>
                            <li>
                                <a href="javascript:jbdReviews.respondToReview(<?php echo ($appSettings->enable_reviews_users && $user->id ==0)?"1":"0"; ?>,'<?php echo $review->id?>')"><?php echo JText::_('LNG_RESPOND_TO_REVIEW') ?></a>
                            </li>
						<?php }?>
                        <?php if ($appSettings->share_reviews){?>
                            <li>
                                <a class="status-badge badge-success" href="javascript:shareReview(<?php echo $review->id ?>)"><?php echo JText::_('LNG_SHARE_THIS_REVIEW') ?></a>
                            </li>
                        <?php }?>
					</ul>
				</div>

				<div class="rate-review">
					<span class="rate"><?php echo JText::_("LNG_RATE_REVIEW")?>:</span>
					<ul>
						<li class="thumbup"><a
								id="increaseLike<?php echo $review->id ?>"
								href="javascript:void(0)" onclick="jbdReviews.increaseOfferReviewLikeCount(<?php echo $review->id ?>)"><?php echo JText::_("LNG_THUMB_UP")?>
							</a> <span class="count"  > (<span id="like<?php echo $review->id ?>"><?php echo $review->likeCount ?></span>) </span>
						</li>
						<li class="thumbdown">
							<a
								id="decreaseLike<?php echo $review->id ?>"
								href="javascript:void(0)" onclick="jbdReviews.increaseOfferReviewDislikeCount(<?php echo $review->id ?>)"><?php echo JText::_("LNG_THUMB_DOWN")?></a>
							<span class="count"  > (<span id="dislike<?php echo $review->id ?>"><?php echo $review->dislikeCount ?></span>) </span>
						</li>
					</ul>
				</div>
				<div class="clear"></div>
			</div>
		</li>
	<?php } ?>
</ul>
<?php } ?>
<div class="clear"></div>
<?php if(!$appSettings->enable_reviews_users || !$user->id ==0){?>
	<?php require_once 'default_addreview.php'; ?>
<?php } ?>
<br/>

<div id="report-abuse" class="jbd-container" style="display:none">
    <form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=offer'.$menuItemId) ?>" id="reportAbuse" name="reportAbuse"  method="post">
        <div class="jmodal-sm">
            <div class="jmodal-header">
                <p class="jmodal-header-title"><?php echo JText::_('LNG_REPORT_ABUSE') ?></p>
                <a href="#close-modal" rel="modal:close" class="close-btn"><i class="la la-close "></i></a>
            </div>

            <div class="jmodal-body">
                <p>
                    <?php echo JText::_("LNG_ABUSE_INFO");?>
                </p>

                <div class="row">
                    <div class="col-12">
                        <div class="jinput-outline jinput-hover">
                            <input type="text" name="email" id="email-abuse" class="validate[required,custom[email]]" required="">
                            <label for="email-abuse"><?php echo JText::_('LNG_EMAIL') ?></label>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="jinput-outline jinput-hover">
                            <textarea rows="5" name="description" id="description-abuse" cols="50" class="form-control validate[required]" required=""></textarea>
                            <label for="description-abuse"><?php echo JText::_('LNG_REPORT_ABUSE_BECAUSE')?>:</label>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <?php echo JBusinessUtil::renderTermsAndConditions('reviews'); ?>
                    </div>
                </div>

                <?php if($this->appSettings->captcha){?>
                    <div class="form-item">
                        <?php
                        $namespace="jbusinessdirectory.contact";
                        $class=" required";

                        $captcha = JCaptcha::getInstance("recaptcha", array('namespace' => $namespace));

                        if(!empty($captcha)){
                            echo $captcha->display("captcha", "captcha-div-review-abuse", $class);
                        }

                        ?>
                    </div>
                <?php } ?>
                <input type='hidden' name='task' value='offer.reportAbuse'/>
                <input type='hidden' name='view' value='offers' />
                <input type="hidden" name="reviewId" value="" />
                <input type="hidden" name="companyId" value="<?php echo $this->offer->id?>" />
            </div>
            <div class="jmodal-footer">
                <div class="btn-group" role="group" aria-label="">
                    <button type="button" class="jmodal-btn jmodal-btn-outline" onclick="jQuery.jbdModal.close()"><?php echo JText::_("LNG_CANCEL")?></button>
                    <button type="button" class="jmodal-btn jbd-commit" onclick="jbdUtils.saveForm('reportAbuse')"><?php echo JText::_("LNG_SUBMIT")?></button>
                </div>
            </div>
        </div>
    </form>
</div>


<div id="new-review-response" class="jbd-container" style="display:none">
    <form id="reviewResponseFrm" name ="reviewResponseFrm" action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=offer'.$menuItemId) ?>" method="post">
        <div class="jmodal-sm">
            <div class="jmodal-header">
                <p class="jmodal-header-title"><?php echo JText::_('LNG_RESPOND_REVIEW') ?></p>
                <a href="#close-modal" rel="modal:close" class="close-btn"><i class="la la-close "></i></a>
            </div>
            <div class="jmodal-body">
                <p><?php echo JText::_('LNG_RESPOND_REVIEW_INFO') ?></p>

                <div class="row">
                    <div class="col-12">
                        <div class="jinput-outline jinput-hover">
                            <input type="text" name="firstName" id="firstName-respond" class="validate[required]" required="">
                            <label for="firstName-respond"><?php echo JText::_('LNG_FIRST_NAME') ?></label>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="jinput-outline jinput-hover">
                            <input type="text" name="lastName" id="lastName-respond" class="validate[required]" required="">
                            <label for="lastName-respond"><?php echo JText::_('LNG_LAST_NAME') ?></label>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="jinput-outline jinput-hover">
                            <input type="text" name="email" id="email-respond" class="validate[required,custom[email]]" required="">
                            <label for="email-respond"><?php echo JText::_('LNG_EMAIL_ADDRESS') ?></label>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="jinput-outline jinput-hover">
                            <textarea rows="5" name="response" id="response" cols="50" class="form-control validate[required]" required=""></textarea>
                            <label for="response"><?php echo JText::_('LNG_REVIEW_RESPONSE')?>:</label>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <?php echo JBusinessUtil::renderTermsAndConditions('reviews'); ?>
                    </div>
                </div>

                <?php if($this->appSettings->captcha){?>
                    <div class="form-item">
                        <?php
                        $namespace="jbusinessdirectory.contact";
                        $class=" required";

                        $captcha = JCaptcha::getInstance("recaptcha", array('namespace' => $namespace));

                        if(!empty($captcha)){
                            echo $captcha->display("captcha", "captcha-div-review-abuse", $class);
                        }

                        ?>
                    </div>
                <?php } ?>
                <input type='hidden' name='task' value='offer.saveReviewResponse'/>
                <input type='hidden' name='view' value='offers' />
                <input type="hidden" name="reviewId" value="" />
                <input type="hidden" name="companyId" value="<?php echo $this->offer->id?>" />
            </div>
            <div class="jmodal-footer">
                <div class="btn-group" role="group" aria-label="">
                    <button type="button" class="jmodal-btn jmodal-btn-outline" onclick="jQuery.jbdModal.close()"><?php echo JText::_("LNG_CANCEL")?></button>
                    <button type="button" class="jmodal-btn jbd-commit" onclick="jbdUtils.saveForm('reviewResponseFrm')"><?php echo JText::_("LNG_SUBMIT")?></button>
                </div>
            </div>
        </div>
    </form>
</div>

<?php if ($appSettings->share_reviews){?>
    <div id="review_content_frame" style="display:none; max-width: 660px">
        <div id="dialog-container" class="jbd-container">
            <div class="titleBar">
                <span class="dialogTitle" id="dialogTitle"></span>
            </div>

            <div class="dialogContent">
                <iframe style="width: 100%;height: 480px;"  id="reviewIfr" class="review_content_frame" src="about:blank">
                </iframe>
            </div>
        </div>
    </div>
<?php } ?>

<script>
window.addEventListener('load', function(){

    jbdOffers.renderOfferReviews('<?php echo BD_COMPONENT_IMAGE_PATH?>');
});

<?php if ($appSettings->share_reviews){?>
function shareReview(reviewId) {
    var offerId = '<?php echo $this->offer->id ?>';
    var type = '<?php echo REVIEW_TYPE_OFFER ?>';
    var listingName = '<?php echo $this->offer->subject ?>';
    var url = '<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=sharedreview&tmpl=component'); ?>';
    var urlReviewShare = url + "&review_id=" + reviewId+ "&offerId=" + offerId + "&type="+ type + "&listingName="+listingName;
    jQuery("#reviewIfr").attr("src", urlReviewShare);

    var options = {
        modalClass: "jbd-modal jbd-invoice"
    };

    jQuery('#review_content_frame').jbdModal(options);
    jQuery("#reviewIfr").ready(function() {
        document.getElementById('reviewIfr').style.height = document.getElementById('reviewIfr').contentWindow.document.body.scrollHeight + 'px';
    });
}

<?php } ?>
</script>