<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');

$document = JFactory::getDocument();
$config = JBusinessUtil::getSiteConfig();
$user = JBusinessUtil::getUser();

$base_url = ( isset($_SERVER['HTTPS']) && $_SERVER['HTTPS']=='on' ? 'https' : 'http' ) . '://' .  $_SERVER['HTTP_HOST'];
$url = $base_url . $_SERVER["REQUEST_URI"];

$appSettings = JBusinessUtil::getApplicationSettings();

$showData = !($user->id==0 && $appSettings->show_details_user == 1);

$title = stripslashes($this->offer->subject)." | ".$config->sitename;
if(!empty($this->offer->meta_title))
    $title = stripslashes($this->offer->meta_title)." | ".$config->sitename;

$description = $appSettings->meta_description;
if(!empty($this->offer->short_description)){
    $description = htmlspecialchars(strip_tags($this->offer->short_description), ENT_QUOTES);
}else if(!empty($this->offer->description)){
    $description = htmlspecialchars(JBusinessUtil::truncate(strip_tags($this->offer->description),15,"..."), ENT_QUOTES);
}
if(!empty($this->offer->meta_description))
    $description = $this->offer->meta_description;

$keywords = $appSettings->meta_keywords;
if(!empty($this->offer->meta_keywords))
    $keywords = $this->offer->meta_keywords;

    
$picturePath = "";
if(!empty($this->offer->pictures)){
    $picturePath = $this->offer->pictures[0]->picture_path;
}
    
JBusinessUtil::setMetaData($title, $description, $keywords, false);
JBusinessUtil::setFacebookMetaData($title, $description, $picturePath, $url);

$menuItemId = JBusinessUtil::getActiveMenuItem();

$offerUrl = JBusinessUtil::getOfferLink($this->offer->id, $this->offer->alias);
JBusinessUtil::setCanonicalURL($offerUrl);
?>
