<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');
$user = JBusinessUtil::getUser();

$session = JFactory::getSession();
$menuItem = "&Itemid=".$session->get("offersMenuItemId");
$referer= isset($_SERVER['HTTP_REFERER'])?$_SERVER['HTTP_REFERER']:"";
$offerQuantity = $this->offer->quantity;

$couponUrl = JRoute::_('index.php?option=com_jbusinessdirectory&task=offer.generateCoupon&id='.$this->offer->id);
if($this->appSettings->enable_offer_selling && $this->offer->enable_offer_selling != OFFER_SELLING_COUPON && !empty((float)$this->offer->specialPrice) && !empty((float)$this->offer->price)){
	$couponUrl = "javascript:onclick=jbdOffers.addToCart(".$this->offer->id.",1)";
}
?>

<div id="jbd-container" class="jbd-container">
	<div id="offer-detail-3" class="offer-details offer-details-3"  itemscope itemtype="http://schema.org/Offer">
		<div class="row d-flex align-items-center">
			<?php if(!empty($referer) && false){ ?>
				<div class="col-lg-8 col-sm-4">
	    			<a href="<?php echo $referer ?>"><?php echo JText::_("BACK") ?></a>
	    		</div>
	    	<?php }else{ ?>
	    		<div class="col-lg-8 col-sm-4">
	    			<a href="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=offers&reload=1'.$menuItem); ?>"><?php echo JText::_("BACK_TO_OFFERS") ?></a>
	    		</div>
			<?php } ?>
    		<div class="col-lg-4 col-sm-8 d-flex justify-content-between align-items-center">
                <div class="rating">
                    <span class="user-rating-avg rating-average-review" id="rating-average-review" title="<?php echo $this->offer->review_score?>" alt="<?php echo $this->offer->id?>" style="display: block;"></span>
                </div>
                <div class="header-icons">
                    <?php require_once JPATH_COMPONENT_SITE."/include/social_share.php" ?>
                    <a class="print-icon" rel="nofollow" href="javascript:jbdUtils.printItem('<?php echo JRoute::_("index.php?option=com_jbusinessdirectory&view=offer&tmpl=component&action=print&offerId=".$this->offer->id); ?>')"><i class="icon print-circle"></i></a>
                    <?php if($this->appSettings->enable_bookmarks && $this->offer->item_type == OFFER_TYPE_OFFER) { ?>
                        <?php if(!empty($this->offer->bookmark)){?>
                            <!-- Business Bookmarks -->
                            <a id="bookmark-<?php echo $this->offer->id ?>" href="javascript:jbdUtils.showUpdateBookmarkDialog(<?php echo $user->id==0?"1":"0"?>, <?php echo $this->offer->id ?>,<?php echo BOOKMARK_TYPE_OFFER ?>)"  title="<?php echo JText::_("LNG_UPDATE_BOOKMARK")?>" class="bookmark"><i class="la la-heart"></i></a>
                        <?php } else {?>
                            <a id="bookmark-<?php echo $this->offer->id ?>" href="javascript:jbdUtils.showAddBookmark(<?php echo $user->id==0?"1":"0"?>, <?php echo $this->offer->id ?>,<?php echo BOOKMARK_TYPE_OFFER ?>)" title="<?php echo JText::_("LNG_ADD_BOOKMARK")?>" class="bookmark"><i class="la la-heart-o"></i></a>
                        <?php } ?>
                    <?php } ?>
                    </div>    			
    	     </div>
    	</div>

        <div class="row mb-3">
            <div class="col-lg-8">
                <?php if(!empty($this->offer->pictures)){?>
                        <?php
                            
                            $this->pictures = $this->offer->pictures;
                            $this->contactDetails = false;
                            $this->popupTitle = $this->offer->subject;
                            require_once JPATH_COMPONENT_SITE.'/include/image_gallery_popup.php';
                        ?>
                <?php } ?>
            </div>

            <div class="col-lg-4">
                <div class="offer-main-info">
                    <div class="content-box">
                        <h1 itemprop="name" class="pt-0"> <?php echo $this->escape($this->offer->subject)?></h1>
                        <span style="display:none;" itemprop="url"><?php echo JBusinessUtil::getOfferLink($this->offer->id, $this->offer->alias); ?></span>

                        <div class="">
                            <?php if(!empty($this->offer->categories)){ ?>
                                <?php 
                                    $mainCategoryArr = [];
                                    foreach ($this->offer->categories as $cat) {
                                        $result = array_search($this->offer->main_subcategory, $cat);
                                        if (isset($result)) {
                                            $mainCategoryArr = $this->offer->categories[$result];
                                        }                                    
                                    }                            
                                ?>
                                <a  href="<?php echo JBusinessUtil::getOfferCategoryLink($mainCategoryArr[0], $mainCategoryArr[2]) ?>"><?php echo $this->escape($mainCategoryArr[1]) ?></a>
                            <?php } ?>
                        </div>

                        <div class="price-container">
                            <?php if(!empty($this->offer->specialPrice) && !empty($this->offer->price)){?>
                                <div class="old-price">
                                    <span><?php echo JText::_("LNG_OLD_PRICE")?>: </span>
                                    <span class="price-value" <?php echo empty($this->offer->specialPrice)?'itemprop="price"':''?> > <?php echo JBusinessUtil::getPriceFormat($this->offer->price, $this->offer->currencyId) ?></span> 
                                        <?php if(!empty((int)$this->offer->price_base)){?>
                                                &nbsp;(<?php echo  JBusinessUtil::getPriceFormat($this->offer->price_base, $this->offer->currencyId)?>/<?php echo $this->offer->price_base_unit?>)
                                        <?php }?>
                                    </span>
                                </div>
                            <?php } ?>
                            <?php $this->offer->specialPrice = empty($this->offer->specialPrice)?$this->offer->price:$this->offer->specialPrice ?>
                            <?php if(!empty($this->offer->specialPrice)){?>
                                <div class="price-new">
                                    <span><?php echo JText::_("LNG_PRICE")?>: </span> 
                                    <span>
                                    <span class="price-value" itemprop="price"><?php echo JBusinessUtil::getHtmlPriceFormat($this->offer->specialPrice, $this->offer->currencyId)?></span>
                                    <?php if (!empty((int)$this->offer->special_price_base)) { ?>
                                            &nbsp;(<?php echo  JBusinessUtil::getPriceFormat($this->offer->special_price_base, $this->offer->currencyId)?>/<?php echo $this->offer->special_price_base_unit?>)
                                    <?php }?>
                                    </span>
                                </div>
                            <?php } ?>
                        </div>

                        <?php if ($this->appSettings->enable_offer_selling && $this->offer->enable_offer_selling == OFFER_SELLING_REGULAR && JBusinessUtil::checkDateInterval($this->offer->startDate, $this->offer->endDate) && $this->offer->quantity > 0
                            && (isset($this->offer->companyPackage->features) && in_array(SELL_OFFERS,$this->offer->companyPackage->features) || !$this->appSettings->enable_packages)) { ?>
                            <div class="jbtn-order">
                                <div class="jbtn-order-info <?php echo !empty($this->offer->sellingOptions)?"vertical":"" ?>">
                                    <?php if (!empty($this->offer->sellingOptions)) {
                                        echo AttributeService::renderSellingAttributesFront($this->offer->sellingOptions, $this->offer->id, $this->offer->main_subcategory);
                                    }else { ?>
                                        <select  onchange="jbdOffers.checkAddToCartStatus()" name="quantity" id="quantity" class="select">
                                            <?php
                                                if ($this->offer->min_purchase > 0) {
                                                    echo '<option value="0">0</option>';
                                                }

                                                $maximum = $this->offer->max_purchase;
                                                if ($this->offer->quantity < $this->offer->max_purchase) {
                                                    $maximum = $this->offer->quantity;
                                                }
                                                $maximum = ($maximum < MAXIMUM_OFFER_QUANTITY_SELLING) ? $maximum : MAXIMUM_OFFER_QUANTITY_SELLING;
                                                for ($i = $this->offer->min_purchase; $i <= $maximum; $i++) {
                                                    echo '<option value="' . $i . '">' . $i . '</option>';
                                                } 
                                            ?>
                                        </select>
                                    <?php } ?>	                        
                                </div>
                                <input type="hidden" id="firstValue" value=""/>

                                <div class="jbtn-order-btn">
                                    <a id="addToCartButton" href="javascript:onclick=jbdOffers.addToCart(<?php echo $this->offer->id; ?>)"><i class="icon cart white"></i> <?php echo JText::_('LNG_ADD_TO_CART'); ?></a>
                                </div>
                                <?php if(!empty($this->cart["items"]) && in_array($this->offer->id , array_column($this->cart["items"], 'id'))) {?>
                                    <div class="btn-remove-cart ml-3 btn-lg btn-success">
                                        <a id="removeFromCartButton" href="javascript:onclick=jbdOffers.removeFromCart('<?php echo $this->offer->id; ?>_')"><i class="la la-trash-o white"></i></a>
                                    </div>
                                <?php } ?>                        
                            </div>
                        <?php } else if ($this->appSettings->enable_offer_selling && $this->offer->enable_offer_selling == OFFER_SELLING_REGULAR && JBusinessUtil::checkDateInterval($this->offer->startDate, $this->offer->endDate) && $this->offer->quantity == 0
                            && (isset($this->offer->companyPackage->features) && in_array(SELL_OFFERS,$this->offer->companyPackage->features) || !$this->appSettings->enable_packages)) { ?>
                            <?php $offerQuantity = 0 ; ?>
                            <div class="offer-quantity-info">
                                <?php echo JText::_('LNG_OUT_OF_STOCK') ?>
                            </div>
                        <?php } ?>

                        <?php if ($this->offer->item_type == OFFER_TYPE_OFFER && (!$this->appSettings->enable_offer_selling || $this->appSettings->enable_offer_selling && $this->offer->enable_offer_selling != OFFER_SELLING_REGULAR)){ ?>
                            <?php $offerQuantity = $this->offer->total_coupons ?>
                            <div class="col-lg">
                                <?php if(!empty($this->offer->specialPrice) && !empty($this->offer->price) && $this->offer->specialPrice < $this->offer->price){ ?>
                                    <div class="jbtn-offer">
                                        <div class="jbtn-offer-info">
                                            <p><span> <?php echo JBusinessUtil::getPriceDiscount($this->offer->specialPrice, $this->offer->price) ?>% </span> <?php echo JText::_("LNG_OFF")?></p>
                                        </div>
                                        <?php if($this->appSettings->enable_offer_coupons) { ?>
                                            <?php if($this->offer->checkOffer) { ?>
                                                <div class="jbtn-offer-link">
                                                    <div class="jbtn-offer-darken"></div>
                                                    <?php if($user->id !=0) { ?>
                                                        <a href="<?php echo $couponUrl ?>">
                                                            <?php echo JText::_("LNG_GENERATE_COUPON")?>
                                                        </a>
                                                    <?php } else { ?>
                                                        <a href="javascript:jbdUtils.showLoginNotice()">
                                                            <?php echo JText::_('LNG_GENERATE_COUPON')?>
                                                        </a>
                                                    <?php } ?>
                                                </div>
                                            <?php } ?>
                                        <?php } ?>
                                    </div>
                                <?php }else{ ?>
                                        <?php if($this->appSettings->enable_offer_coupons) { ?>
                                            <?php if($this->offer->checkOffer) { ?>
                                                <div class="jbtn-offer">
                                                    <div class="jbtn-offer-info-sm">
                                                        <?php if($user->id !=0) { ?>
                                                            <a href="<?php echo $couponUrl ?>">
                                                                <?php echo JText::_("LNG_GENERATE_COUPON")?>
                                                            </a>
                                                        <?php } else { ?>
                                                            <a href="javascript:jbdUtils.showLoginNotice()">
                                                                <?php echo JText::_('LNG_GENERATE_COUPON')?>
                                                            </a>
                                                        <?php } ?>
                                                        <div class="jbtn-offer-darken"></div>
                                                    </div>
                                                </div>
                                            <?php } ?>
                                        <?php } ?>
                                <?php } ?>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="row">
                        <div class="col-6">
                            <?php echo JText::_("LNG_AVAILABLE")?>: <?php echo $offerQuantity?>
                        </div>
                        <div class="col-6 text-right">
                            <?php if ($this->defaultAttributes["price_text"]!=ATTRIBUTE_NOT_SHOW) { ?>
                                <?php if (!empty($this->offer->price_text)) { ?>
                                    <div class="price-text"><?php echo $this->offer->price_text;?></div>
                                <?php }elseif (empty($this->offer->price) && empty($this->offer->specialPrice) && ($this->appSettings->show_offer_free)){ ?>
                                    <div><span class="free-text text-success p-2"><?php echo JText::_('LNG_FREE') ?></span></div>
                                <?php } ?>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-8">
               <!-- Item details -->
               <div class="row item-section" itemprop="offeredBy" itemscope itemtype="http://schema.org/Organization">
                    <?php if (isset($this->offer->companyPackage->features) && in_array(SHOW_COMPANY_LOGO, $this->offer->companyPackage->features) || !$appSettings->enable_packages) { ?>
                        <div class="col-3">
                            <?php if (!empty($this->offer->company->logoLocation)) { ?>
                                <img src="<?php echo BD_PICTURES_PATH.$this->offer->company->logoLocation ?>" alt="<?php echo $this->offer->company->name ?>">
                            <?php } else { ?>
                                <img src="<?php echo BD_PICTURES_PATH . '/no_image.jpg' ?>" alt="<?php echo $this->offer->company->name ?>">
                            <?php } ?>
                        </div>
                    <?php } ?>

                   <div class="col-4">
                        <?php if(!empty($this->offer->company)){?>
                            <div class="offer-business">
                                <div class="section-title"><?php echo JText::_("LNG_COMPANY_DETAILS") ?></div>
                                <a class="business-name" <?php echo $newTab; ?> href="<?php echo JBusinessUtil::getCompanyLink($this->offer->company)?>"> <i class="icon business"></i> <span itemprop="name"><?php echo $this->escape($this->offer->company->name)?></span></a>
                                <?php if(!empty($this->offer->company->phone) || !empty($this->offer->company->mobile)){?>
                                        <div class="business-item" itemprop="telephone">
                                        <?php if(!empty($this->offer->company->phone)){ ?>
                                            <i class="icon phone-o"></i> <a href="tel:<?php  echo $this->escape($this->offer->company->phone); ?>"><?php  echo $this->escape($this->offer->company->phone); ?></a> &nbsp;&nbsp;
                                        <?php }?> 
                                        </div>  

                                        <div class="business-item" itemprop="telephone"> 
                                        <?php if(!empty($this->offer->company->mobile)){ ?>
                                            <i class="icon mobile"></i> <a href="tel:<?php  echo $this->escape($this->offer->company->mobile); ?>"><?php  echo $this->escape($this->offer->company->mobile); ?></a>
                                        <?php } ?>
                                        </div>
                                <?php } ?>
                                <?php if(!empty($this->offer->company->website)){?>
                                        <div class="business-item" itemprop="url">
                                            <a target="_blank" itemprop="url" title="<?php echo $this->escape($this->offer->company->name)?> Website" onclick="jbdUtils.registerStatAction(<?php echo $this->offer->company->id ?>,<?php echo STATISTIC_ITEM_BUSINESS ?>,<?php echo STATISTIC_TYPE_WEBSITE_CLICK ?>)" href="<?php echo $this->escape($this->offer->company->website) ?>"><i class="icon link-square"></i> <?php echo JText::_('LNG_WEBSITE') ?></a>
                                        </div>
                                <?php } ?>
                            </div>
                        <?php } ?>
                   </div>
                   <div class="col-5">
                        <?php if ($this->appSettings->show_contact_form && $this->offer->item_type == OFFER_TYPE_OFFER) { ?>
                            <div class="section-title"><?php echo JText::_("LNG_CONTACT") ?></div>
                            <?php if(!empty($this->offer->company->phone) || !empty($this->offer->company->mobile)){?>
                                <div>
                                    <?php if(!empty($this->offer->company->phone)){ ?>
                                    <i class="icon phone-o"></i> <a href="tel:<?php  echo $this->escape($this->offer->company->phone); ?>"><?php  echo $this->escape($this->offer->company->phone); ?></a> &nbsp;&nbsp;
                                    <?php } else if(!empty($this->offer->company->mobile)){ ?>
                                    <i class="icon mobile"></i> <a href="tel:<?php  echo $this->escape($this->offer->company->mobile); ?>"><?php  echo $this->escape($this->offer->company->mobile); ?></a>
                                    <?php } ?>
                                    </div>
                            <?php } ?>
                            <div itemprop="email" ><i class="icon envelope"></i><a href="javascript:jbdListings.contactCompany(<?php echo $showData ? 1 : 0 ?>)"> <?php echo JText::_('LNG_CONTACT'); ?></a> </div>
                            <?php $address = JBusinessUtil::getAddressText($this->offer); ?>
                            <?php if(!empty($address)) { ?>
                                <div class="offer-location" itemprop="location" itemscope itemtype="http://schema.org/Place">
                                    <i class="icon map-marker"></i>&nbsp;<span itemprop="address"><?php echo $this->escape($address)?></span>
                                    <?php if(isset($this->offer->latitude) && isset($this->offer->longitude)) {
                                        $location = new stdClass;
                                        $location->latitude = $this->offer->latitude;
                                        $location->longitude = $this->offer->longitude;
                                    ?>
                                        <a target="_blank" href="<?php echo JBusinessUtil::getDirectionURL(null, $location) ?>"> - <i class="icon map-direction"></i><?php echo JText::_("LNG_MAP")?></a>
                                    <?php }?>
                                </div>
                            <?php } ?>
                        <?php } ?>
                   </div>
               </div>
            </div>

            <!-- Content boxes -->
    		<div class="col-lg-4">
                <div class="offer-info">
                    <div class="section-title"><?php echo JText::_("LNG_DURATION") ?></div>
                    <?php if (!empty($this->offer->show_time) && JBusinessUtil::getRemainingtime($this->offer->endDate, $this->offer->time_zone)!="") { ?>
                        <div class="offer-dates">
                            <span ><i class="la la-clock-o"></i> <?php echo JBusinessUtil::getRemainingtime($this->offer->endDate, $this->offer->time_zone) ?></span>
                        </div>
                    <?php } ?>                         
                    <?php if ((!empty($this->offer->startDate) && $this->offer->startDate!="0000-00-00") || (!empty($this->offer->endDate) && $this->offer->endDate!="0000-00-00")) { ?>
                        <div class="offer-dates">
                            <i class="icon calendar"></i>
                            <?php
                                echo  JBusinessUtil::getDateGeneralFormat($this->offer->startDate)." - ". JBusinessUtil::getDateGeneralFormat($this->offer->endDate);
                            ?>
                            <span style="display: none;" itemprop="validFrom"><?php echo JBusinessUtil::getDateGeneralFormat($this->offer->startDate)?></span>
                            <span style="display: none;" itemprop="validThrough"><?php echo JBusinessUtil::getDateGeneralFormat($this->offer->endDate)?></span>
                        </div>
                    <?php } ?>
                </div>
            </div>                
        </div>
            
        <!-- Attachments -->
        <?php if ($this->appSettings->enable_attachments) { ?>
            <?php if (!empty($this->offer->attachments)) { ?>                             
                <div class="row item-section">
                    <div class="col-12">
                        <div class="section-title">
                            <?php echo JText::_("LNG_ATTACHMENTS") ?>
                        </div>
                        <?php require "offer_attachments.php"?>
                    </div>                            
                </div>
            <?php } ?>
        <?php } ?>

        <div class="row item-section">
            <div class="col-lg-8">
                <div itemprop="description">
                    <?php echo JHTML::_("content.prepare", $this->offer->description); ?>
                </div>
            </div>
            <div class="col-lg-4">
                <!-- Payment Processors -->
                <?php if(!empty($this->offer->paymentMethods)){?>
                    <div class="offer-info" >
                        <div class="section-title">
                            <strong><?php echo JText::_("LNG_AVAILABLE_PAYMENT_METHODS") ?></strong>
                        </div>
                        <ul class="p-0">
                            <?php foreach ($this->offer->paymentMethods as $method) { ?>
                                <li class="d-flex py-1"><img width="40px" class="payment-icon mr-2" src="<?php echo BD_ASSETS_FOLDER_PATH."images/payment/".strtolower($method->type).'.gif' ?>"  /><?php echo $method->name ?></li>
                            <?php } ?>
                        </ul>                     
                    </div>
                <?php } ?>
            </div>
        </div>

        <?php if ((!empty($this->offer->latitude) && !empty($this->offer->longitude)) || $this->offer->item_type == OFFER_TYPE_PRODUCT) { ?>
            <div class="row item-section">
                <div class="col-12">
                    <div id="offer-map">
                        <?php require_once 'map.php';?>
                    </div>
                </div>
            </div>
        <?php } ?>   

        <?php if ($this->appSettings->enable_reviews && $this->offer->item_type == OFFER_TYPE_OFFER) { ?>            
            <div class="row item-section" style="background: #fff;">
        		<div class="col">
                    <?php require_once 'offer_reviews.php';?>
                </div>
             </div>
        <?php } ?>

        <div class="row item-section">
            <div class="col-12">            
                <?php 
                    $modules = JModuleHelper::getModules("related-offers");                   
                    foreach($modules as $module) { 
                        echo  JModuleHelper::renderModule($module, array("style"=>"xhtml"));
                    }
                ?>
            </div>
        </div>
        
    <?php require_once 'offer_util.php'; ?>
    <?php require_once JPATH_COMPONENT_SITE . '/include/bookmark_utils.php'; ?>
</div>