<?php
/**
 * @package     JBusinessDirectory
 * @subpackage  com_jbusinessdirectory
 *
 * @copyright   Copyright (C) 2007 - 2015 CMS Junkie. All rights reserved.
 * @license     GNU General Public License version 2 or later;
 */

defined('_JEXEC') or die('Restricted access');


JBusinessUtil::loadJQueryChosen();

JBusinessUtil::enqueueStyle('libraries/dropzone/basic.css');

JBusinessUtil::enqueueStyle('libraries/jquery/jquery-ui.css');

JBusinessUtil::enqueueScript('libraries/chosen/ajax-chosen.min.js');

// following translations will be used in js
JText::script('LNG_IMAGE_SIZE_WARNING');

JBusinessUtil::includeValidation();

require_once HELPERS_PATH . '/helper.php';

/**
 * The HTML  View.
 */
class JBusinessDirectoryViewManagePaymentProcessor extends JViewLegacy {
	protected $item;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null) {
		$this->companies = JBusinessUtil::getCompaniesByUserId();
		$this->item      = $this->get('Item');
		$this->state     = $this->get('State');
		
		$this->item->services = JBusinessUtil::getAvailablePayableServices(true);

		$this->statuses = JBusinessDirectoryHelper::getStatuses();
		$this->modes = JBusinessDirectoryHelper::getModes();

		$this->defaultProcessors = JBusinessUtil::getDefaultPaymentProcessors(true);
		$this->appSettings = JBusinessUtil::getApplicationSettings();

		$user                 = JBusinessUtil::getUser();
		$this->companyOptions = JBusinessUtil::getCompaniesOptions($this->item->company_id, $user->id);

		$this->actions = JBusinessDirectoryHelper::getActions();

		parent::display($tpl);
	}
}
