
<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');
$appSettings = JBusinessUtil::getApplicationSettings();

JBusinessUtil::checkPermissions("directory.access.projects", "managecompanyprojects");

$isProfile = true;

?>
<script>
    var isProfile = true;
</script>
<style>
    #header-box, #control-panel-link {
        display: none;
    }
</style>


<?php

if(!$this->isCreateProjectAllow){
    JFactory::getApplication()->enqueueMessage(JText::_('LNG_PROJECT_CREATION_NOT_ALLOWED'),"notice");
    return;
}

if(empty($this->items)) {
    $actionURL = JRoute::_('index.php?option=com_jbusinessdirectory&task=managecompanyproject.add');
    echo JBusinessUtil::getNewItemMessageBlock(JText::_("LNG_PROJECT"), JText::_("LNG_PROJECTS"), $actionURL);
    return;
} 
?>


<div class="button-row  justify-content-end">
    <?php if ($this->isCreateProjectAllow) { ?>
    <button type="submit" class="btn btn-success" onclick="jbdListings.addProject()">
        <span class="ui-button-text"><i class="la la-plus-sign"></i> <?php echo JText::_("LNG_ADD_NEW_PROJECT")?></span>
    </button>
    <?php } ?>
</div>

<form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=managecompanyprojects');?>" method="post" name="adminForm" id="adminForm">
    <div id="editcell">
        <table class="dir-panel-table responsive-simple">
            <tbody>
            <?php
            $nrcrt = 1;
            if(!empty($this->items)){
                foreach($this->items as $project) { ?>
                    <tr class="jtable-body-row row<?php echo $nrcrt%2 ?>">
                        <td class="jtable-body-row-data">  
                        <div class="item-head">
                            <div class="item-image text-center">
                                <?php if (!empty($project->picture_path)) { ?>
                                    <a href='<?php echo JRoute::_( 'index.php?option=com_jbusinessdirectory&task=managecompanyproject.edit&'.JSession::getFormToken().'=1&id='. $project->id )?>'>
                                        <img
                                                src="<?php echo BD_PICTURES_PATH.$project->picture_path ?>"
                                                class="img-circle"
                                        />
                                    </a>
                                <?php } else { ?>
                                    <a href="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&task=managecompanyproject.edit&'.JSession::getFormToken().'=1&id='. $project->id ) ?>">
                                        <img
                                                src="<?php echo BD_PICTURES_PATH.'/no_image.jpg' ?>"
                                                class="img-circle"
                                        />
                                    </a>
                                <?php } ?>
                            </div>
                            <div class="item-name text-left">
                                <div class="item-title">
                                    <a href='<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&task=managecompanyproject.edit&'.JSession::getFormToken().'=1&id='.$project->id )?>'
                                        title="<?php echo JText::_('LNG_CLICK_TO_EDIT'); ?>">
                                        <B><?php echo $project->name?></B>
                                    </a>
                                </div> 
                            </div>  
                             
                        </div>                          

                        </td>                        
                        <td class="jtable-body-row-data" class="hidden-xs hidden-phone">
                            <div class="item-label">
                                <?php echo JText::_('LNG_BUSINESS'); ?>
                            </div>
                            <div class="item-value">
                                <?php echo $project->companyName ?>
                            </div>
                        </td>
                        <td class="jtable-body-row-data" class="hidden-xs hidden-phone">
                            <?php echo (strlen($project->description)>80)?substr($project->description,0,80)."...":$project->description; ?>
                        </td>
                        <td class="jtable-body-row-data" class="hidden-xs hidden-phone" align="center">
                            <div class="item-status"> 
                                <?php
                                switch($project->status) {
                                    case 1:
                                        echo '<span class="status-badge badge-success">'.JText::_("LNG_PUBLISHED").'</span>';
                                        break;
                                    case 0:
                                        echo '<span class="status-badge badge-warning warn">'.JText::_("LNG_UNPUBLISHED").'</span>';
                                        break;
                                }
                                ?>
                            
                                <div class="item-actions">
                                    <a href="javascript:void(0);" onclick="jbdListings.editProject(<?php echo $project->id ?>)"
                                        title="<?php echo JText::_('LNG_CLICK_TO_EDIT'); ?>" class="jtable-btn">
                                        <i class="la la-pencil"></i>
                                    </a>
                                    <a href="javascript:void(0);" onclick="jbdListings.deleteProject(<?php echo $project->id ?>)"
                                        title="<?php echo JText::_('LNG_CLICK_TO_DELETE'); ?>" class="jtable-btn">
                                        <i class="la la-trash"></i>
                                    </a>
                                </div>
                            </div>
                        </td>
                    </tr>
                <?php }
            }
            ?>
            </tbody>
        </table>
        <div class="pagination" <?php echo $this->pagination->total==0 ? 'style="display:none"':''?>>
            <?php echo $this->pagination->getListFooter(); ?>
            <div class="clear"></div>
        </div>
    </div>
    <input type="hidden" name="option" value="<?php echo JBusinessUtil::getComponentName()?>" />
    <input type="hidden" name="task" id="task" value="" />
    <input type="hidden" name="id" id="id" value="" />
    <input type="hidden" name="Itemid" id="Itemid" />
    <?php echo JHTML::_('form.token'); ?>
</form>
<?php require_once JPATH_COMPONENT_SITE . "/include/status_legend.php" ?>
