<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');
$appSettings = JBusinessUtil::getApplicationSettings();

$menuItemId = JBusinessUtil::getActiveMenuItem();

JBusinessUtil::checkPermissions("directory.access.events", "managecompanyevents");
$isProfile = true;

?>
<script>
	var isProfile = true;
</script>
<style>
#header-box, #control-panel-link{
	display: none;
}

.tooltip {
    border-style:none !important;
}

  .tooltip-inner {
        background-color: rgba(0,0,0,0.55);
        max-width:600px;
        padding:2px 2px;
        text-align:center;
        border-radius:4px;
    }
    
</style>

<?php
	if(!$this->isCreateEventAllow){
		JFactory::getApplication()->enqueueMessage(JText::_('LNG_EVENT_CREATION_NOT_ALLOWED'),"notice");
		return;
	}

	if(empty($this->items)){
		$actionURL = JRoute::_('index.php?option=com_jbusinessdirectory&task=managecompanyevent.add');
		echo JBusinessUtil::getNewItemMessageBlock(JText::_("LNG_EVENT"),JText::_("LNG_EVENTS"),$actionURL);
		return;
	}
?>

<div class="button-row  justify-content-end">
	<?php 
	if ($appSettings->max_events > $this->total && $this->isCreateEventAllow) { ?>
		<button type="submit" class="btn btn-success button-add" onclick="jbdEvents.addDirEvent()">
			<span class="ui-button-text"><i class="la la-plus-sign"></i> <?php echo JText::_("LNG_ADD_NEW")?></span>
		</button>
	<?php } elseif ($appSettings->max_events <= $this->total) {
        JFactory::getApplication()->enqueueMessage(JText::_('LNG_MAX_EVENTS_REACHED'), 'warning');
    } ?>
</div>

<form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=managecompanyevents'.$menuItemId);?>" method="post" name="adminForm" id="adminForm">
	<div id="editcell">
		<table class="dir-panel-table responsive-simple">			
			<tbody>
				<?php
				$nrcrt=1;
				$i=0;
				if(!empty($this->items)){
					foreach($this->items as $event) { ?>
						<tr class="jtable-body-row row<?php echo $i % 2; ?>">
							<td class="jtable-body-row-data" align="left">
								<div class="item-head">
									<div class="item-image text-center">
										<?php if (!empty($event->picture_path)) { ?>
											<a href='<?php echo JRoute::_( 'index.php?option=com_jbusinessdirectory&task=managecompanyevent.edit&'.JSession::getFormToken().'=1&id='. $event->id )?>'>
												<img 
													src="<?php echo BD_PICTURES_PATH.$event->picture_path ?>" 
													class="img-circle"
												/>
											</a>
										<?php } else { ?>
											<a href="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&task=managecompanyevent.edit&'.JSession::getFormToken().'=1&id='. $event->id ) ?>">
												<img 
													src="<?php echo BD_PICTURES_PATH.'/no_image.jpg' ?>" 
													class="img-circle"
												/>
											</a>
										<?php } ?>
									</div>
								
									<div class="item-name text-left">
										<div class="item-title">
											<a href='<?php echo JRoute::_( 'index.php?option=com_jbusinessdirectory&task=managecompanyevent.edit&'.JSession::getFormToken().'=1&id='. $event->id )?>'
												title="<?php echo JText::_('LNG_CLICK_TO_EDIT'); ?>">
												<strong><?php echo $event->name ?></strong>
											</a>
											<div class="item-alias">
                                            	<?php echo $event->alias ?>
                                       		</div> 
										</div>
										<div>
											<?php if (count($event->checklist) > 0) { ?>
												<div id="<?php echo $event->id ?>"
													rel="tooltip" data-toggle="tooltip"
													data-trigger="click" data-placement="left" data-html="true" data-title=
													"
													<div>
														<table class='checklist'>
															<tbody>
															<?php foreach ($event->checklist as $key => $val) { ?>
																<tr>
																	<td class='jtable-body-row-data'>
																		<?php echo $val->name ?>
																	</div>
																	<td class='jtable-body-row-data status <?php echo $val->status ? 'status_done' : ''; ?>'>
																		<i class='la la-<?php echo $val->status ? 'check' : 'exclamation'; ?>'></i>
																	</div>
																</tr>
															<?php } ?>
															</tbody>
														</table>
													</div>
												">
													<div class="item-label"><?php echo JText::_("LNG_COMPLETED") ?></div>
													<div class="progress">
														<div class="progress-bar" role="progressbar" style="width: <?php echo $event->progress * 100 ?>%" aria-valuenow="<?php echo $event->progress * 100 ?>" aria-valuemin="0" aria-valuemax="100"></div>
													</div>
												</div>
											<?php } ?>
                                    	</div>										
									</div>
								</div>
							</td>                          
							
							<td class="jtable-body-row-data">
								<div class="cnt-hr">
									<div class="item-label"><?php echo JText::_("LNG_START_DATE") ?></div>
									<div class="item-value"><?php echo JBusinessUtil::getDateGeneralShortFormat($event->start_date) ?></div>
								</div>
								<div class="cnt-hr">	
									<div class="item-label"><?php echo JText::_("LNG_END_DATE") ?></div>
									<div class="item-value"><?php echo JBusinessUtil::getDateGeneralShortFormat($event->end_date) ?></div>
								</div>
							</td>

							<td class="jtable-body-row-data">
								<div class="item-label"><?php echo JText::_("LNG_COMPANY") ?></div>
								<div class="item-value"><?php echo $event->companyName ?></div>								
							</td>
							
							<td class="jtable-body-row-data" valign="top" align="center">    							
								<div class="item-status"> 
									<?php if(($event->state == 1) && ($event->approved == 1)) {
										if($event->expired)
											echo '<span class="status-badge badge-warning warn2">'.JText::_("LNG_EXPIRED").'</span>';
										elseif(!$event->allow_events)
											echo '<span class="status-badge badge-warning warn">'.JText::_("LNG_NOT_INCLUDED").'</span>';
										else
											echo '<span class="status-badge badge-success">'.JText::_("LNG_PUBLISHED").'</span>';
									} else {
										switch($event->approved) {
											case -1:
												echo '<span class="status-badge badge-danger">'.JText::_("LNG_DISAPPROVED").'</span>';
												break;
											case 0:
												echo '<span class="status-badge badge-info">'.JText::_("LNG_PENDING").'</span>';
												break;
											case 1:
												echo '<span class="status-badge badge-warning warn">'.JText::_("LNG_UNPUBLISHED").'</span>';
												break;
										}
									} ?>
								
									<div class="item-actions">
										<?php if($event->approved == 1) { ?>
											<a onclick="document.location.href='<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&task=managecompanyevent.chageState&id='. $event->id )?> '"
												title="<?php echo JText::_('LNG_CLICK_TO_CHANGE_STATE'); ?>" class="jtable-btn">
												<i class="<?php echo $event->state==0?"la la-check text-success":"la la-ban text-warning"?>"></i>
											</a>
										<?php } ?>
										<a href='<?php echo JRoute::_( 'index.php?option=com_jbusinessdirectory&task=managecompanyevent.edit&'.JSession::getFormToken().'=1&id='. $event->id )?>'
											title="<?php echo JText::_('LNG_CLICK_TO_EDIT'); ?>" class="jtable-btn">
											<i class="la la-pencil"></i>
										</a>
										<a target="_blank" href="<?php echo JBusinessUtil::getWebsiteURL(true).('index.php?option=com_jbusinessdirectory&view=event&eventId='.$event->id) ?>"
											title="<?php echo JText::_('LNG_CLICK_TO_VIEW'); ?>" class="jtable-btn"> 
											<i class="la la-eye"></i>
										</a>
										<a href="javascript:jbdEvents.deleteDirEvent(<?php echo $event->id ?>)"
											title="<?php echo JText::_('LNG_CLICK_TO_DELETE'); ?>" class="jtable-btn">
											<i class="la la-trash"></i>
										</a>
									</div>
								</div>
							</td>
						</tr>
					<?php
						$i++;
					} 
				}
			?>
			</tbody>			
		</table>
		<div class="pagination" <?php echo $this->pagination->total==0 ? 'style="display:none"':''?>>
			<?php echo $this->pagination->getListFooter(); ?>
			<div class="clear"></div>
		</div>
	</div>
	<input type="hidden" name="option"	value="<?php echo JBusinessUtil::getComponentName()?>" />
	<input type="hidden" name="task" id="task" value="" /> 
	<input type="hidden" name="cid" id="id" value="" />
	<input type="hidden" name="delete_mode" id="delete_mode" value="" />
	<input type="hidden" name="companyId" id="companyId" value="<?php echo $this->companyId ?>" />
		
	<?php echo JHTML::_( 'form.token' ); ?> 
</form>
<div class="clear"></div>

<?php require_once JPATH_COMPONENT_SITE . "/include/status_legend.php" ?>

<div id="delete-event-dialog" class="jbd-container" style="display: none">    
    <div class="jmodal-sm">
        <div class="jmodal-header">
            <p class="jmodal-header-title"><?php echo JText::_('LNG_DELETE_RECCURING_EVENT') ?></p>
            <a href="#close-modal" rel="modal:close" class="close-btn"><i class="la la-close "></i></a>
        </div>
        <div class="jmodal-body">
		<div class="dialogContentBody" id="dialogContentBody">
				<p>
					<?php echo JText::_('LNG_DELETE_RECCURING_EVENT_INFO') ?>
				</p>
				<fieldset>
					<div>
						<button type="button" class="btn btn" onclick="jbdEvents.deleteEvent()">
							<span class="ui-button-text"> <?php echo JText::_("LNG_ONLY_THIS_EVENT")?></span>
						</button>
						<?php echo JText::_('LNG_DELETE_ONLY_THIS_EVENT_INFO') ?>
					</div>
					<div>
						<button type="button" class="btn btn" onclick="jbdEvents.deleteAllFollowignEvents()">
							<span class="ui-button-text"> <?php echo JText::_("LNG_FOllOWINGS_EVENT")?></span>
						</button>
						<?php echo JText::_('LNG_DELETE_ALL_FOllOWINGS_EVENT_INFO') ?>
					</div>
					<div>
						<button type="button" class="btn btn" onclick="jbdEvents.deleteAllSeriesEvents()">
							<span class="ui-button-text"> <?php echo JText::_("LNG_ALL_SERIES_EVENTS")?></span>
						</button>
						<?php echo JText::_('LNG_DELETE_ALL_SERIES_EVENTS_INFO') ?>
					</div>
				</fieldset>			
			</div>           
    </div>
</div>

<script>
	window.addEventListener('load', function() {
		jQuery('#open_legend').click(function() {
			jQuery('#legend').jbdModal();
			!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+'://platform.twitter.com/widgets.js';fjs.parentNode.insertBefore(js,fjs);}}(document, 'script', 'twitter-wjs');
		});

        jQuery('[rel="tooltip"]').tooltip();

		jQuery(".button-add").click(function() {
            jQuery(this).addClass("loader")
        })
    });
</script>

