<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');

JBusinessUtil::loadJQueryUI();

JBusinessUtil::enqueueStyle('libraries/jquery/jquery.timepicker.css');
JBusinessUtil::enqueueScript('libraries/jquery/jquery.timepicker.min.js');
JBusinessUtil::loadJQueryChosen();

JBusinessUtil::enqueueScript('libraries/dropzone/dropzone.js');
JBusinessUtil::enqueueScript('libraries/chosen/ajax-chosen.min.js');

JBusinessUtil::enqueueStyle('libraries/dropzone/dropzone.css');
JBusinessUtil::enqueueStyle('libraries/dropzone/basic.css');


// following translations will be used in js
JText::script('LNG_VIDEO');
JText::script('LNG_MISSING_EVENT_COMPANY');
JText::script('LNG_MISSING_DELETED_COMPANY');
JText::script('LNG_IMAGE_SIZE_WARNING');


JBusinessUtil::includeValidation();

require_once HELPERS_PATH.'/helper.php';

class JBusinessDirectoryViewManageCompanyEvent extends JViewLegacy {
	public function __construct() {
		parent::__construct();
	}
	
	public function display($tpl = null) {
		$this->item	 = $this->get('Item');
		$this->state = $this->get('State');
		$this->states = JBusinessDirectoryHelper::getStatuses();

		$this->translations = JBusinessDirectoryTranslations::getAllTranslations(EVENT_DESCRIPTION_TRANSLATION, $this->item->id);
		$this->languages = JBusinessUtil::getLanguages();
		$this->actions = JBusinessDirectoryHelper::getActions();
		
		//check if user has access to offer
		$user = JBusinessUtil::getUser();
		
		$this->appSettings = JBusinessUtil::getApplicationSettings();
		$this->categoryOptions = JBusinessUtil::getCategoriesOptions(true, CATEGORY_TYPE_EVENT);
		$this->companyOptions = JBusinessUtil::getCompaniesOptions($this->item->company_id, $user->id);
		$this->associatedCompanyOptions = JBusinessUtil::getCompaniesOptions($this->item->company_id);
        $this->attendanceModes = JBusinessUtil::getAttendanceModes();

		$this->currencies = $this->get('Currencies');
		
		$lang = JBusinessUtil::getLanguageTag();
		$key="";
		if (!empty($this->appSettings->google_map_key)) {
			$key="&key=".$this->appSettings->google_map_key;
		}

		//check if user has access to event
		JBusinessUtil::checkEditAccessForItem($this->item->id, $this->item->user_id, $this->item->company_id, 'managecompanyevents');
		
		parent::display($tpl);
	}
}
