<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');

$menuItemId = JBusinessUtil::getActiveMenuItem();
JBusinessUtil::checkPermissions("directory.access.announcements", "managecompanyannouncements");

$isProfile = true;

?>
<script>
	var isProfile = true;
</script>
<style>
    #header-box, #control-panel-link{
    	display: none;
    }
    
    .tooltip {
        border-style:none !important;
    }

    .tooltip-inner {
        background-color: rgba(0,0,0,0.55);
        max-width:600px;
        padding:2px 2px;
        text-align:center;
        border-radius:4px;
     }
    
</style>

<?php if(empty($this->items)){
    $actionURL = JRoute::_('index.php?option=com_jbusinessdirectory&task=managecompanyannouncement.add');
    echo JBusinessUtil::getNewItemMessageBlock(JText::_("LNG_ANNOUNCEMENT"),JText::_("LNG_ANNOUNCEMENTS"),$actionURL);
    return;
} ?>

<div class="button-row  justify-content-end">
    <button type="submit" class="btn btn-success" onclick="jbdUtils.addDirAnnouncement()">
        <span class="ui-button-text"><i class="la la-plus-sign"></i> <?php echo JText::_("LNG_ADD_NEW")?></span>
    </button>
</div>

<form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=managecompanyannouncements'.$menuItemId);?>" method="post" name="adminForm" id="adminForm">
	<div id="editcell">
		<table class="dir-panel-table responsive-simple">			
			<tbody>
				<?php
				$nrcrt=1;
				$i=0;
				if(!empty($this->items)){
					foreach($this->items as $item) { ?>
						<tr class="jtable-body-row row<?php echo $i % 2; ?>">
							<td class="jtable-body-row-data">
								<div>
									<div class="item-name text-left">
										<div class="item-title">
											<a href='<?php echo JRoute::_( 'index.php?option=com_jbusinessdirectory&task=managecompanyannouncement.edit&'.JSession::getFormToken().'=1&id='. $item->id )?>'
												title="<?php echo JText::_('LNG_CLICK_TO_EDIT'); ?>">
												<?php echo $item->title ?>
											</a>
										</div>
										<div class="item-description">
											<?php echo $item->description ?>
										</div>										
									</div>
								</div>
							</td>
                          
							<td class="jtable-body-row-data">
								<div class="item-label"><?php echo JText::_("LNG_COMPANY") ?></div>
								<div class="item-value"><?php echo $item->companyName ?></div> 
							</td>
                            <td class="jtable-body-row-data" >
								<div class="item-label"><?php echo JText::_("LNG_EXPIRATION_DATE") ?></div>
								<div class="item-value"><?php echo JBusinessUtil::getDateGeneralShortFormat($item->expiration_date); ?></div>
                            </td>						
							<td class="jtable-body-row-data" align="center">
								<div class="item-status"> 
									<?php 
										if(!$item->allow_announcements){
											echo '<span class="status-badge badge-warning warn">'.JText::_("LNG_NOT_INCLUDED").'</span>';
										}else{
											if(($item->status == 1)) {
												echo '<div class="status-badge badge-success">'.JText::_("LNG_PUBLISHED").'</div>';
											} else {
												echo '<div class="status-badge badge-warning warn">'.JText::_("LNG_UNPUBLISHED").'</div>';
											} 
										}
									?>
																
									<div class="item-actions">
										<a onclick="document.location.href='<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&task=managecompanyannouncement.chageState&id='. $item->id. '&status='.$item->status )?> '"
											title="<?php echo JText::_('LNG_CLICK_TO_CHANGE_STATE'); ?>" class="jtable-btn">
											<i class="<?php echo $item->status==0?"la la-check text-success":"la la-ban text-warning"?>"></i>
										</a>
										<a href='<?php echo JRoute::_( 'index.php?option=com_jbusinessdirectory&task=managecompanyannouncement.edit&'.JSession::getFormToken().'=1&id='. $item->id )?>'
											title="<?php echo JText::_('LNG_CLICK_TO_EDIT'); ?>" class="jtable-btn">
											<i class="la la-pencil"></i>
										</a>
										<a href="javascript:jbdUtils.deleteDirAnnouncement(<?php echo $item->id ?>)"
											title="<?php echo JText::_('LNG_CLICK_TO_DELETE'); ?>" class="jtable-btn">
											<i class="la la-trash"></i>
										</a>
									</div>
								</div>
							</td>
						</tr>
					<?php
						$i++;
					} 
				}
			?>
			</tbody>
			<tfoot>
			</tfoot>
		</table>
		<div class="pagination" <?php echo $this->pagination->total==0 ? 'style="display:none"':''?>>
			<?php echo $this->pagination->getListFooter(); ?>
			<div class="clear"></div>
		</div>
	</div>
	<input type="hidden" name="option"	value="<?php echo JBusinessUtil::getComponentName()?>" />
	<input type="hidden" name="task" id="task" value="" /> 
	<input type="hidden" name="cid" id="id" value="" />
    <input type="hidden" name="delete_mode" id="delete_mode" value="" />
    <input type="hidden" name="view" id="view" value="managecompanyannouncements" />

	<?php echo JHTML::_( 'form.token' ); ?> 
</form>
<?php require_once JPATH_COMPONENT_SITE . "/include/status_legend.php" ?>
