<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');


JBusinessUtil::loadJQueryUI();

JBusinessUtil::enqueueScript('libraries/chosen/ajax-chosen.min.js');
JBusinessUtil::loadJQueryChosen();

JBusinessUtil::includeValidation();

require_once HELPERS_PATH.'/helper.php';

class JBusinessDirectoryViewManageCompanyAnnouncement extends JViewLegacy {
	public function __construct() {
		parent::__construct();
	}
	
	public function display($tpl = null) {
		$this->item	 = $this->get('Item');
		$this->state = $this->get('State');
		$this->actions2 = JBusinessDirectoryHelper::getActions();
		$this->actions = JBusinessUtil::getAnnouncementActions();
		$this->appSettings = JBusinessUtil::getApplicationSettings();

		$this->translations = JBusinessDirectoryTranslations::getAllTranslations(ANNOUNCEMENT_DESCRIPTION_TRANSLATION, $this->item->id);
		$this->languages    = JBusinessUtil::getLanguages();
		
		$user = JBusinessUtil::getUser();
		$companyId = null;
		if (isset($this->item->companyId)) {
			$companyId = $this->item->companyId;
		}
		$this->companyOptions = JBusinessUtil::getCompaniesOptions($companyId, $user->id);

		parent::display($tpl);
	}
}
