<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );

if (! defined ( 'BD_COMPONENT_IMAGE_PATH' ))
	define ( "BD_COMPONENT_IMAGE_PATH", BD_ASSETS_FOLDER_PATH."images/" );

$appSettings = JBusinessUtil::getApplicationSettings();
$lang        = JBusinessUtil::getLanguageTag();
$key         = JBusinessUtil::loadMapScripts();

$map_latitude = ( float ) $appSettings->map_latitude;
$map_longitude = ( float ) $appSettings->map_longitude;
$map_apply_search = $appSettings->map_apply_search;

$map_latitude = ( float ) $appSettings->map_latitude;
$map_longitude = ( float ) $appSettings->map_longitude;
$map_zoom = ( float ) $appSettings->map_zoom;

if ((empty ( $map_latitude )) || (! is_numeric ( $map_latitude )))
	$map_latitude = 43.749156;

if ((empty ( $map_longitude )) || (! is_numeric ( $map_longitude )))
	$map_longitude = - 79.411048;

if ((empty ( $map_zoom )) || (! is_numeric ( $map_zoom ))) {
    $map_zoom = 6;
}

if ($map_apply_search == '0') {
	$map_latitude = 43.749156;
	$map_longitude = - 79.411048;
	$map_zoom = 6;
}

$session = JFactory::getSession();
if (empty($radius)) {
	$radius = JFactory::getApplication()->input->get("radius");
    if (empty($radius)) {
        $radius = $session->get("radius");
    }
}

if ($appSettings->enable_map_clustering) {
    JBusinessUtil::enqueueScript('libraries/map/markercluster.js');
}

$mapId = rand ( 1000, 10000 );

$event_locations = array ();

$db = JFactory::getDBO ();

if (! isset ( $events ))
	$events = $this->events;

$index = 1;
foreach ( $events as $event ) {
	$tmp = array ();
	$marker = 0;
	if (! empty ( $event->categoryMaker )) {
		$marker = BD_PICTURES_PATH . $event->categoryMaker;
	}

    $phone = !empty($event->phone) ? $event->phone : null;
    $event->phone = !empty($event->contact_phone) ? $event->contact_phone : $phone;
	$contentString = '<div class="info-box">' . '<div class="title">' . htmlspecialchars($event->name) . '</div>' . '<div class="info-box-content">' . '<div class="address" itemtype="http://schema.org/PostalAddress" itemscope="" itemprop="address">' . JBusinessUtil::getAddressText ( $event ) . '</div>';
	if (!empty($event->phone)) {
		$contentString .= '<div class="info-phone"><i class="la la-phone"></i> ' . htmlspecialchars($event->phone, ENT_QUOTES). '</div>';
	}

	$contentString .= '<a href="' . htmlspecialchars(JBusinessUtil::geteventLink ( $event->id, $event->alias )) . '"><i class="la la-external-link"></i> ' . $db->escape ( JText::_ ( "LNG_MORE_INFO", true ) ) . '</a>' . '</div>' . '<div class="info-box-image">' . (! empty ( $event->picture_path ) ? '<img src="' . BD_PICTURES_PATH . $event->picture_path . '" alt="' . htmlspecialchars($event->name) . '">' : "") . '</div>' . '</div>';
	
	if (! empty ( $event->latitude ) && ! empty ( $event->longitude )) {
		$tmp ['title'] = htmlspecialchars($event->name);
		$tmp ['latitude'] = $event->latitude;
		$tmp ['longitude'] = $event->longitude;
		$tmp ['zIndex'] = 4;
		$tmp ['content'] = $contentString;
		$tmp [] = $index;
		$tmp ['marker'] = $marker;
		$tmp ['in_range'] = 1;


		$event_locations [] = $tmp;
	}
	
	$index ++;
}

// the params array that will be used on map.js
$initparams = array ();
$initparams ["tmapId"] = $mapId;
$initparams ["map_div"] = 'events-map-';
$initparams ["map_latitude"] = ! empty ( $map_latitude ) ? $map_latitude : 0;
$initparams ["map_longitude"] = ! empty ( $map_longitude ) ? $map_longitude : 0;
$initparams ["map_zoom"] = $map_zoom;
$initparams ["has_location"] = (isset($this) && ! empty($this->location ["latitude"])) ? 1 : 0;
$initparams ["radius"] = ! empty ( $radius ) ? $radius : 0;
$initparams ["imagePath"] = BD_COMPONENT_IMAGE_PATH;
$initparams ["longitude"] = '';
$initparams ["latitude"] = '';
if (isset ( $this ) && ! empty ( $this->location ["latitude"] )) {
	$initparams ["longitude"] = $this->location ["longitude"];
	$initparams ["latitude"] = $this->location ["latitude"];
}

if ($appSettings->map_type == MAP_TYPE_BING) {
	$initparams["key"] = $key;
}
?>
<div id="events-map-<?php echo $mapId ?>" style="position: relative;"></div>

<script>
    var mapInstance;

    window.addEventListener('load', function() {
        mapInstance = JBDMapHelper.loadMapScript(
		    <?php echo json_encode($event_locations) ?>,
		    <?php echo json_encode($initparams) ?>,
		    <?php echo $appSettings->map_type ?>
        );
    });
</script>

<?php echo JBusinessUtil::getMapGDPRModal(); ?>