<?php // no direct access
/**
* @copyright	Copyright (C) 2008-2009 CMSJunkie. All rights reserved.
* 
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
* See the GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

defined('_JEXEC') or die('Restricted access');

$document = JFactory::getDocument();
$config = JBusinessUtil::getSiteConfig();
$appSettings = JBusinessUtil::getApplicationSettings();

$base_url = ( isset($_SERVER['HTTPS']) && $_SERVER['HTTPS']=='on' ? 'https' : 'http' ) . '://' .  $_SERVER['HTTP_HOST'];
$url = $base_url . $_SERVER["REQUEST_URI"];

$title = "";
$description = "";
$keywords = "";
$image = "";

$items = array();
if(!empty($this->category->name))
	$items[] = $this->escape($this->category->name);
if(!empty($this->type))
    $items[] = $this->type->name;
if(!empty($this->citySearch))
	$items[] = $this->escape($this->citySearch);
if(!empty($this->regionSearch))
	$items[] = $this->escape($this->regionSearch);
if(!empty($this->provinceSearch))
    $items[]= $this->provinceSearch;
if(!empty($this->countrySearch))
    $items[]= $this->escape($this->country->country_name);

$items[] = JText::_("LNG_EVENTS");
$title = implode(" | ",$items);
$title .= " | ".$config->sitename;

if (isset($this->category)){
	if (!empty($this->category->meta_title)){
		$title = $this->category->meta_title;
	}
	if (!empty($this->category->meta_description)){
		$description = $this->category->meta_description;
	}
	if (!empty($this->category->meta_keywords)){
		$keywords =  $this->category->meta_keywords;
	}
	if (!empty($this->category->imageLocation)){
		$image = $this->category->imageLocation;
	}
}

$title = JBusinessUtil::getPageTitle($title);
JBusinessUtil::setMetaData($title, $description, $keywords, true);
JBusinessUtil::setFacebookMetaData($title, $description,$image, $url);

$menuItemId = JBusinessUtil::getActiveMenuItem();

$enableSearchFilter = $appSettings->enable_search_filter_events;
$fullWidth = true;

$mposition = "dir-search-events-top";
$topModules = JModuleHelper::getModules($mposition);
$mposition = "dir-search-events";
if (!empty($this->category)) {
    $mposition = "dir-search-events-" . $this->category->alias;
}
$bottomModules = JModuleHelper::getModules($mposition);

if($enableSearchFilter || !empty($topModules) || !empty($bottomModules)){
    $fullWidth = false;
}


$setCategory = isset($this->category)?1:0;
$categId = isset($this->categoryId)?$this->categoryId:0;
$showClear = 0;

//add the possibility to chage the view and layout from http params
$input = JFactory::getApplication()->input;
$grid_layout = $input->get('grid_layout');
if(!empty($grid_layout)) {
    $this->appSettings->events_search_results_grid_view = $grid_layout;
}

$list_layout = $input->get('list_layout');
if(!empty($list_layout)) {
    $this->appSettings->events_search_results_list_view = $list_layout;
}

$view_mode = $input->get('view_mode',null);
if(isset($view_mode)) {
    $this->appSettings->events_search_view = $view_mode;
}
?>

 <?php if (!empty($this->params) && $this->params->get('show_page_heading', 1)) { ?>
    <div class="page-header">
        <h1 class="title"> <?php echo $this->escape($this->params->get('page_heading')); ?> </h1>
    </div>
 <?php } ?>
<div id="jbd-container" class="jbd-container">
	<div class="row" id="filterCategoryItems">
		<?php if(!$fullWidth){?>
    		<div class="col-lg-3">
            	<?php if(!empty($topModules)) { ?>
            		<div class="search-modules">
            			<?php 
            			foreach($topModules as $module) {
            				echo JModuleHelper::renderModule($module, array("style"=>"xhtml"));
            			} ?>
            		</div>
            	<?php } ?>	
                <?php if($enableSearchFilter){?>
                    <div id="search-filters-react">
                    </div>
                <?php } ?>
                     
                <?php if (!empty($bottomModules)) { ?>
                    <div class="search-modules">
                        <?php
                            foreach ($bottomModules as $module) {
                                echo JModuleHelper::renderModule($module, array("style"=>"xhtml"));
                            }
                        ?>
                    </div>
                <?php } ?>
			</div>
    	<?php }?>

		<div id="search-results" class="events-container search-results col-lg">
			<?php
                jimport('joomla.application.module.helper');
                // this is where you want to load your module position
                $modules = JModuleHelper::getModules("events-search");
            ?>
                <?php if(isset($modules) && count($modules)>0) { ?>
                    <div class="search-modules">
                        <?php
                        $fullWidth = false;
                        foreach($modules as $module) {
                            echo JModuleHelper::renderModule($module, array("style"=>"xhtml"));
                        } ?>
                        <div class="clear"></div>
                    </div>
            <?php } ?>

			<form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory'.$menuItemId) ?>" method="<?php echo $this->appSettings->event_submit_method ?>" name="adminForm" id="adminForm">
				<div class="search-header">
					 <div class="jbd-search-statistics">
                		<div class="search-keyword">
                            <div class="result-counter"><?php echo $this->pagination->getResultsCounter()?></div>
                        </div>
                        <div>
                            <div class="search-options">
                                    <div class="jbd-select-box">
                                        <i class="la la-sort"></i>
                                        <select name="orderBy" class="chosen jbd-select" onchange="jbdUtils.changeOrder(this.value)">
                                            <?php echo JHtml::_('select.options', $this->sortByOptions, 'value', 'text',  $this->orderBy);?>
                                        </select>
                                    </div>
                                    
                                    <?php if($this->appSettings->show_grid_list_option == 1) { ?>
                                    	<div class="view-mode">
											<a id="grid-view-link" class="grid" href="javascript:jbdEvents.showGrid(<?php echo $this->appSettings->events_search_results_grid_view==1?"true":""?>)"><i class="la la-th-large"></i></a>
											<a id="list-view-link" class="list active"  href="javascript:jbdEvents.showEventList(<?php echo $this->appSettings->events_search_results_list_view ?>)"><i class="la la-list-ul"></i></a>
										</div>
                                    <?php } ?>
    
                                    <?php if($this->appSettings->show_search_map && $this->defaultAttributes['map'] != ATTRIBUTE_NOT_SHOW  && !empty($this->events)) { ?>
                                    	<div class="map-view">
                                            <a id="map-link" class="map <?php echo $this->appSettings->map_auto_show != 1 ? 'active' : '' ?>" title="Grid" href="javascript:jbdUtils.showMap(true)">
                                                <i class="la la-map"></i></a>
                                         </div>
                                    <?php } ?>
                                
                                <?php if($this->appSettings->enable_rss == 1) { ?>
        							<div class="search-options-item">
        								<a class="map" onclick="jQuery('#rss-model').jbdModal();" target="_blank">
                                            <i class="la la-rss"></i>        								</a>
        							</div>
        						<?php } ?>
                            </div>
                        </div>
                    </div>
                    
					<?php require_once 'search_params.php'; ?>
                

    				<?php if(isset($this->category) && $this->appSettings->show_cat_description && !empty($this->category->description)) { ?>
    					<div class="category-container">
            				<div class="row">
                				<?php if(!empty($this->category->imageLocation)) { ?>
                					<div class="col-md-3">
                						<div class="categoy-image"><img alt="<?php echo $this->category->name?>" src="<?php echo BD_PICTURES_PATH.$this->category->imageLocation ?>"></div>
                					</div>
                				<?php } ?>
            					<div class="col-md">
            						<h1><?php echo $this->category->name?></h1>
                    				<div>
                    					<div id="category-description" class="dir-cat-description">
                    						<div class="intro-text">
                    							<?php echo JBusinessUtil::truncate(JHTML::_("content.prepare", $this->category->description),300) ?>
                    							<?php if(strlen(strip_tags($this->category->description))>strlen(strip_tags(JBusinessUtil::truncate(JHTML::_("content.prepare", $this->category->description),300)))){?>
                    								<a class="cat-read-more" href="javascript:void(0)" onclick="jQuery('#category-description').toggleClass('open')">
                    									<?php echo JText::_("LNG_MORE") ?> </a>
                    							<?php } ?>
                    						</div>
                    						<div class="full-text">
                    							<?php echo JHTML::_("content.prepare", $this->category->description) ?>
                    							<a class="cat-read-more" href="javascript:void(0)" onclick="jQuery('#category-description').toggleClass('open')">
                    									<?php echo JText::_("LNG_LESS") ?> </a>
                    						</div>
                    					</div>
                    				</div>        					
            					</div>
            				</div>
            			</div>
    				<?php } ?>
		
					<div id="search-details">
						<div id="search-module" class="search-module">
							<?php
									$modules = JModuleHelper::getModules("events-search-middle");
									foreach($modules as $module) {
										echo JModuleHelper::renderModule($module, array("style"=>"xhtml"));
									}
							?>
							<div class="clear"></div>
						</div>
					</div>

					<div class="clear"></div>
				</div>
				<?php if($this->appSettings->show_search_map && !empty($this->events) && $this->defaultAttributes['map'] != ATTRIBUTE_NOT_SHOW){?>
    				<div id="companies-map-container" <?php echo !$this->appSettings->map_auto_show ? 'style="display:none;"' : '' ?>>
    					<?php require 'map.php' ?>
    				</div>
				<?php } ?>
			
				<?php 
				    if($this->appSettings->events_search_results_grid_view==1){
					   require_once 'events_calendar.php';
				    }else{
				        require_once 'events_grid_view_style_1.php';
				    }
					
				    if($this->appSettings->events_search_results_list_view==3){
				        require_once 'events_list_style_3.php';
				    }else if($this->appSettings->events_search_results_list_view==2){
					    require_once 'events_list_style_2.php';
					}else{
					    require_once 'events_list_style_1.php';
					}
				?>
					
				<div class="pagination" <?php echo $this->pagination->total==0 ? 'style="display:none"':''?>>
					<?php echo $this->pagination->getListFooter(); ?>
					<div class="clear"></div>
				</div>		
				<div class="clear"></div>	
		
				<input type='hidden' name='option' value='com_jbusinessdirectory'/>
				<input type='hidden' name='view' value='events' />
				<input type='hidden' name='searchkeyword' id="searchkeyword" value='<?php echo isset($this->searchkeyword)?$this->searchkeyword:'' ?>' />
				<input type='hidden' id='categoryId' name='categoryId'  value='<?php echo !empty($this->categoryId)?$this->categoryId:"0" ?>' />
				<input type='hidden' id='city-search' name='citySearch' value="<?php echo !empty($this->citySearch)?$this->escape($this->citySearch): "" ?>" />
				<input type='hidden' id='region-search' name='regionSearch' value="<?php echo !empty($this->regionSearch)?$this->escape($this->regionSearch): "" ?>" />
				<input type='hidden' id='type-search' name='typeSearch' value='<?php echo !empty($this->typeSearch)?$this->typeSearch: '' ?>' />
                <input type='hidden' name='countrySearch' id='country-search' value='<?php echo !empty($this->countrySearch)?$this->countrySearch: '' ?>' />
                <input type='hidden' name='provinceSearch' id='province-search' value="<?php echo !empty($this->provinceSearch)?$this->escape($this->provinceSearch): "" ?>" />
                <input type='hidden' name='areaSearch' id='area-search' value="<?php echo !empty($this->areSaearch)?$this->escape($this->areSaearch): "" ?>" />
                <input type='hidden' name='startDate' id='startDate' value='<?php echo !empty($this->startDate)?$this->startDate: '' ?>' />
				<input type='hidden' name='endDate' id='endDate' value='<?php echo !empty($this->endDate)?$this->endDate: '' ?>' />
				<input type='hidden' name='zipcode' id="zipcode" value="<?php echo !empty($this->zipCode)?$this->escape($this->zipCode): "" ?>" />
				<input type='hidden' name='radius' id="radius" value='<?php echo isset($this->radius)?$this->radius: '' ?>' />
				<input type='hidden' name='selectedParams' id='selectedParams' value='<?php echo !empty($this->selectedParams["selectedParams"])?$this->selectedParams["selectedParams"]:"" ?>' />
				<input type='hidden' name='categories' id="categories-filter" value='<?php echo !empty($this->categories)?$this->categories:"" ?>' />
				<input type='hidden' name='resetSearch' id="resetSearch" value="" />
                <input type='hidden' name='age' id="age" value="<?php echo !empty($this->age)?$this->escape($this->age): "" ?>" />
                <input type='hidden' name='start_time' id="start_time" value="<?php echo !empty($this->startTime)?$this->escape($this->startTime): "" ?>" />
                <input type='hidden' name='end_time' id="end_time" value="<?php echo !empty($this->endTime)?$this->escape($this->endTime): "" ?>" />

                <?php if(!empty($this->customAtrributes)){ ?>
                    <?php foreach($this->customAtrributes as $key=>$val){?>
                        <input type='hidden' id='attribute_<?php echo $key?>' name='attribute_<?php echo $key?>' value='<?php echo $val ?>' />
                    <?php } ?>
                <?php } ?>
			</form>	
		</div>
	</div>
</div>

<div class="jbd-container" id="rss-model" style="display: none">
    <form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=events');?>" method="get" name="rssForm" id="rssForm">
        <div class="jmodal-sm">
            <div class="jmodal-header">
                <p class="jmodal-header-title"><?php echo JText::_('LNG_EVENT_RSS') ?></p>
                <a href="#close-modal" rel="modal:close" class="close-btn"><i class="la la-close "></i></a>
            </div>
            <div class="jmodal-body">
                <p><?php echo JText::_('LNG_CATEGORY_RSS_TEXT'); ?></p>
                <div class="row">
                    <div class="col-12">
                        <div class="jinput-outline jinput-hover">
                            <select name="category" id="category" class="form-control chosen-select">
                                <option value="0"><?php echo JText::_("LNG_ALL_CATEGORIES") ?></option>
								<?php echo JHtml::_('select.options', $this->categoryOptions, 'value', 'text', null);?>
                            </select>
                        </div>
                    </div>
                </div>
                <input type="hidden" name="option"	value="<?php echo JBusinessUtil::getComponentName()?>" />
                <input type="hidden" name="task" id="task" value="directoryrss.getEventsRss" />
				<?php echo JHTML::_( 'form.token' ); ?>
            </div>
            <div class="jmodal-footer">
                <div class="btn-group" role="group" aria-label="">
                    <button type="button" class="jmodal-btn jmodal-btn-outline" onclick="jQuery.jbdModal.close()"><?php echo JText::_("LNG_CANCEL")?></button>
                    <button type="submit" class="jmodal-btn"><?php echo JText::_("LNG_GENERATE")?></button>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
window.addEventListener('load', function(){

    const e = React.createElement;
    ReactDOM.render(
        e(SearchFilter, {itemType: JBDConstants.ITEM_TYPE_EVENT}),
        document.querySelector('#search-filters-react')
    );

	<?php if ($this->appSettings->events_search_view == 1) {?>
		jbdEvents.showGrid(<?php echo $this->appSettings->events_search_results_grid_view==1?"true":""?>);
	<?php }else if ($this->appSettings->events_search_view == 2 && $this->appSettings->events_search_results_list_view==1){ ?>
		jbdEvents.showEventList(1);
	<?php } else if ($this->appSettings->events_search_view == 2 && $this->appSettings->events_search_results_list_view==2){?>
		jbdEvents.showEventList(2);
	<?php } else {?>
		jbdEvents.showEventList(1);
	<?php } ?>

    <?php if($this->appSettings->show_search_map && !empty($this->events) && $this->defaultAttributes['map'] != ATTRIBUTE_NOT_SHOW){?>
    	jbdUtils.showMap();
	<?php } ?>

	jQuery(".chosen").chosen({width:"165px", disable_search_threshold: 5, inherit_select_classes: true , placeholder_text_single: "<?php echo JText::_('LNG_SELECT_OPTION')  ?>" , placeholder_text_multiple: "<?php echo JText::_('LNG_SELECT_OPTION')  ?>"});
    jQuery(".chosen-select").chosen({width: "95%", disable_search_threshold: 5, search_contains: true , placeholder_text_single: "<?php echo JText::_('LNG_SELECT_OPTION')  ?>" , placeholder_text_multiple: "<?php echo JText::_('LNG_SELECT_OPTION')  ?>"});

});
</script>
