<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');

JBusinessUtil::enqueueScript('libraries/jquery/jquery.opacityrollover.js');

JBusinessUtil::loadJQueryChosen();

JBusinessUtil::enqueueStyle('libraries/magnific-popup/magnific-popup.css');
JBusinessUtil::enqueueScript('libraries/magnific-popup/jquery.magnific-popup.min.js');

JBusinessUtil::includeValidation();

class JBusinessDirectoryViewEvent extends JViewLegacy {
	public function __construct() {
		parent::__construct();
	}
	
	public function display($tpl = null) {
		$this->appSettings =  JBusinessUtil::getApplicationSettings();
		$this->defaultAttributes = JBusinessUtil::getAttributeConfiguration(DEFAULT_ATTRIBUTE_TYPE_EVENT);
		$this->newTab = ($this->appSettings->open_listing_on_new_tab)?" target='_blank'":"";

		if ($this->appSettings->enable_multilingual) {
			JBusinessDirectoryTranslations::updateEntityTranslation($this->appSettings, TERMS_CONDITIONS_TRANSLATION);
			JBusinessDirectoryTranslations::updateEntityTranslation($this->appSettings, CONTACT_TERMS_CONDITIONS_TRANSLATION);
			JBusinessDirectoryTranslations::updateEntityTranslation($this->appSettings, REVIEWS_TERMS_CONDITIONS_TRANSLATION);
			JBusinessDirectoryTranslations::updateEntityTranslation($this->appSettings, PRIVACY_POLICY_TRANSLATION);
		}

		if ($this->appSettings->enable_event_reservation) {
			$this->eventTickets = $this->get('EventTickets');
		}
		$this->event = $this->get('Event');
		if (empty($this->event) || $this->event->approved == EVENT_STATUS_DISAPPROVED || $this->event->state == 0 ||
			($this->event->approved == EVENT_STATUS_NEEDS_APPROVAL && 
				!($this->appSettings->enable_item_moderation=='0' || 
					($this->appSettings->enable_item_moderation=='1' && $this->appSettings->show_pending_approval == '1')))) {
			$tpl="inactive";
		}else{
			$this->eventAttributes = $this->get('EventAttributes');
			
			if ($this->defaultAttributes["associated_listings"]!=ATTRIBUTE_NOT_SHOW) {
				$this->associatedCompanies = $this->get('AssociatedCompanies');
			}
			
			$this->userCompanies = $this->get('CompaniesByUserId');
			$this->userAssociatedCompanies = $this->get('UserAssociatedCompanies');
			$this->videos = $this->defaultAttributes['video'] != ATTRIBUTE_NOT_SHOW? $this->get('EventVideos') : array();
			$this->videos = array_slice($this->videos, 0, $this->appSettings->max_video);

			$session = JFactory::getSession();
			$this->location = $session->get('location');
		}
		
		parent::display($tpl);
	}
}
