<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');
?>

<div id="company-contact" class="jbd-container" style="display:none">
    <form id="contactCompanyFrm" name="contactCompanyFrm" action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory') ?>" method="post">
        <div class="jmodal-sm">
            <div class="jmodal-header">
                <p class="jmodal-header-title"><?php echo JText::_('LNG_CONTACT_EVENT_OWNER') ?></p>
                <a href="#close-modal" rel="modal:close" class="close-btn"><i class="la la-close "></i></a>
            </div>
            <div class="jmodal-body">
                <p>
					<?php echo JText::_('LNG_EVENT_CONTACT_TEXT') ?>
				</p>
                <!-- First Step -->
                <div class="form-step-1">                
                    <div class="row">
                        <div class="col-12">
                            <div class="jinput-outline jinput-hover">
                                <textarea rows="10" name="description" id="description" class="form-control validate[required]" required=""></textarea>
                                <label for="description"><?php echo JText::_('LNG_CONTACT_TEXT')?>:</label>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Second Step -->
                <div class="form-step-2" style="display:none">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="jinput-outline jinput-hover">
                                <input class="validate[required]" id="firstName" name="firstName" type="text" value="" required="" >
                                <label for="firstName"><?php echo JText::_('LNG_FIRST_NAME') ?></label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="jinput-outline jinput-hover">
                                <input class="validate[required]" id="lastName" type="text" name="lastName" id="lastName" value="" required="">
                                <label for="lastName"><?php echo JText::_('LNG_LAST_NAME') ?></label>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="jinput-outline jinput-hover">
                                <input type="text" name="email" id="email" class="validate[required,custom[email]]" value="" required="">
                                <label for="email"><?php echo JText::_('LNG_EMAIL_ADDRESS') ?></label>
                            </div>
                        </div>
                    </div>                

                    <div class="row">
                        <div class="col-12">
                            <div class="jbd-checkbox justify-content-end">
                                <label for="copy-me"><?php echo JText::_('LNG_COPY_ME')?></label>
                                <input type="checkbox" name="copy-me" value="1" />
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <?php echo JBusinessUtil::renderTermsAndConditions('contact'); ?>
                        </div>

                        <?php if($this->appSettings->captcha){?>
                            <div class="form-item">
                                <?php
                                $namespace="jbusinessdirectory.contact";
                                $class=" required";

                                $captcha = JCaptcha::getInstance("recaptcha", array('namespace' => $namespace));

                                if(!empty($captcha)){
                                    echo $captcha->display("captcha", "captcha-div-contact", $class);
                                }
                                ?>
                            </div>
                        <?php } ?>

                        <?php echo JHTML::_( 'form.token' ); ?>
                        <input type='hidden' name="option" value="com_jbusinessdirectory"/>
                        <input type='hidden' name='task' value='event.contactCompany'/>
                        <input type="hidden" name="contact_id_event" value="<?php echo $this->event->contact_email ?>" />
                        <input type='hidden' name='userId' value='<?php echo $user->id?>'/>
                        <input type="hidden" name="companyId" value="<?php echo $this->event->company->id?>" />
                        <input type="hidden" name="event_id" value="<?php echo $this->event->id?>" />
                    </div>
                </div>
                <div class="jmodal-footer">
                    <div class="btn-group" role="group" aria-label="">
                        <div class="btn-step-1">
                            <button type="button" class="jmodal-btn jmodal-btn-outline" onclick="jQuery.jbdModal.close()"><?php echo JText::_("LNG_CANCEL")?></button>
                            <button type="button" class="jmodal-btn jbd-commit jbd-btn-next" disabled><?php echo JText::_("LNG_NEXT")?></button>                                
						</div>
						<div class="btn-step-2" style="display:none">
                            <button type="button" class="jmodal-btn jmodal-btn-outline jbd-btn-back"><?php echo JText::_("LNG_BACK")?></button>
                            <button type="button" class="jmodal-btn jbd-commit" onclick="jbdUtils.saveForm('contactCompanyFrm')"><?php echo JText::_("LNG_SEND")?></button>
						</div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>


<div id="login-notice" class="jbd-container" style="display:none">
    <div class="jmodal-sm">
        <div class="jmodal-header">
            <p class="jmodal-header-title"><?php echo JText::_('LNG_INFO') ?></p>
            <a href="#close-modal" rel="modal:close" class="close-btn"><i class="la la-close "></i></a>
        </div>
        <div class="jmodal-body">
            <p>
                <?php echo JText::_('LNG_YOU_HAVE_TO_BE_LOGGED_IN') ?>
            </p>
            <p>
                <a href="<?php echo JBusinessUtil::getLoginUrl($url); ?>"><?php echo JText::_('LNG_CLICK_LOGIN') ?></a>
            </p>
        </div>
    </div>
</div>

<div id="company-list" class="jbd-container" style="display:none">
    <div class="jmodal-sm">
        <div class="jmodal-header">
            <p class="jmodal-header-title"><?php echo JText::_('LNG_SELECT_COMPANIES') ?></p>
            <a href="#close-modal" rel="modal:close" class="close-btn"><i class="la la-close "></i></a>
        </div>
        <div class="jmodal-body">
            <div class="dialogContentBody" style="padding-bottom:30px;" id="dialogContentBody">
                <p><?php echo JText::_('LNG_SELECT_COMPANIES_TO_ASSOCIATE'); ?></p>
                <select name="associatedCompanies[]" id="userAssociatedCompanies" multiple
                        title="<?php echo JText::_('LNG_JOPTION_SELECT_COMPANY'); ?>"
                        class="chosen-select validate[required]">
                    <?php echo JHtml::_('select.options', $this->userCompanies, 'id', 'name', $this->userAssociatedCompanies); ?>
                </select>
            </div>
            <div style="display:none;" class="jbd-container" id="associated-companies-message">
                <div class="jmodal-sm jbd-container">
                    <div class="jmodal-header">
                        <p class="jmodal-header-title"><?php echo JText::_('LNG_COMPANIES_JOINED_EVENT') ?></p>
                    </div>
                    <div class="jmodal-body">
                        <p><?php echo JText::_('LNG_EVENT_OWNER_NOTIFIED'); ?></p>
                    </div>
                    <div class="jmodal-footer">
                        <div class="btn-group" role="group" aria-label="">
                            <button type="button" class="jmodal-btn" onclick="jQuery.jbdModal.close()"><?php echo JText::_("LNG_CLOSE")?></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="jmodal-footer">
            <div class="btn-group" role="group" aria-label="">
                <button type="button" class="jmodal-btn jmodal-btn-outline" onclick="jQuery.jbdModal.close()"><?php echo JText::_("LNG_CANCEL")?></button>
                <button type="submit" class="jmodal-btn" onclick="jbdEvents.associateCompanies(<?php echo $this->event->id ?>)"><?php echo JText::_("LNG_SUBMIT")?></button>
            </div>
        </div>
    </div>
</div>

<script>
	window.addEventListener('load', function(){		
        jbdUtils.renderContactFormSteps();
		<?php if (!empty($this->event->latitude) && !empty($this->event->longitude)) { ?>
            loadEventDetailsViewMap();
        <?php } ?>
	});
</script>