<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');
?>

<?php if(!empty($this->eventTickets)&& (isset($this->event->companyPackage->features) && in_array(EVENT_BOOKINGS,$this->event->companyPackage->features) || !$this->appSettings->enable_packages) ) { ?>

 	<?php if(!JBusinessUtil::emptyDate($this->event->booking_open_date) || !JBusinessUtil::emptyDate($this->event->booking_close_date)){?>
        <?php if(!(!JBusinessUtil::emptyDate($this->event->booking_close_date) xor $this->event->booking_open_date <= $this->event->booking_close_date)) {?>
            <tr>
                <td>
                    <div class="event-date">
                        <strong><?php echo JText::_('LNG_BOOKING_DATES') ?></strong><br/>
                        <i class="icon calendar"></i>
                        <?php echo $this->event->dates ?>
                        <?php echo (empty($this->event->dates) || (empty($this->event->booking_open_time) && empty($this->event->booking_close_time)))?"":"," ?>
                        <?php echo JBusinessUtil::convertTimeToFormat($this->event->booking_open_time)." ".(!empty($this->event->booking_close_time)?JText::_("LNG_UNTIL"):"")." ".(JBusinessUtil::convertTimeToFormat($this->event->booking_close_time)); ?>
                        <?php if($this->defaultAttributes["time_zone"] !=ATTRIBUTE_NOT_SHOW){?>
                            <?php echo JText::_('LNG_GMT')." ".$this->event->time_zone ?>
                        <?php } ?>
                    </div>
                </td>
            </tr>
        <?php } ?>
    <?php } ?>

    <?php if(JBusinessUtil::isBookingAvailable($this->event)) {?>
        <div>
            <form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&task=event.reserveTickets&eventId='.$this->event->id.$menuItemId.'&'.JSession::getFormToken().'=1');?>" method="post" name="ticketForm" id="ticketForm">
                <input type="hidden" name="eventId" value="<?php echo $this->event->id ?>" />

                <table class="dir-panel-table responsive-simple" style="border-collapse: unset;">
                    <thead>
                    <tr>
                        <th align="center"><?php echo JText::_('LNG_TICKETS'); ?></th>
                        <th width="10%"><?php echo JText::_('LNG_PRICE'); ?></th>
                        <th width="1%"><?php echo JText::_('LNG_QUANTITY'); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    $nrcrt = 1;
                    $isFree = true;
                    ?>
                    
                    <?php foreach($this->eventTickets as $ticket) { ?>
                        <?php
                        if($ticket->price!=0)
                            $isFree = false;
                        ?>
                        <tr class="jtable-body-row row<?php echo $nrcrt%2 ?>">
                            <td align="left" data-title="<?php echo JText::_('LNG_TICKET'); ?>" class="has-title">
                                <?php echo $this->escape($ticket->name); ?>
                            </td>
                            <td align="center" data-title="<?php echo JText::_('LNG_PRICE'); ?>"  class="has-title">
                                <span><?php echo JBusinessUtil::getPriceFormat($ticket->price, $this->event->currency_id) ?></span>
                            </td>
                          
                            <td align="left"  data-title="<?php echo JText::_('LNG_QUANTITY'); ?>"  class="has-title">
                            	<input type="hidden" name="ticket_id[]" id="ticket_id-<?php echo $ticket->ticket_id?>" value="<?php echo $ticket->id ?>" />
                                <select name="ticket_quantity[]" id="ticket_quantity[]" style="width:70px;" >
                                    <?php
                                    if($ticket->min_booking > 0){
                                    	echo '<option value="0">0</option>';
                                    }
                                    
                                    for($i=$ticket->min_booking;$i<=$ticket->max_booking;$i++)
                                        echo '<option value="' . $i . '">' . $i . '</option>';
                                    ?>
                                </select>
                            </td>
                        </tr>
                    <?php } ?>
                    </tbody>
                    <tfoot>
                    <tr>
                        <td colspan="10"><div class="text-right">
                        	<button type="submit" class="btn btn-success" onclick="this.form.submit()">
                            	<i class="la la-plus-sign"></i><?php echo $isFree?JText::_('LNG_RESERVE_SEAT'):JText::_('LNG_MAKE_BOOKING'); ?></span>
                            </button>
                        </td>
                    </tr>
                    </tfoot>
                </table>
            </form>
        </div>
    <?php } ?>
<?php } ?>

