<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');

$session = JFactory::getSession();
$menuItem = "&Itemid=".$session->get("eventsMenuItemId");

require_once 'header.php';
require_once BD_CLASSES_PATH.'/attributes/attributeservice.php';
$referer= isset($_SERVER['HTTP_REFERER'])?$_SERVER['HTTP_REFERER']:"";
?>

<div id="jbd-container" class="jbd-container">
	<div id="event-container" class="event-container" itemscope itemtype="http://schema.org/Event">
    	<div class="row align-items-center mb-3">
            <div class="col-8">
                <?php if(!empty($referer) && false){ ?>
                    <a href="<?php echo $referer ?>"><?php echo JText::_("BACK") ?></a>
                <?php }else{ ?>
          			<a href="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=events&reload=1'.$menuItem); ?>"><?php echo JText::_("BACK_TO_EVENTS") ?></a>
		    	<?php } ?>
                <h1 itemprop="name"><?php echo $this->escape($this->event->name)?></h1>
                <div>
                    <?php require_once JPATH_COMPONENT_SITE."/include/social_share.php" ?>
                    <a class="print-icon" rel="nofollow" href="javascript:jbdUtils.printItem('<?php echo JRoute::_("index.php?option=com_jbusinessdirectory&view=event&tmpl=component&action=print&eventId=".$this->event->id); ?>')"><i class="icon print-circle"></i></a>
                    <a class="" href="<?php echo JRoute::_("index.php?option=com_jbusinessdirectory&task=event.exportEventsDetailsICS&eventId=". $this->event->id. '&'.JSession::getFormToken().'=1'); ?>"><i class="icon download-circle"></i> </a>
                    <a class="" target="_blank" href="<?php echo JRoute::_("http://www.google.com/calendar/render?action=TEMPLATE&text=". $this->event->name .
                    "&location=". $this->event->address .
                    "&details=". strip_tags($this->event->description) .
                    "&dates=" . date('Ymd',strtotime($this->event->start_date)) . "T" . date('His',strtotime($this->event->start_time)) . "/". date('Ymd',strtotime($this->event->end_date)) . "T" . date('His',strtotime($this->event->end_time))) ?>">
                    <i class="icon add-to-calendar-circle"></i></a>
                </div>
        		<span style="display:none;" itemprop="url"><?php echo JBusinessUtil::getEventLink($this->event->id, $this->event->alias); ?></span>
            </div>
    		<div class="col-4 text-center">
                <div class="event-main-info">
                    <div class="event-date">
                        <p><?php echo JBusinessUtil::getWeekDay($this->event->start_date)?></p>  
                        <p><?php echo JBusinessUtil::getMonth($this->event->start_date) ?> <?php echo  JBusinessUtil::getDayOfMonth($this->event->start_date) ?></p>
                    </div>
                    <?php if(!empty($this->event->price) && $this->defaultAttributes["price"] !=ATTRIBUTE_NOT_SHOW){?>
                        <div class="event-date">
                            <p><?php echo JBusinessUtil::getHtmlPriceFormat($this->event->price, $this->event->currency_id) ?></p>
                            <p><?php echo JText::_("LNG_PRICE")?></p> 
              	     	</div>
               	    <?php } ?>	

                    <span style="display:none;" itemprop="startDate"><?php echo JBusinessUtil::getDateISOFormat($this->event->start_date) ?></span>
                    <span style="display:none;" itemprop="endDate"><?php echo JBusinessUtil::getDateISOFormat($this->event->end_date) ?></span>
                    <span style="display:none;" itemprop="image" itemscope itemtype="http://schema.org/ImageObject">
                    <?php if(!empty($picturePath)){?>
                        <img  alt="<?php echo $this->escape($this->event->name) ?>" src="<?php echo BD_PICTURES_PATH.$picturePath?>" itemprop="contentUrl">
                        <span style="display:none;" itemprop="url"><?php echo BD_PICTURES_PATH.$picturePath ?></span>
                    <?php }else{?>
                        <img title="<?php echo $this->escape($this->event->name)?>" alt="<?php echo $this->event->name?>" src="<?php echo BD_PICTURES_PATH.'/no_image.jpg' ?>" itemprop="contentUrl">
                        <span style="display:none;" itemprop="url"><?php echo BD_PICTURES_PATH.'/no_image.jpg' ?></span>
                    <?php } ?>
                    </span>
                </div>
    	     </div>
    	</div>
    	<div class="row item-section">
            <div class="col-lg-8">
                <?php if(!empty($this->event->pictures)){?>
                    <div class="row">
                        <div class="col-12">
                            <?php
                                $this->pictures = $this->event->pictures;
                                require_once JPATH_COMPONENT_SITE.'/include/image_slick_gallery_simple.php';
                            ?>
                        </div>
                    </div>
                <?php } ?>
               
                <div class="row item-section">
                    <div class="col-12">
                        <div itemprop="description">
                            <?php echo JHTML::_("content.prepare", $this->event->description); ?>
                        </div>
                    </div>
                </div>

                <?php if(!empty($this->event->categories)){?>
                    <div class="row item-section">
                        <div class="col-12">
                            <div><strong><?php echo JText::_('LNG_CATEGORIES')?></strong></div>
                            <ul class="horizontal-list">
                                <?php if(!empty($this->event->categories)){
                                    foreach($this->event->categories as $i=>$category){
                                        ?>
                                        <li><a href="<?php echo JBusinessUtil::getEventCategoryLink($category[0], $category[2]) ?>"><?php echo $this->escape($category[1]) ?></a><?php echo $i<(count($this->event->categories)-1)? ',&nbsp;':'' ?></li>
                                        <?php
                                    }
                                } ?>
                            </ul>
                        </div>
                    </div>
                <?php } ?>
                
                <?php if($this->appSettings->enable_attachments) { ?>
                    <?php if(!empty($this->event->attachments)) { ?>
                        <div class="row item-section">
                            <div class="col-12">
                                <div><strong><?php echo JText::_("LNG_ATTACHMENTS")?></strong></div>
                                    <?php require "event_attachments.php"?>
                                </div>
                            </div>
                    <?php } ?>
                <?php } ?> 
                
                <?php if(!empty($this->eventTickets) && $this->appSettings->enable_event_reservation) { ?>
                    <div class="row item-section">
                        <div class="col-12">
                            <!-- Event Booking Section -->
                            <?php require_once 'event_tickets.php'; ?>
                        </div>
                    </div>
                <?php } ?>
                    
                <?php if(!empty($this->eventAttributes)) { ?>
                    <div class="row item-section">
                        <div class="col-12">
                            <div class="classification">
                                <?php require_once 'event_attributes.php'; ?>
                            </div>
                        </div>
                    </div>
                <?php } ?>
                
                <?php if(!empty($this->videos)){ ?>
                    <div class="row item-section">
                        <div class="col-12">
                            <h4><?php echo JText::_("LNG_EVENT_VIDEOS")?></h4>
                            <?php require_once 'event_videos.php';?>
                        </div>
                    </div>
                <?php } ?>
                
                <?php if(!empty($this->associatedCompanies)){ ?>
                    <div class="row item-section">
                        <div class="col-12">
                            <h4><?php echo JText::_("LNG_ASSOCIATED_COMPANIES")?></h4>
                            <?php require_once 'event_associated_companies.php';?>
                        </div>
                    </div>
                <?php } ?>

				<?php
					jimport('joomla.application.module.helper');
					// this is where you want to load your module position
					$modules = JModuleHelper::getModules('event-details');
				?>
                <?php if (isset($modules) && count($modules) > 0) { ?>
                    <div class="event-modules">
                        <?php
                        foreach ($modules as $module) {
                            echo JModuleHelper::renderModule($module, array("style"=>"xhtml"));
                        } ?>
                    </div>
                <?php } ?>
            </div>
            <div class="col-lg-4">
            	<div class="event-content-box">
                    <div class="box-title"><?php echo JText::_("LNG_EVENT_DETAILS") ?></div>
                    <?php if ($this->event->start_date != '0000-00-00'){ ?>
    					<div><i class="icon calendar"></i> <?php $dates = JBusinessUtil::getDateGeneralShortFormat($this->event->start_date).(!empty($this->event->start_date) && $this->event->start_date!=$this->event->end_date && $this->event->show_end_date?" - ".JBusinessUtil::getDateGeneralShortFormat($this->event->end_date):""); echo $dates; ?></div>
    					<?php if ($this->event->show_start_time || $this->event->show_end_time){ ?>
    					<div><i class="icon clock"></i> <?php echo ($this->event->show_start_time?JBusinessUtil::convertTimeToFormat($this->event->start_time):"")." ".(!empty($this->event->end_time)&&$this->event->show_end_time?JText::_("LNG_TO"):"")." ".($this->event->show_end_time?JBusinessUtil::convertTimeToFormat($this->event->end_time):""); ?>
                            <?php if($this->defaultAttributes["time_zone"] !=ATTRIBUTE_NOT_SHOW){?>
                                <?php echo ($this->event->show_start_time || $this->event->show_end_time)?JText::_('LNG_GMT')." ".$this->event->time_zone:""; ?> 
        				    <?php }?>
                        </div>        						
        				<?php }?>
        	        <?php } ?>
                    
                	<?php if(!empty($this->event->contact_phone) || !empty($this->event->contact_email) || !empty($this->event->company->email)) { ?>
                        <?php if(!empty($this->event->contact_phone)) { ?><i class="icon phone-o"></i>&nbsp;<a href="tel:<?php echo $this->event->contact_phone ?>"><?php echo $this->event->contact_phone ?></a><br/> <?php } ?>
                        <?php if((!empty($this->event->contact_email) || (!empty($this->event->company) && !empty($this->event->company->email))) && $this->appSettings->show_contact_form) { ?>
                            <a itemprop="email" href="javascript:jbdListings.showContactCompany(<?php echo $showData?1:0 ?>)" ><i class="icon envelope"></i> <?php echo JText::_('LNG_CONTACT'); ?></a>
                        <?php } ?>
                    <?php } ?>
                	<div class="event-info">
                        <?php if(!empty($this->event->doors_open_time) && $this->event->show_doors_open_time) { ?>
                            <div class="event-info-item">
                                <div class="light"><?php echo JText::_('LNG_EVENT_DOORS_OPEN') ?></div>
                                <div>
                                   <span itemprop="doorTime"><?php echo JBusinessUtil::convertTimeToFormat($this->event->doors_open_time) ?></span>
                                </div>
                            </div>
                        <?php } ?>
                        <?php if(!empty($this->event->eventType) && $this->defaultAttributes["type"] !=ATTRIBUTE_NOT_SHOW){?>
                            <div class="event-info-item">
                                <div class="light"><?php echo JText::_("LNG_TYPE")?></div> 
                                <div><?php echo $this->escape($this->event->eventType)?></div>
                            </div>
                        <?php } ?>
                        <?php if(!empty($this->event->min_age) && $this->defaultAttributes["age"] !=ATTRIBUTE_NOT_SHOW){?>
                            <div class="event-info-item">
                                <div class="light"><?php echo JText::_("LNG_AGE")?></div>
                                <div><?php echo $this->event->min_age." - ".$this->event->max_age." ".JText::_("LNG_YEARS") ?></div>
                            </div>
                        <?php } ?>
                	
            		
                        <?php if(!empty($this->event->attendance_mode) && $this->defaultAttributes["attendance"] !=ATTRIBUTE_NOT_SHOW){?>
                            <div class="event-info-item" itemscope itemtype="http://schema.org/EventAttendanceModeEnumeration">
                                <div class="light"><?php echo JText::_('LNG_MODE') ?></div>
                                <div>
                                    <span><?php echo JBusinessUtil::getAttendanceModeText($this->event->attendance_mode)?></span>
                                </div>
                                
                                <?php if ($this->event->attendance_mode == 1) { ?>
                                    <span style="display:none" itemprop="eventAttendanceMode">OfflineEventAttendanceMode</span>
                                <?php } else if ($this->event->attendance_mode == 2) { ?>
                                    <span style="display:none" itemprop="eventAttendanceMode">OnlineEventAttendanceMode</span>
                                <?php } else  if ($this->event->attendance_mode == 3) { ?>
                                    <span style="display:none" itemprop="eventAttendanceMode">MixedEventAttendanceMode</span>
                                <?php } ?>
                            </div>
                        <?php } ?>

                        <?php if(!empty($this->event->attendance_url) && $this->event->attendance_mode!=1){?>
                            <div class="event-info-item">
                                <a target="_blank" href="<?php echo $this->event->attendance_url ?>"><?php echo JText::_("LNG_CLICK_TO_JOIN") ?></a>
                            </div>
                        <?php } ?>

                        <?php if($this->appSettings->enable_event_subscription && $this->event->enable_subscription) { ?>
                            <div class="row">
                                <div class="col-md">
                                    <button class="btn btn-success" onclick="jbdEvents.joinEvent(<?php echo ($user->id == 0)?0:1 ?>)">
                                        <?php if(empty($this->userAssociatedCompanies)) {
                                            echo JText::_('LNG_JOIN');
                                        }else{
                                            echo JText::_('LNG_LEAVE_EVENT');
                                        }?>
                                    </button>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>

                <div class="event-content-box">
                    <div class="row item-section">
                        <div class="col-12">
                            <?php if(!empty($this->event->latitude) && !empty($this->event->longitude)){ ?>
                                <div id="event-map">
                                    <?php require_once 'map.php';?>
                                </div>
                            <?php } ?>
                            <?php $address = JBusinessUtil::getAddressText($this->event); ?>
                            <?php if(!empty($address)) { ?>
                                <div class="event-location" itemprop="location" itemscope itemtype="http://schema.org/Place">
                                    <i class="icon map-marker"></i>&nbsp;<span itemprop="name"><?php echo $this->escape($address) ?></span>
                                    <span style="display:none" itemprop="address"><?php echo JBusinessUtil::getAddressText($this->event)?></span>
                                    <?php if(!empty($this->event->latitude) && !empty($this->event->longitude)) {
                                        $location = new stdClass;
                                        $location->latitude = $this->event->latitude;
                                        $location->longitude = $this->event->longitude;
                                    ?>
                                        - <a target="_blank" href="<?php echo JBusinessUtil::getDirectionURL(null,$location) ?>"><?php echo JText::_("LNG_GET_MAP_DIRECTIONS")?></a>
                                    <?php }?>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>

                <div class="event-content-box">
                    <div class="box-title"><?php echo JText::_("LNG_ORGANIZER") ?></div>
                    <?php if(!empty($this->event->company)){?>
                        <div class="organizer-details" itemprop="organizer" itemscope itemtype="http://schema.org/Organization">
                            <a itemprop="url" <?php echo $this->newTab; ?> href="<?php echo JBusinessUtil::getCompanyLink($this->event->company)?>"><span itemprop="name"><?php echo $this->escape($this->event->company->name)?></span></a>
                            </div>
                            <?php if(!empty($this->event->company->website)){?>
                                <a target="_blank" itemprop="url" title="<?php echo $this->escape($this->event->company->name)?> Website" onclick="jbdUtils.registerStatAction(<?php echo $this->event->company->id ?>,<?php echo STATISTIC_ITEM_BUSINESS ?>,<?php echo STATISTIC_TYPE_WEBSITE_CLICK ?>)" href="<?php echo $this->escape($this->event->company->website) ?>"><i class="icon link-square "></i>  <?php echo JText::_('LNG_WEBSITE')?></a></a>
                            <?php } ?>
                        </div>
                    <?php } ?>
                </div>
           	</div>
        </div>
    </div>
</div>
          
<?php require_once 'event_util.php'; ?>