<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');
?>

<?php
if(isset($this->products) && count($this->products)) { ?>
    <div id="grid-content" class='product-list'>
        <?php $i = 0; ?>
        <span id="product-category"><h1><?php echo $this->category->name ?></h1></span>
        <?php foreach ($this->products as $product) { ?>
        <?php if($i%3==0) { ?>
            <div class="row-fluid">
        <?php } ?>
            <div id="post-<?php echo $product->id ?>" class="col-md-4">
                <div>
                    <figure class="post-image">
                        <a href="javascript:void(0)" onclick="jbdListings.showProductDetails(<?php echo $product->id.', '.$this->category->id ?>, '<?php echo $product->companyId ?>', '<?php echo $product->alias ?>', '<?php echo $product->subject ?>')">
                            <?php if(!empty($product->picture_path) ){?>
                                <img title="<?php echo $product->subject ?>" alt="<?php echo $product->subject ?>" src="<?php echo BD_PICTURES_PATH.$product->picture_path ?>">
                            <?php }else{ ?>
                                <img title="<?php echo $product->subject ?>" alt="<?php echo $product->subject ?>" src="<?php echo BD_PICTURES_PATH.'/no_image.jpg' ?>">
                            <?php } ?>
                        </a>
                    </figure>

                    <div class="post-content" style="text-align:center;">
                        <a style="color:black;" href="javascript:void(0)" onclick="jbdListings.showProductDetails(<?php echo $product->id.', '.$this->category->id ?>, '<?php echo $product->companyId ?>', '<?php echo $product->alias ?>', '<?php echo $product->subject ?>')">
                            <h2 class="post-title">
                                <span><?php echo $product->subject ?></span>
                            </h2>
                            <p class="offer-dates">
                                <?php
                                echo JBusinessUtil::truncate($product->short_description, 100);
                                ?>
                            </p>
                        </a>
                    </div>
                </div>
            </div>
            <?php
            $i++;
            if($i%3==0) { ?>
                </div>
            <?php } ?>
            <?php } ?>
            <?php if($i%3!=0) { ?>
                </div>
            <?php } ?>
        </div>
        <?php
    } else{ ?>
    <div id="grid-content" class='product-list'>
        <?php echo JText::_("LNG_NO_PRODUCTS");?>
    </div>
<?php
    }
?>
<div class="clear"></div>