<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');

JTable::addIncludePath(DS.'components'.DS.'com_jbusinessdirectory'.DS.'tables');
require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'models'.DS.'companypricelist.php');

class JBusinessDirectoryModelManageCompanyPriceList extends JBusinessDirectoryModelCompanyPriceList {
	
	/**
	 * Method to test whether a record can be deleted.
	 *
	 * @param   object	A record object.
	 *
	 * @return  boolean  True if allowed to delete the record. Defaults to the permission set in the component.
	 */
	protected function canDelete($record) {
		return true;
	}
	
	/**
	 * Method to test whether a record can be deleted.
	 *
	 * @param   object	A record object.
	 *
	 * @return  boolean  True if allowed to change the state of the record. Defaults to the permission set in the component.
	 */
	protected function canEditState($record) {
		return true;
	}
	
	/**
	 * Method to test whether a record can be deleted.
	 *
	 * @param   object	A record object.
	 *
	 * @return  boolean  True if allowed to change the state of the record. Defaults to the permission set in the component.
	 */
	protected function canEdit($record) {
		return true;
	}
	/**
	 * Returns a Table object, always creating it
	 *
	 * @param   type	The table type to instantiate
	 * @param   string	A prefix for the table class name. Optional.
	 * @param   array  Configuration array for model. Optional.
	 * @return  JTable	A database object
	 */
	public function getTable($type = 'CompanyServicesList', $prefix = 'JTable', $config = array()) {
		return JTable::getInstance($type, $prefix, $config);
	}

	public function save($data) {
		$id	= (!empty($data['id'])) ? $data['id'] : (int) $this->getState('managecompanypricelist.id');

		$companyId = $data['companyId'];
		$serviceName = isset($data["service_name"])?$data["service_name"]:array();
		$serviceSection = isset($data["service_section"])?$data["service_section"]:array();
		$serviceDesc = isset($data["service_description"])?$data["service_description"]:array();
		$servicePrice = isset($data["service_price"])?$data["service_price"]:array();
		$serviceImage = isset($data["service_image"])?$data["service_image"]:array();
		$servicesId = isset($data["service_id"])?$data["service_id"]:array();

		if (!$this->deleteCompanyServices($servicesId, $id)) {
			return false;
		}

		if (!empty($servicesId)) {
			$usedImages = array();
			if (!empty($serviceImage)) {
				foreach ($serviceImage as $img) {
					array_push($usedImages, $img);
				}
			}

			$pictures_path = JBusinessUtil::makePathFile(BD_PICTURES_UPLOAD_PATH);
			$company_pictures_path = JBusinessUtil::makePathFile(PRICE_LIST_PICTURES_PATH.($companyId)."/");
			JBusinessUtil::removeUnusedFiles($usedImages, $pictures_path, $company_pictures_path);

			$companyServiceTable = $this->getTable();
			foreach ($servicesId as $key => $value) {
				if (!empty($serviceImage[$key])) {
					$serviceImage[$key] = JBusinessUtil::moveFile($serviceImage[$key], $companyId, $companyId, PRICE_LIST_PICTURES_PATH);
				}
				$companyServiceTable->id = 0;
				if (!empty($value)) {
					$companyServiceTable->id = $value;
				}
				$companyServiceTable->service_name = $serviceName[$key];
				$companyServiceTable->service_description = $serviceDesc[$key];
				$companyServiceTable->service_section = $serviceSection[$key];
				$companyServiceTable->service_price = JBusinessUtil::convertPriceToMysql($servicePrice[$key]);
				$companyServiceTable->service_image = $serviceImage[$key];
				$companyServiceTable->companyId = $companyId;

				if (!$companyServiceTable->store()) {
					$application = JFactory::getApplication();
					$application->enqueueMessage($this->_db->getError(), 'error');
					return false;
				}
			}
		}

		$this->setState('com_jbusinessdirectory.edit.managecompanypricelist.id', $companyId);

		// Clean the cache
		$this->cleanCache();

		return true;
	}
}
