<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');


JTable::addIncludePath(DS.'components'.'com_jbusinessdirectory'.DS.'tables');
require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'models'.DS.'offer.php');

class JBusinessDirectoryModelManageCompanyOffer extends JBusinessDirectoryModelOffer {
	public function __construct() {
		parent::__construct();

		$app = JFactory::getApplication('administrator');

		if (!($type = $app->getUserState('com_jbusinessdirectory.offers.filter.type'))) {
			$type = JFactory::getApplication()->input->getInt('item_type');
			if (empty($type)) {
				$type =JFactory::getApplication()->input->getInt('filter_type', OFFER_TYPE_OFFER);
			}
			$app->setUserState('com_jbusinessdirectory.offers.filter.type', $type);
		}
		$this->setState('filter.type', $type);
	}

	/**
	 * Method to test whether a record can be deleted.
	 *
	 * @param   object	A record object.
	 *
	 * @return  boolean  True if allowed to delete the record. Defaults to the permission set in the component.
	 */
	protected function canDelete($record) {
		return true;
	}
	
	/**
	 * Method to test whether a record can be deleted.
	 *
	 * @param   object	A record object.
	 *
	 * @return  boolean  True if allowed to change the state of the record. Defaults to the permission set in the component.
	 */
	protected function canEditState($record) {
		return true;
	}
	
	/**
	 * Method to test whether a record can be deleted.
	 *
	 * @param   object	A record object.
	 *
	 * @return  boolean  True if allowed to change the state of the record. Defaults to the permission set in the component.
	 */
	protected function canEdit($record) {
		return true;
	}

}
