<?php

/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');
require_once BD_CLASSES_PATH . '/attributes/attributeservice.php';

$appSettings = JBusinessUtil::getApplicationSettings();
$enableSEO = $appSettings->enable_seo;
$enablePackages = $appSettings->enable_packages;
$enableRatings = $appSettings->enable_ratings;
$enableNumbering = $appSettings->enable_numbering;
$user = JBusinessUtil::getUser();

$limitStart = JFactory::getApplication()->input->get('limitstart');
if (empty($limitStart)) {
	$limitStart = 0;
}

if(!$appSettings->lazy_loading) {
    $total_page_string = $this->pagination->getPagesCounter();
    $current_page = substr($total_page_string, 5, 1);
    if (($current_page === 1) || $total_page_string==null) {
        $limitStart = 0;
    }
}
$showData = !($user->id == 0 && $appSettings->show_details_user == 1);
?>

<div id="jbd-results-container" itemscope itemtype="http://schema.org/ItemList" class="list-style-4" <?php echo $appSettings->search_view_mode?'style="display: none"':'' ?>>
    <?php
    if (!empty($this->companies)) {
        $itemCount = 1;
        foreach ($this->companies as $index => $company) {
    ?>
            <?php
            if (!empty($searchModules) && isset($searchModules[$index])) {
                foreach ($searchModules[$index] as $module) {
            ?>
                    <div class="search-result-module">
                        <?php echo JModuleHelper::renderModule($module, array("style"=>"xhtml")); ?>
                    </div>
                <?php } ?>
            <?php } ?>
            <div class="result-item <?php echo isset($company->featured) && $company->featured == 1 ? "featured" : "" ?>" style="<?php echo !empty($company->featured) && !empty($appSettings->listing_featured_bg) ? "background-color: $appSettings->listing_featured_bg" : "" ?>">
                <div itemscope itemprop="itemListElement" itemtype="http://schema.org/ListItem">
                    <span style="display:none;" itemprop="position"><?php echo $itemCount ?></span>
                    <div itemscope itemprop="item" itemtype="http://schema.org/Organization">
                        <div class="row">
                            <?php if ($this->defaultAttributes["logo"] != ATTRIBUTE_NOT_SHOW && (isset($company->packageFeatures) && in_array(SHOW_COMPANY_LOGO, $company->packageFeatures) || !$enablePackages)) { ?>
                                <div class="col-lg-3">
                                    <div class="item-image" itemprop="logo" itemscope itemtype="http://schema.org/ImageObject">
                                        <a <?php echo $newTab; ?> href="<?php echo JBusinessUtil::getCompanyLink($company) ?>">
                                            <?php if (!empty($company->logoLocation)) { ?>
                                                <img title="<?php echo $this->escape($company->name) ?>" alt="<?php echo $this->escape($company->name) ?>" src="<?php echo BD_PICTURES_PATH . $company->logoLocation ?>" itemprop="contentUrl" />
                                                <?php if (isset($company->featured) && $company->featured == 1) { ?>
                                                    <div class="featured-text">
                                                        <?php echo JText::_("LNG_FEATURED") ?>
                                                    </div>
                                                <?php } ?>

                                            <?php } else { ?>
                                                <img title="<?php echo $this->escape($company->name) ?>" alt="<?php echo $this->escape($company->name) ?>" src="<?php echo BD_PICTURES_PATH . '/no_image.jpg' ?>" itemprop="contentUrl" />
                                            <?php } ?>
                                        </a>
                                    </div>
                                </div>
                            <?php } ?>
                            <div class="col-lg">
                                <div class="result-content">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <h3 class="item-name">
                                                <a <?php echo $newTab; ?> href="<?php echo JBusinessUtil::getCompanyLink($company) ?>"><?php echo $enableNumbering ? "<span>" . ($index + $limitStart + 1) . ". </span>" : "" ?><span itemprop="name"><?php echo $company->name ?> </span></a>
                                                <?php if (!empty($company->recommended) && $appSettings->show_recommended) { ?>
                                                    <div class="recommended" title="<?php echo JText::_("LNG_RECOMMENDED") ?>"><i class="la la-check"></i> </div>
                                                <?php } ?>
                                            </h3>
                                            <span style="display:none;" itemprop="url"><?php echo JBusinessUtil::getCompanyLink($company) ?></span>
                                            <span style="display:none;" itemprop="position"><?php echo $itemCount ?></span>

                                            <div class="company-rating" <?php echo !$enableRatings ? 'style="display:none"' : '' ?>>
                                                <?php if ($appSettings->enable_ratings) { ?>
                                                    <div class="rating">
                                                        <p class="rating-average" title="<?php echo $company->review_score ?>" id="<?php echo $company->id ?>" style="display: block;"></p>
                                                    </div>
                                                    <div class="review-count">
                                                        <a <?php echo $company->review_score == 0 ? 'style="display:none"' : '' ?>></a>
                                                    </div>
                                                <?php } ?>
                                            </div>

                                            <?php
                                            $address = JBusinessUtil::getAddressText($company);
                                            if (!empty($company->bestMatchLocation)) {
                                                $address = $company->bestMatchLocation;
                                                $address .= " <a href=\"" . JBusinessUtil::getCompanyLink($company) . "\"> (" . JText::_("LNG_VIEW_ALL_LOCATIONS") . ")</a>";
                                            } ?>
                                            <?php if (!empty($address)) { ?>
                                                <div class="item-element company-address">
                                                    <span itemprop="address"><?php echo JBusinessUtil::getAddressText($company) ?></span>
                                                </div>
                                            <?php } ?>
                                        </div>
                                        <div class="col-md-6">
                                            <?php if ($showData && (isset($company->packageFeatures) && in_array(PHONE, $company->packageFeatures) || !$enablePackages)) { ?>
                                                <?php if (!empty($company->phone)) { ?>
                                                    <div class="item-element phone" itemprop="telephone">
                                                        <i class="icon phone-o"></i> <a href="tel:<?php echo $company->phone; ?>"><?php echo $company->phone; ?></a>
                                                    </div>
                                                <?php } ?>
                                            <?php } ?>
                                            <?php if (!empty($company->categories)) { ?>
                                                <div class="item-element">
                                                    <ul class="horizontal-list">
                                                        <?php foreach ($company->categories as $i => $category) { ?>
                                                            <li><a href="<?php echo JBusinessUtil::getCategoryLink($category[0], $category[2]) ?>"><?php echo $this->escape($category[1]) ?></a><?php echo $i < (count($company->categories) - 1) ? ',&nbsp;' : '' ?></li>
                                                        <?php } ?>
                                                    </ul>
                                                </div>
                                            <?php } ?>

                                            <div class="item-element">
                                                <ul class="horizontal-list">
                                                    <?php if ($showData && !empty($company->website) && (isset($company->packageFeatures) && in_array(WEBSITE_ADDRESS, $company->packageFeatures) || !$enablePackages)) {
                                                        if ($appSettings->enable_link_following) {
                                                            $followLink = (isset($company->packageFeatures) && in_array(LINK_FOLLOW, $company->packageFeatures) && $enablePackages) ? 'rel="follow noopener"' : 'rel="nofollow noopener"';
                                                        } else {
                                                            $followLink = 'rel="noopener"';
                                                        } ?>
                                                        <li><a target="_blank" <?php echo $followLink ?> title="<?php echo $this->escape($company->name) ?> Website" onclick="jbdUtils.registerStatAction(<?php echo $company->id ?>,<?php echo STATISTIC_ITEM_BUSINESS ?>,<?php echo STATISTIC_TYPE_WEBSITE_CLICK ?>)" href="<?php echo $this->escape($company->website) ?>"><?php echo JText::_('LNG_WEBSITE') ?></a></li>
                                                    <?php
                                                    } ?>
                                                    <?php if ($showData && !empty($company->latitude) && !empty($company->longitude) && (isset($company->packageFeatures) && in_array(GOOGLE_MAP, $company->packageFeatures) || !$enablePackages)) { ?>
                                                        <li><a target="_blank" href="<?php echo JBusinessUtil::getDirectionURL($this->location, $company) ?>"><?php echo JText::_("LNG_GET_MAP_DIRECTIONS") ?></a></li>
                                                    <?php } ?>
                                                    <li><a <?php echo $newTab; ?> href="<?php echo JBusinessUtil::getCompanyLink($company) ?>"> <?php echo JText::_('LNG_MORE_INFO') ?></a></li>
                                                    <?php if ($appSettings->show_contact_cards) { ?>
                                                        <li><a rel="nofollow" href="<?php echo JRoute::_("index.php?option=com_jbusinessdirectory&task=companies.generateQrCode&itemId=" . $company->id); ?>"><?php echo JText::_("LNG_QR_CODE") ?></a></li>
                                                        <li><a rel="nofollow" href="<?php echo JRoute::_("index.php?option=com_jbusinessdirectory&task=companies.generateVCard&itemId=" . $company->id); ?>"><?php echo JText::_("LNG_VCARD") ?></a></li>
                                                    <?php } ?>
                                                </ul>
                                            </div>


                                            <?php if (!empty($company->distance)) { ?>
                                                <div class="item-element">
                                                    <?php echo JText::_("LNG_DISTANCE") . ": " . round($company->distance, 1) . " " . ($appSettings->metric == 1 ? JText::_("LNG_MILES") : JText::_("LNG_KM")) ?>
                                                </div>
                                            <?php } ?>

                                            <?php if (!empty($company->typeName)) { ?>
                                                <div class="item-element"><?php echo $company->typeName ?></div>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <span style="display:none;" itemprop="position"><?php echo $itemCount ?></span>
            </div>
            <?php $itemCount++; ?>
        <?php
        } ?>
    <?php
    } ?>
</div>