<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');

$appSettings = JBusinessUtil::getApplicationSettings();
$enableNumbering = $appSettings->enable_numbering;
$user = JBusinessUtil::getUser();

$showData = !($user->id==0 && $appSettings->show_details_user == 1);
$showOnlyItems = false;

$grid_layout = JFactory::getApplication()->input->get('grid_layout');
if (!empty($grid_layout)) {
	$appSettings->search_result_grid_view = $grid_layout;
} ?>

<div id="jbd-grid-view" <?php echo !$appSettings->search_view_mode?'style="display: none"':'' ?>>
	<?php
	if ($appSettings->search_result_grid_view == 2) {
		require_once JPATH_COMPONENT_SITE.'/include/listings_grid_style_2.php';
	} else {
		require_once JPATH_COMPONENT_SITE.'/include/listings_grid_style_1.php';
	} ?>

	<input type="hidden" id="grid_layout" value=''>
</div>
<script>
window.addEventListener('load', function() {
	let grid_layout = '<?php echo !empty($grid_layout) ? $grid_layout : $appSettings->search_result_grid_view ?>'
	jQuery('#grid_layout').val(grid_layout)
})
</script>