<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');
?>
<!-- layout -->
<?php if (!$showOnlyItems) { ?>
<div class="jbd-grid-container list-grid-1">
	<div class="row">
    	<?php }
			if (isset($this->companies)) {
				$index = 0;
				foreach ($this->companies as $index => $company) {
					$index++; ?>
		<div class="col-lg-4 col-sm-6 col-12">
			<div class="jitem-card <?php echo isset($company->featured) && $company->featured == 1 ? "featured" : "" ?>">
				<div class="jitem-img-wrap">
					<a <?php echo $newTab; ?> href="<?php echo JBusinessUtil::getCompanyLink($company) ?>"> </a>
                    <?php if (!empty($company->logoLocation) &&
							(isset($company->packageFeatures) && in_array(SHOW_COMPANY_LOGO, $company->packageFeatures) || !$appSettings->enable_packages)) { ?>
                        <img title="<?php echo $this->escape($company->name) ?>"
                             alt="<?php echo $this->escape($company->name) ?>"
                             src="<?php echo BD_PICTURES_PATH . $company->logoLocation ?>">
                    <?php } else { ?>
                        <img title="<?php echo $this->escape($company->name) ?>"
                             alt="<?php echo $this->escape($company->name) ?>"
                             src="<?php echo BD_PICTURES_PATH . '/no_image.jpg' ?>">
                    <?php } ?>
                    <?php if (isset($company->featured) && $company->featured==1) { ?>
						<div class="featured-text">
	                        <?php echo JText::_("LNG_FEATURED")?>
                        </div>
		  	  		<?php } ?>
		  	  		
		  	  		<div class="card-hoverable">
                   		<a <?php echo $newTab; ?> href="<?php echo JBusinessUtil::getCompanyLink($company) ?>"
                               class="btn btn-outline-success btn-sm w-auto"><?php echo JText::_("LNG_VIEW") ?></a>
                    </div>
				</div>
				<div class="jitem-body">
    				<div class="jitem-body-content">
    					<div class="jitem-title">
    						<a <?php echo $newTab; ?> href="<?php echo JBusinessUtil::getCompanyLink($company) ?>"><span><?php echo $company->name ?></span></a>
    					</div>
    					<div class="jitem-desc">
    						<?php
								$address = JBusinessUtil::getShortAddress($company);
					if (!empty($company->bestMatchLocation)) {
						$address = $company->bestMatchLocation;
					} ?>
    						<?php if (!empty($address)) {?>
        						<div class="company-address">
        							<span><i class="icon map-marker"></i>&nbsp;<?php echo $address?></span>
        						</div>
        					<?php } ?>
    						<?php if (!empty($company->mainCategory)) { ?>
                            	<div class="post-category">
    								<?php if (!empty($company->mainCategoryIcon) || !empty($company->categoryIconImage)) { ?>
                						<?php echo JBusinessUtil::renderCategoryIcon($company->mainCategoryIcon, $company->categoryIconImage) ?>
                					<?php } ?>
    							<a href="<?php echo JBusinessUtil::getCategoryLink($company->mainCategoryId, $company->mainCategoryAlias) ?>"><?php echo $company->mainCategory ?> </a>
    							</div>
                        	<?php } ?>
                        	<?php if (($showData && (isset($company->packageFeatures) && in_array(SOCIAL_NETWORKS, $company->packageFeatures) || !$appSettings->enable_packages)
								&& ((isset($company->facebook) && strlen($company->facebook) > 3 || isset($company->twitter) && strlen($company->twitter) > 3)))) { ?>
                                <div id="social-networks-container">
            
                                    <ul class="social-networks">
                                        <li>
                                            <span class="social-networks-follow"><?php echo JText::_("LNG_FOLLOW_US") ?>
                                                : &nbsp;</span>
                                        </li>
                                        <?php if (isset($company->facebook) && strlen($company->facebook) > 3) { ?>
                                            <li>
                                                <a title="Follow us on Facebook" class="share-social facebook"
                                                   href="<?php echo $this->escape($company->facebook) ?>">Facebook</a>
                                            </li>
                                        <?php } ?>
                                        <?php if (isset($company->twitter) && strlen($company->twitter) > 3) { ?>
                                            <li>
                                                <a title="Follow us on Twitter" class="share-social twitter"
                                                   href="<?php echo $this->escape($company->twitter) ?>">Twitter</a>
                                            </li>
                                        <?php } ?>
                                    </ul>
                                </div>
                            <?php } ?>
    					</div>
    				</div>
				</div>
			</div>
		</div>

       <?php
				} ?>  
      <?php
			} ?>
<?php if (!$showOnlyItems) { ?>
	</div>
</div>
<?php } ?>