<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');

if (empty($span)) {
	$span = "col-lg-4 col-sm-6 col-12";
}
?>

<!-- BOXES VIEW -->
<div class="categories-container jbd-container categories-style-2">
	<div class="clear"></div>
	<div class="row">
	<?php $k = 0;?>
	<?php foreach ($categories as $category) {
	if (!is_array($category)) {
		$category = array($category);
		$category["subCategories"] = array();
	}
	if (isset($category[0]->name)) {
		$k= $k+1; ?>
		<div class="<?php echo $span?>">
    		<div class="category-content h-100">
    			<?php if (!empty($category[0]->imageLocation)) { ?>
    				<div class="category-img-container">
    					<a href="<?php echo $category[0]->link ?>">
    						<img alt="" src="<?php echo BD_PICTURES_PATH.$category[0]->imageLocation ?>">
    					</a>
    				</div>
    			<?php } ?>
				<div class="category-links">
					<strong>
						<a href="<?php echo $category[0]->link ?>"> <?php echo htmlspecialchars($category[0]->name, ENT_QUOTES) ?>
							<?php if ($appSettings->show_total_business_count) { ?>
								<span class="numberCircle"> <?php echo $category[0]->nr_listings ?></span>
							<?php } ?>
						</a>
					</strong><br/>
					<?php
						$i=1;
						foreach ($category["subCategories"] as $cat) {
							if ($i>20) {
								//break;
							}
							echo $i++==1?'':'|'; 
					?>
							<a class="categoryLink" title="<?php echo htmlspecialchars($cat[0]->name, ENT_QUOTES)?>" alt="<?php echo htmlspecialchars($cat[0]->name, ENT_QUOTES)?>"
								href="<?php echo $cat[0]->link ?>"
							>
								<?php echo htmlspecialchars($cat[0]->name, ENT_QUOTES)?>
							</a>
					<?php } ?>
    			</div>
    		</div>
		</div>
	<?php
	}
}
	?>
	</div>
</div>
<div class="clear"></div>
<?php if (!empty($params) && $params->get('showviewall')) {?>
    <div class="view-all-items">
        <a href="<?php echo $viewAllLink; ?>"><?php echo JText::_("LNG_VIEW_ALL")?></a>
    </div>
<?php }?>