<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMS Junkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');

class JBusinessDirectoryControllerVideo extends JControllerLegacy {

	/**
	 * constructor (registers additional tasks to methods)
	 * @return void
	 */
	public function __construct() {
		parent::__construct();
	}


	public function getMoreVideosAjax(){
		
		$view = $this->getView("Video","Html");

		$input = JFactory::getApplication()->input;
		$videoId = $input->getInt("videoId");
		$categoryId = $input->getInt("categoryId");
		$start = $input->getInt("start");

		$model = $this->getModel("Video");
		$videos = $model->loadRelatedVideos($videoId, $categoryId, $start, 7);

		$response = new stdClass();

		ob_start();
		$view = $this->getView("Video");
		$view->displayRelated($videos,"related");
		
		$response->videos =  ob_get_contents();
		ob_end_clean();
		$response->show_more = count($videos)==7;
		$response->videosCount = count($videos) > 6 ? 6 : count($videos);

		//dump( count($videos));
		//echo $response->videos;
		JBusinessUtil::sendJsonResponse($response, RESPONSE_STATUS_SUCCESS, '');

	}
}
