<?php
/**
 * @package    JBusinessDirectory
 *
 * @author     CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');

class JBusinessDirectoryControllerSearch extends JControllerLegacy {
	/**
	 * constructor (registers additional tasks to methods)
	 * @return void
	 */

	public function __construct() {
		JFactory::getApplication()->input->set("requestType", "name");
		parent::__construct();
	}

	public function showCompaniesFromCategory() {
		parent::display();
	}

	public function searchCompaniesByName() {
		parent::display();
	}

	public function searchCompaniesByPhone() {
		JFactory::getApplication()->input->set("requestType", "phone");
		parent::display();
	}

	public function getRegionsByCountryAjax() {
		$countryId = JFactory::getApplication()->input->getInt('countryId');
		$type      = JFactory::getApplication()->input->getInt('type', ITEM_TYPE_BUSINESS);
		$model     = $this->getModel('Search');
		$result    = $model->getRegionsByCountryAjax($countryId, $type);

		/* Send as JSON */
		header("Content-Type: application/json", true);
		echo json_encode($result);
		exit;
	}

	public function getCitiesByRegionAjax() {
		$region = JFactory::getApplication()->input->getString('region');
		$type   = JFactory::getApplication()->input->getInt('type', ITEM_TYPE_BUSINESS);
		$model  = $this->getModel('Search');
		$result = $model->getCitiesByRegionAjax($region, $type);

		/* Send as JSON */
		header("Content-Type: application/json", true);
		echo json_encode($result);
		exit;
	}

	public function getCitiesByCountryAjax() {
		$countryId = JFactory::getApplication()->input->getInt('countryId');
		$type      = JFactory::getApplication()->input->getInt('type', ITEM_TYPE_BUSINESS);
		$model     = $this->getModel('Search');
		$result    = $model->getCitiesByCountryAjax($countryId, $type);

		/* Send as JSON */
		header("Content-Type: application/json", true);
		echo json_encode($result);
		exit;
	}

	public function getSearchFilter() {
		$model = $this->getModel('Search');
		$session = JFactory::getSession();

		$location = $model->getLocation();
		$radius = $session->get('radius');
		$searchFilters = $model->getSearchFilter();
		$category = $model->getCategory();
		
		$selectedCategories = $model->getSelectedCategories();
		$selectedParams = $model->getSelectedParams();
		$searchKeyword = $session->get('searchkeyword');
		$customAttributesValues = $model->getCustomAttributeValues();
		$zipCode = $session->get('zipcode');

		$response = new stdClass();
		$response->location = $location;
		$response->radius = $radius;
		$response->category = $category;
		$response->selectedCategories = $selectedCategories;
		$response->searchFilter = $searchFilters;
		$response->selectedParams = $selectedParams;
		$response->searchKeyword = $searchKeyword;
        $response->customAttributesValues = $customAttributesValues;
        $response->zipCode = $zipCode;

		JBusinessUtil::sendJsonResponse($response, RESPONSE_STATUS_SUCCESS, '');
	}

	public function getMoreCompaniesAjax(){
		
		$appSettings = JBusinessUtil::getApplicationSettings();
		$view = $this->getView("Search","Html");

		$app = JFactory::getApplication();
		// Get pagination request variables
		$limit = $app->getUserStateFromRequest('global.list.limit', 'limit', $appSettings->dir_list_limit, 'int');

		$input = JFactory::getApplication()->input;
		$start = $input->getInt("start");

		$model = $this->getModel('Search');
		$companies = $model->getItems($start, $limit);

		$response = new stdClass();

		ob_start();
		$view->displayCompanies($companies);
		$response->companies =  ob_get_contents();
		ob_end_clean();

		ob_start();
		$view->displayCompanies($companies, true);
		$response->gridCompanies = ob_get_contents();
		ob_end_clean();

		$response->companiesCount = count($companies);
		$response->show_more = $response->companiesCount==$limit;
		JBusinessUtil::sendJsonResponse($response, RESPONSE_STATUS_SUCCESS, '');
	}
}