<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');


class JBusinessDirectoryControllerOffers extends JControllerLegacy {
	/**
	 * constructor (registers additional tasks to methods)
	 * @return void
	 */
	 
	public function __construct() {
		parent::__construct();
	}

	public function getSearchFilter() {
		$model = $this->getModel('Offers');
		$session = JFactory::getSession();

		$location = $model->getLocation();
		$radius = $session->get('of-radius');
		$searchFilters = $model->getSeachFilter();
		$category = $model->getCategory();
		$selectedCategories = $model->getSelectedCategories();
		$selectedParams = $model->getSelectedParams();
		$categoryId = $session->get('of-categorySearch');

		$response = new stdClass();
		$response->location = $location;
		$response->radius = $radius;
		$response->category = $category;
		$response->categoryId = $categoryId;
		$response->selectedCategories = $selectedCategories;
		$response->searchFilter = $searchFilters;
		$response->selectedParams = $selectedParams;

		JBusinessUtil::sendJsonResponse($response, RESPONSE_STATUS_SUCCESS, '');
	}
}
