<?php

/**
* A WebShop PHP kliens ltal hasznlt utility osztly
* a kliens oldali SOAP kommunkcihoz, PHP5 krnyezetben.
* 
* @version 4.0
*/

class SoapUtils {

    /**
    * @desc A banki fellethez illeszked SOAP kliens ltrehozsa.
    * A kliensen belltott socket_timeout 660 msodperc azrt,
    * hogy a hromszerepls fizetsekhez kapcsold kommunikcis szlak
    * se szakadjanak meg.
    * 
    * @param array $properties kapcsoldsi paramterek (javasolt
    * a otp_webshop_client.conf fjl teljes tartalma)
    * 
    * @return SoapClient A banki fellethez illeszked SOAP kliens.
    */
    function createSoapClient($properties) {
        $soapClientProps = array (   
            'location' => ConfigUtils::safeConfigParam($properties, PROPERTY_OTPMWSERVERURL),
            'uri' => 'java:hu.iqsoft.otp.mw.access',
            'trace' => true,
            'exceptions' => 1,
            'connection_timeout' => 10,
            'default_socket_timeout' => 660);
            
        if (ConfigUtils::safeConfigParam($properties, PROPERTY_HTTPSPROXYHOST)) {
            $soapClientProps['proxy_host'] = ConfigUtils::safeConfigParam($properties, PROPERTY_HTTPSPROXYHOST);
        }
        if (ConfigUtils::safeConfigParam($properties, PROPERTY_HTTPSPROXYPORT)) {
            $soapClientProps['proxy_port'] = ConfigUtils::safeConfigParam($properties, PROPERTY_HTTPSPROXYPORT);
        }
        if (ConfigUtils::safeConfigParam($properties, PROPERTY_HTTPSPROXYUSER)) {
            $soapClientProps['proxy_login'] = ConfigUtils::safeConfigParam($properties, PROPERTY_HTTPSPROXYUSER);
        }
        if (ConfigUtils::safeConfigParam($properties, PROPERTY_HTTPSPROXYPASSWORD)) {
            $soapClientProps['proxy_password'] = ConfigUtils::safeConfigParam($properties, PROPERTY_HTTPSPROXYPASSWORD);
        }

        return new SoapClient(NULL, $soapClientProps);      
    }

    /**
     * @desc A banki fellet Ping szolgltatsnak meghvsa. 
     * 
     * @param SoapClient $soapClient SOAP kliens
     * @param LoggerManager $logger log4php naplz
     * @return boolean true sikeres ping-ets esetn, egybknt false.
     */
    function ping($soapClient, $logger) {

        $result = false;
        try {
            $soapClient->__soapCall(
                "ping", array(), array('soapaction' => "urn:ping"));
            $result = true;
        }
        catch (Exception $e) {
            $logger->fatal("Hiba a banki felulet elereseben [ping]: " 
            . $e->getMessage()
            . "\n" . $e->getTraceAsString()
            . "\nSOAP valasz:\n" . $soapClient->__getLastResponse());
        }
                               
        return $result;
    }

    /**
     * Tranzakci indtsa. 
     * Ha a Bank tlterhels miatt elutastja a krst, automatikus
     * jraklds trtnik maximum RESENDCOUNT darabszmban, 
     * RESENDDELAY ezredmsodperces ksleltetssel.
     *
     * @param SoapClient $soapClient SOAP kliens
     * @param LoggerManager $logger log4php naplz
     *
     * @return boolean true sikeres ping-ets esetn, egybknt false.
     */
    function startWorkflowSynch($workflowName, $inputXml, $soapClient, $logger) {
        
        $workflowState = NULL;
        $retryCount = 0;
        $resendAllowed = true;

        /* A hromszerepls fizetsi tranzakci esetn
           a process futsi ideje a 10 percet is meghaladhatja
           (10 perc a fizetsi timeout, tovbbi pr msodperc
           a kommunikcis overhead)   */
        if ($workflowName == WF_HAROMSZEREPLOSFIZETES) {
            ini_set('max_execution_time','660');
        }
        
        do {
            try {
                $workflowState = $soapClient->__soapCall(
                    "startWorkflowSynch", 
                    array( 
                        new SoapParam(new SoapVar($workflowName, XSD_STRING), "arg0"), 
                        new SoapParam(new SoapVar($inputXml, XSD_STRING), "arg1")),
                    array('soapaction' => "urn:startWorkflowSynch"));
                
                $resendAllowed = false;
            }
            catch (SoapFault $sf) {
	            $logger->fatal("Hiba a banki fellet elrsben [" . $workflowName . "]: " 
                    . $sf->getMessage()
                    . "\n" . $sf->getTraceAsString()
                    . "\nSOAP valasz:\n" . $soapClient->__getLastResponse());
                $resendAllowed = false;
                if ($retryCount < RESENDCOUNT) {
                    if (stristr($sf->getMessage(), RESEND_ERRORPATTERN) !== false) {
                        // Pillanatnyi tlterhels miatti visszautasts a banki oldalon
                        $resendAllowed = true;
                        sleep(RESENDDELAY);
                    } 
                }
            }
            catch (Exception $e) {

	            $logger->fatal("Hiba a banki fellet elrsben [" . $workflowName . "]: " 
                    . $e->getMessage()
                    . "\n" . $e->getTraceAsString()
                    . "\nSOAP valasz:\n" . $soapClient->__getLastResponse());

                    $resendAllowed = false;
            }
            
        } while ($resendAllowed && $retryCount++ < RESENDCOUNT);
        
        return $workflowState;
    }

}

?>