<?php

/**
* @desc A ktszerepls fizetsi tranzakci illetve 
* a ktlpcss fizets lezrsa tranzakci vlaszadatait
* tartalmaz bean / value object.
* 
* @version 4.0
*/
class WebShopFizetesValasz {

    /**
    * @desc Shop azonost, mely megegyezik a inputban megadott rtkkel.
    * 
    * @var string
    */
    var $posId;
    
    /**
    * @desc Fizetsi tranzakci azonost, megegyezik az inputban megadott fizetsi tranzakci azonostval.
    * 
    * @var string
    */
    var $azonosito;

    /**
    * @desc A teljests idpecstje megadja a fizetsi tranzakci vgnek (lezrsnak) idpontjt. 
    * Sikeres s sikertelen vsrlsok esetn is kitltsre kerl.
    * 
    * @var string
    */
    var $teljesites;

    /**
    * @desc A vlaszkd a fizetsi tranzakci eredmnye. 
    * Sikeres vsrls esetn egy hromjegy numerikus kd a 000-010 rtktartomnybl. 
    * Sikertelen vsrls esetn, amennyiben a hiba (vagy elutasts) a terhels mvelete sorn trtnik 
    * (a krtyavezet rendszerben), szintn egy hromjegy numerikus kd jelenik meg, mely a 010 rtknl nagyobb. 
    * Egyb hiba (vagy elutasts) esetn a vlaszkd egy olyan alfanumerikus "olvashat" kd, 
    * mely a hiba (vagy elutasts) okt adja meg.
    * 
    * @var string
    */
    var $valaszKod;
    
    /**
    * @desc Authorizcis kd, a POS-os vsrlshoz tartoz authorizcis engedly szm. 
    * Csak sikereses vsrlsi tranzakcik esetn kerl kitltsre. 
    * Az adat a krtyavezet rendszer vlasza a  vsrlshoz tartoz krtyaterhelsi mvelethez, 
    * egyfajta azonost / hitelest kd, s mint ilyen, a vev oldali felleten is megjelenik, 
    * valamint a bolt is megkapja vlaszadatknt. Ez a kd mindkt fl szmra troland adat!
    */
    var $authorizaciosKod;

    function getPosId() {
        return $this->posId;
    }

    function setPosId($posId) {
        $this->posId = $posId;
    }

    function getAzonosito() {
        return $this->azonosito;
    }

    function setAzonosito($azonosito) {
        $this->azonosito = $azonosito;
    }

    function getTeljesites() {
        return $this->teljesites;
    }

    function setTeljesites($teljesites) {
        $this->teljesites = $teljesites;
    }

    function getValaszKod() {
        return $this->valaszKod;
    }

    function setValaszKod($valaszKod) {
        $this->valaszKod = $valaszKod;
    }

    function getAuthorizaciosKod() {
        return $this->authorizaciosKod;
    }

    function setAuthorizaciosKod($authorizaciosKod) {
        $this->authorizaciosKod = $authorizaciosKod;
    }

}

?>