<?php
/**
 * @package    JBusinessDirectory
 * @subpackage  com_jbusinessdirectory
 *
 * @copyright   Copyright (C) 2007 - 2015 CMS Junkie. All rights reserved.
 * @license     GNU General Public License version 2 or later;
 */

defined('_JEXEC') or die('Restricted access');
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');

require_once BD_CLASSES_PATH.'/attributes/attributeservice.php';
// Load the tooltip behavior.
JBusinessUtil::loadJQueryChosen();
$aliasStyle = (!$this->appSettings->show_alias && isset($isProfile))?"display:none":"";

$attributeConfig = $this->item->defaultAtrributes;
$video=$this->item;

$options = array(
        'onActive' => 'function(title, description) {
		description.setStyle("display", "block");
		title.addClass("open").removeClass("closed");
	}',
        'onBackground' => 'function(title, description) {
		description.setStyle("display", "none");
		title.addClass("closed").removeClass("open");
	}',
        'startOffset' => 0,  // 0 starts on the first tab, 1 starts the second, etc...
        'useCookie' => true, // this must not be a string. Don't use quotes.
);
?>

<script type="text/javascript">
    window.addEventListener('load', function() {
        Joomla.submitbutton = function (task) {

            jQuery("#item-form").validationEngine('detach');
            var evt = document.createEvent("HTMLEvents");
            evt.initEvent("click", true, true);
           
            if (task == 'video.cancel' || !jbdUtils.validateCmpForm(true, false)) {
                Joomla.submitform(task, document.getElementById('item-form'));
            }
            jQuery("#item-form").validationEngine('attach');
        }
    });
</script>

<div id="jbd-container" class="jbd-container jbd-edit-container">
    <form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&layout=edit&id='.(int) $this->item->id); ?>" method="post" name="adminForm" id="item-form" class="form-horizontal">
        <div class="row">
            <div class="col-md-7">
                <div class="row">
                    <div class="col-md">
                        <fieldset class="boxed">
                            <h2> <?php echo JText::_('LNG_VIDEO'); ?></h2>
                            <p> <?php echo JText::_('LNG_VIDEOS_INFORMATION_TEXT'); ?></p>
                            <div id="video-details">
                                <div class="form-container label-w-100" id="video-form-box">
                                    <div class="form-group">
                                        <label for="name"><?php echo JText::_('LNG_NAME') ?><?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY)?></label>                                        
                                            <input type="text" name="name" id="name" class="input_txt form-control validate[required]" value="<?php echo $this->escape($video->name) ?>"  maxLength="255">                                        
                                    </div>

                                    <div class="form-group" style="<?php echo $aliasStyle ?>">
                                        <label for="alias"><?php echo JText::_('LNG_ALIAS')?> </label>
                                        <input type="text"	name="alias" id="alias"  placeholder="<?php echo JText::_('LNG_AUTO_GENERATE_FROM_NAME')?>" class="input_txt form-control text-input" value="<?php echo $this->escape($this->item->alias) ?>"  maxLength="255">
                                    </div>

                                    <div class="form-group">
                                        <label for="url"><?php echo JText::_('LNG_URL') ?><?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY)?></label>
                                        <input type="text" name="url" id="url"
                                               class="input_txt form-control validate[required]"
                                               value="<?php echo $video->url ?>" maxlength="100">
                                    </div>

                                    <div class="form-group">
                                        <label for="description"><?php echo JText::_('LNG_DESCRIPTION') ?></label>                                        
                                            <textarea name="description" id="description" class="input_txt form-control h-auto"  cols="75" rows="5"  maxLength="450"><?php echo $video->description ?></textarea>                                        
                                    </div>

                                    <div class="form-group">
                                        <label for="transcript"><?php echo JText::_('LNG_TRANSCRIPT') ?></label>                                        
                                            <textarea name="transcript" id="transcript" class="input_txt form-control h-auto"  cols="75" rows="5" ><?php echo $video->transcript ?></textarea>                                        
                                    </div>

                                    <div class="form-group">
                                        <label for="duration"><?php echo JText::_('LNG_DURATION') ?><?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY)?></label>
                                        <input type="text" name="duration" id="duration"
                                               class="input_txt form-control validate[required]"
                                               value="<?php echo $video->duration ?>">
                                    </div>                                    
                                </div>
                            </div>
                        </fieldset>
                        
                        <?php if ($attributeConfig["category"] != ATTRIBUTE_NOT_SHOW) { ?>
                            <fieldset class="boxed">
                                <h2> <?php echo JText::_('LNG_CATEGORIES');?></h2>
                                <p><?php echo JText::_('LNG_SELECT_CATEGORY');?></p>
                                <div class="form-container">
                                    <div class="form-group">
                                        <label for="category"><?php echo JText::_('LNG_CATEGORY');?> <?php echo JBusinessUtil::showMandatory($attributeConfig["category"]) ?></label>
                                            <select name="selectedSubcategories[]" id="selectedSubcategories" data-placeholder="<?php echo JText::_("LNG_SELECT_CAT") ?>" class="form-control input-medium chosen-select-categories" multiple>
                                                <?php echo JHtml::_('select.options', $this->categoryOptions, 'value', 'text', $this->item->selCats);?>
                                            </select>
                                        <a href="javascript:jbdUtils.uncheckAllCategories('mainSubcategory', 'selectedSubcategories')"><?php echo JText::_("LNG_UNCHECK_ALL")?></a>
                                    </div>
                                    <div class="form-group">
                                        <?php if($attributeConfig["category"] == ATTRIBUTE_MANDATORY){?>
                                            <div  class="form-detail req"></div>
                                        <?php }?>
                                        <label for="subcat_main_id"><?php echo JText::_('LNG_MAIN_SUBCATEGORY');?>  <?php echo JBusinessUtil::showMandatory($attributeConfig["category"]) ?></label>
                                        <select data-placeholder="<?php echo JText::_("LNG_SELECT_CAT") ?>" class="form-control select <?php echo $attributeConfig["category"] == ATTRIBUTE_MANDATORY?"validate[required]":""?>" name="main_subcategory" id="mainSubcategory" onchange="jbdUtils.updateVideoAttributes(this.value, <?php echo $this->item->id ?>)" ?>>
                                            <?php foreach( $this->item->selectedCategories as $selectedCategory){?>
                                                <option value="<?php echo $selectedCategory->id ?>" <?php echo $selectedCategory->id == $this->item->main_subcategory ? "selected":"" ; ?>><?php echo $selectedCategory->name ?></option>
                                            <?php } ?>
                                        </select>
                                        <span class="error_msg" id="frmMainSubcategory_error_msg" style="display: none;"><?php echo JText::_('LNG_REQUIRED_FIELD')?></span>
                                    </div>
                                </div>                                        
                            </fieldset>
                        <?php }?>

                        <fieldset class="boxed col-12">
                            <div class="form-container">
                                <h2> <?php echo JText::_('LNG_ADD_THUMBNAIL');?></h2>
                                <div>
                                    <?php echo JText::_('LNG_ADD_THUMBNAIL_TEXT');?>
                                </div>
                                <div class="jupload logo-jupload">
                                    <div class="jupload-header">
                                        <div class="jupload-header-title">
                                            <?php echo JText::_("LNG_SELECT_IMAGE_TYPE") ?>
                                        </div>
                                    </div>
                                    <div class="jupload-body">
                                        <div class="jupload-files">
                                            <div class="jupload-files-img image-fit-contain" id="picture-preview">
                                                <?php
                                                if (!empty($this->item->thumbnail)) {
                                                    echo "<img src='".BD_PICTURES_PATH.$this->item->thumbnail."'/>";
                                                }else{
                                                    echo "<i class='la la-image'></i>";
                                                }
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="jupload-footer">
                                        <fieldset>
                                            <input  type="file" id="imageUploader" name="uploadLogo" size="50" >
                                            <input type="hidden" name="thumbnail" id="imageLocation" value="<?php echo $this->item->thumbnail?>">
                                        </fieldset>
                                        <div class="btn-group">
                                            <label for="imageUploader" class="btn btn-success"><?php echo JText::_("LNG_UPLOAD")?></label>
                                            <a name="" id="" class="btn btn-danger" href="javascript:uploadInstance.removeImage()" role="button"><?php echo JText::_("LNG_REMOVE_LOGO")?></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </fieldset>

                        <?php if(!empty($this->item->customFields) || $this->appSettings->enable_attribute_category){
                            $renderedContent = AttributeService::renderAttributes($this->item->customFields, false, array());
                            if (!empty($renderedContent)) { ?>
                                <fieldset class="boxed">
                                    <h2> <?php echo JText::_('LNG_ADDITIONAL_INFO'); ?></h2>
                                    <p><?php echo JText::_('LNG_ADDITIONAL_INFO_TEXT'); ?></p>
                                    <div class="form-container " id="customFieldsContent">
                                        <?php
                                        if ($this->appSettings->enable_attribute_category) {
                                            if (!empty($this->item->main_subcategory))
                                                echo $renderedContent;
                                            else
                                                echo JText::_("LNG_NO_ATTRIBUTES_FOR_CATEGORY");
                                        } else {
                                            echo $renderedContent;
                                        }
                                        ?>
                                    </div>
                                </fieldset>
                                <?php
                            }
                        } ?>

                        <input type="hidden" name="id" id="id" value="<?php echo $video->id ?>"/>
                        <hr/>
                       
                    </div>
                </div>
            </div>
            <div class="col-md-5">
                <fieldset class="boxed">
                    <h2> <?php echo JText::_('LNG_METADATA_INFORMATION');?></h2>
                    <p> <?php echo JText::_('LNG_METADATA_INFORMATION_TEXT');?>.</p>
                    <div class="form-group">
                        <label for="meta_title"><?php echo JText::_('LNG_META_TITLE')?></label>
                        <input type="text" name="meta_title" id="meta_title" class="form-control" value="<?php echo $this->escape($this->item->meta_title) ?>"  maxLength="100">
                    </div>
                    <div class="bootstrap-tags form-group">
                        <label for="meta_keywords"><?php echo JText::_('LNG_META_KEYWORDS')?></label>
                        <input type="text" data-role="tagsinput" name="meta_keywords" class="form-control" id="meta_keywords" value="<?php echo $this->item->meta_keywords ?>" maxlength="150" />
                    </div>
                    <div class="form-group">
                        <label for="meta_description"><?php echo JText::_('LNG_META_DESCRIPTION')?></label>
                        <textarea name="meta_description" id="meta_description" class="form-control" rows="4" maxLength="255"><?php echo $this->item->meta_description ?></textarea>
                    </div>
                </fieldset>
            </div>
        </div>
        <input type="hidden" name="option" value="<?php echo JBusinessUtil::getComponentName()?>" />
        <input type="hidden" name="task" id="task" value="" />
        <input type="hidden" name="id" value="<?php echo $video->id ?>" />
        <input type="hidden" name="view" id="view" value="video" />
        <?php echo JHTML::_( 'form.token' ); ?>
    </form>
</div>



<?php JBusinessUtil::loadUploadScript(); ?>

<script type="text/javascript">

let companyFolder = '<?php echo VIDEO_PICTURES_PATH ?>';
let companyFolderPath = '<?php echo JBusinessUtil::getUploadUrl() ?>&t=<?php echo strtotime("now")?>&picture_type=<?php echo PICTURE_TYPE_THUMBNAIL?>&_path_type=1&_target=<?php echo urlencode(VIDEO_PICTURES_PATH)?>&croppable=1';

let uploadInstance;

window.addEventListener('load', function() {
    uploadInstance = JBDUploadHelper.getUploadInstance();
    uploadInstance.imageUploader(companyFolder, companyFolderPath);
});


let maxCategories = <?php echo isset($this->item->package)?$this->item->package->max_categories :$this->appSettings->max_categories ?>;

window.addEventListener('load', function() {
    jQuery("#item-form").validationEngine('attach');

    jQuery(".chosen-select").chosen({width:"95%", disable_search_threshold: 5,search_contains: true, placeholder_text_single: "<?php echo JText::_('LNG_SELECT_OPTION')  ?>" , placeholder_text_multiple: "<?php echo JText::_('LNG_SELECT_OPTION')  ?>"});
    jQuery(".chosen-select-categories").chosen({width:"95%", max_selected_options: maxCategories, search_contains: true});

    jQuery('select#selectedSubcategories').on('change', function() {
        var selected = jQuery('#mainSubcategory option:selected').val();
        console.debug(selected);
        jQuery('select#mainSubcategory').find('option').remove();
        jQuery('select#selectedSubcategories option:selected').each(function () {
            if (jQuery(this).length) {
                var selCategoryOption = jQuery(this).clone();
                selCategoryOption.removeAttr('selected');
                jQuery('select#mainSubcategory').append(selCategoryOption);
                if(selCategoryOption.val() === selected) {
                    jQuery('select#mainSubcategory').find('option').attr('selected', 'selected');
                }
                jbdUtils.updateChosenSelect('select#mainSubcategory');
            }
        });

        var catId = jQuery('#mainSubcategory option:selected').val();
        if(catId === 0 || typeof catId === "undefined" ) {
            catId = -1;
        }
        
        <?php if($this->appSettings->enable_attribute_category) { ?>
            jbdListings.updateAttributes(catId, '<?php echo $this->item->id ?>');
        <?php } ?>
    });

    jQuery('.bootstrap-tagsinput input').on('keypress', function(e){
        if (e.keyCode == 13){
            e.keyCode = 188;
            e.preventDefault();
        }
    });

})    
</script>

