<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('behavior.multiselect');
 JBusinessUtil::initializeChosen();

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;

$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
$canOrder	= true;
$saveOrder	= $listOrder == 'mem.ordering';
?>

<script type="text/javascript">
window.addEventListener('load', function() {
    Joomla.submitbutton = function(task) {
        if (task != 'projects.delete' || confirm('<?php echo JText::_('LNG_ARE_YOU_SURE_YOU_WANT_TO_DELETE', true);?>')) {
            Joomla.submitform(task);
        }
    }
});
</script>
<div id="jbd-container" class="jbd-container">
    <form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=projects');?>" method="post" name="adminForm" id="adminForm">
        <div id="j-main-container" class="j-main-container">
            <?php
            // Search tools bar
            echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this, 'options' => array('filtersHidden' =>JBusinessUtil::setFilterVisibility($this->state))));
            ?>
        </div>
        <div class="clr clearfix"></div>

        <?php if (empty($this->items)) { ?>
            <div class="alert alert-warning">
                <?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
            </div>
        <?php } else { ?>

        <table class="jtable" id="itemList">
            <thead class="jtable-head">
                <tr class="jtable-head-row">
                    <td class="jtable-head-row-data"></td>
                    <th class="jtable-head-row-data" width="1%">
                        <div class="d-flex justify-content-center align-items-center">
                            <div class="jradio">
                                <input id="jradio-2" type="checkbox" title="<?php echo JText::_('JGLOBAL_CHECK_ALL');?>" onclick="Joomla.checkAll(this)" />
                                <label for="jradio-2"></label>
                            </div>
                        </div>
                    </th>
                    <th class="jtable-head-row-data" width="1%">
                        <div class="d-flex justify-content-center align-items-center">
                            <span class="jtable-head-row-data-title"> # </span>
                        </div>
                    </th>

                    <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_NAME', 'pr.name', $listDirn, $listOrder); ?></th>
                    <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_COMPANY', 'bc.name', $listDirn, $listOrder); ?></th>
                    <th class="jtable-head-row-data" style="text-align:center !important;"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_STATUS', 'pr.status', $listDirn, $listOrder); ?></th>
                    <th class="jtable-head-row-data" width="1%"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_ID', 'pr.id', $listDirn, $listOrder); ?></th>
                </tr>
            </thead>
            <tfoot>
                <tr>
                    <td colspan="15">
                        <?php echo $this->pagination->getListFooter(); ?>
                    </td>
                </tr>
            </tfoot>
            <tbody class="jtable-body">
            <?php $nrcrt = 1; $i=0;
            $count = count($this->items);
            foreach($this->items as $item) {
                $ordering  = ($listOrder == 'pr.ordering');
                $canCreate  = true;
                $canEdit    = true;
                $canChange  = true;
                ?>
                <tr class="jtable-body-row">

                    <td class="jtable-body-row-data">
                        <div class="d-flex align-items-center">
                            <div id="item-status-<?php echo $item->id ?>" class="jtable-body-status <?php echo $item->status == 1 ? "bg-success" : "bg-danger" ?> "></div>
                        </div>
                    </td>

                    <td class="jtable-body-row-data px-3">
		                <?php echo HTMLHelper::_('jbdgrid.id', $i, $item->id); ?>
                    </td>

                    <td class="jtable-body-row-data"><?php echo $nrcrt++; ?></td>

                    <td class="jtable-body-row-data jtable-body-name">
                        <div class="d-flex align-items-center">
                            <a href='<?php echo JRoute::_( 'index.php?option=com_jbusinessdirectory&task=project.edit&id='. $item->id ) ?>'>
				                <?php if (!empty($item->picture_path)) { ?>
                                    <img src="<?php echo BD_PICTURES_PATH.$item->picture_path ?>" class="jtable-data-img" />
				                <?php } else { ?>
                                    <img src="<?php echo BD_PICTURES_PATH.'/no_image.jpg' ?>" class="jtable-data-img" />
				                <?php } ?>
                            </a>

                            <span class="ml-3 d-flex flex-column justify-content-center">
                                <span class="jtable-body-row-data-title">
                                    <a href="<?php echo JRoute::_( 'index.php?option=com_jbusinessdirectory&task=project.edit&id='. $item->id ) ?>"
                                       title="<?php echo JText::_('LNG_CLICK_TO_EDIT'); ?>">
                                        <b><?php echo $item->name ?></b>
                                    </a><br/>
                                </span>
                                <span class="jtable-body-row-data-allias"><?php echo $item->name ?></span>
                            </span>
                        </div>
                    </td>

                    <td class="jtable-body-row-data">
		                <?php echo $item->companyName ?>
                    </td>

                    <td class="jtable-body-row-data">
		                <?php echo HTMLHelper::_('jbdgrid.published', $item->status, $i, 'projects.', true, 'cb', true, true, $item->id); ?>
                    </td>

                    <td class="jtable-body-row-data">
                        <span><?php echo (int) $item->id; ?></span>
                    </td>

                </tr>
                <?php
                $i++;
            } ?>
            </tbody>
        </table>
        <?php } ?>

        <input type="hidden" name="option" value="<?php echo JBusinessUtil::getComponentName()?>" />
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="boxchecked" value="0" />
        <?php echo JHTML::_('form.token'); ?>
    </form>
</div>