<?php
/**
 * @package    JBusinessDirectory
 * @subpackage  com_jbusinessdirectory
 *
 * @copyright   Copyright (C) 2007 - 2015 CMS Junkie. All rights reserved.
 * @license     GNU General Public License version 2 or later;
 */

defined('_JEXEC') or die('Restricted access');

/**
 * The HTML  View.
 */
JBusinessUtil::loadJQueryUI();

JBusinessUtil::enqueueScript('libraries/dropzone/dropzone.js');
JBusinessUtil::enqueueStyle('libraries/dropzone/dropzone.css');
JBusinessUtil::enqueueStyle('libraries/dropzone/basic.css');

JBusinessUtil::enqueueScript('libraries/chosen/ajax-chosen.min.js');

// following translations will be used in js
JText::script('LNG_IMAGE_SIZE_WARNING');

JBusinessUtil::includeValidation();

require_once HELPERS_PATH.'/helper.php';

class JBusinessDirectoryViewProject extends JBusinessDirectoryAdminView {
	protected $item;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null) {
		$this->item	 = $this->get('Item');
		$this->state = $this->get('State');
		$this->companies = $this->get('Companies');
		$this->translations = JBusinessDirectoryTranslations::getAllTranslations(PROJECT_DESCRIPTION_TRANSLATION, $this->item->id);
		$this->languages = JBusinessUtil::getLanguages();

		$this->companyOptions = JBusinessUtil::getCompaniesOptions($this->item->company_id);
		
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
		$this->addToolbar();

		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar() {
		$canDo = JBusinessDirectoryHelper::getActions();
		$input = JFactory::getApplication()->input;
		$input->set('hidemainmenu', true);
		$isNew = ($this->item->id == 0);

		JToolbarHelper::title(JText::_($isNew ? 'COM_JBUSINESSDIRECTORY_NEW_PROJECT' : 'COM_JBUSINESSDIRECTORY_EDIT_PROJECT'), 'menu.png');

		if ($canDo->get('core.edit')) {
			JToolbarHelper::apply('project.apply');
			JToolbarHelper::save('project.save');
		}

		JToolbarHelper::cancel('project.cancel', 'JTOOLBAR_CLOSE');

		JToolbarHelper::divider();
		JToolbarHelper::help('JHELP_JBUSINESSDIRECTORY_PROJECT_EDIT');
	}
}
