<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JBusinessUtil::initializeChosen();

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;

$user		= JBusinessUtil::getUser();
$canOrder	= true;
$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
$saveOrder	= $listOrder == 'p.ordering';
$saveOrderingUrl = JBusinessUtil::addSorting($saveOrder, $listDirn);
?>

<script type="text/javascript">
window.addEventListener("load", function() {
	Joomla.submitbutton = function(task) {
		if (task != 'paymentprocessors.delete' || confirm('<?php echo JText::_('COM_JBUSINESS_DIRECTORY_PAYMENT_PROCESSORS_CONFIRM_DELETE', true,true);?>')) {
			Joomla.submitform(task);
		}
    }
})
</script>
<div id="jbd-container" class="jbd-container">
    <form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=paymentprocessors');?>" method="post" name="adminForm" id="adminForm">
        <div id="j-main-container" class="j-main-container">
            <?php
            // Search tools bar
            echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this, 'options' => array('filtersHidden' =>JBusinessUtil::setFilterVisibility($this->state))));
            ?>
        </div>
        <div class="clr clearfix"></div>
    
        <?php if (empty($this->items)) { ?>
            <div class="alert alert-warning">
                <?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
            </div>
        <?php } else { ?>
    	<table class="jtable" id="itemList">
    		<thead class="jtable-head">
    			<tr class="jtable-head-row">
    				<td class="jtable-head-row-data"></td>
                    <th class="jtable-head-row-data">
                        <?php echo JHtml::_('searchtools.sort', '', 'p.ordering', $listDirn, $listOrder, null, 'asc', 'JGRID_HEADING_ORDERING', 'icon-menu-2'); ?>
                    </th>
                    <th class="jtable-head-row-data">
                        <div class="d-flex justify-content-center align-items-center">
                            <div class="jradio">
                                <input id="jradio-2" type="checkbox" title="<?php echo JText::_('JGLOBAL_CHECK_ALL');?>" onclick="Joomla.checkAll(this)" />
                                <label for="jradio-2"></label>
                            </div>
                    </th>
    				<th class="jtable-head-row-data">#</th>

    				<th class="jtable-head-row-data" ><?php echo HTMLHelper::_('searchtools.sort', 'LNG_STATUS', 'p.status', $listDirn, $listOrder); ?></th>
    				<th class="jtable-head-row-data" ><?php echo HTMLHelper::_('searchtools.sort', 'LNG_NAME', 'p.name', $listDirn, $listOrder); ?></th>
    				<th class="jtable-head-row-data" ><?php echo HTMLHelper::_('searchtools.sort', 'LNG_TYPE', 'p.type', $listDirn, $listOrder); ?></th>
    				<th class="jtable-head-row-data" ><?php echo JText::_('LNG_CONFIGURATION',true); ?></th>
    				<th class="jtable-head-row-data" width="15%" ><?php echo JText::_('LNG_COMPANY',true); ?></th>
    				<th class="jtable-head-row-data" width="20%" ><?php echo JText::_('LNG_SERVICES',true); ?></th>
    				<th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_DISPLAY_FRONT', 'p.displayfront', $listDirn, $listOrder); ?></th>
    				<th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_ID', 'p.id', $listDirn, $listOrder); ?></th>
    			</tr>
    		</thead>
    		<tfoot>
    			<tr>
    				<td colspan="15">
    					<?php echo $this->pagination->getListFooter(); ?>
    				</td>
    			</tr>
    		</tfoot>
            <tbody <?php if ($saveOrder) :?> class="jtable-body js-draggable" data-url="<?php echo $saveOrderingUrl; ?>" data-direction="<?php echo strtolower($listDirn); ?>" data-nested="false"<?php endif; ?>>
            <?php $nrcrt = 1; $i=0;
            $count = count($this->items);
            foreach($this->items as $item) {
                $ordering  = ($listOrder == 'p.ordering');
                $canCreate  = true;
                $canEdit    = true;
                $canChange  = true;
                ?>

                <tr class="jtable-body-row  <?php echo $nrcrt%2?>"
                    onmouseover	= "this.style.cursor='hand';this.style.cursor='pointer'"
                    onmouseout = "this.style.cursor='default'"
                    data-draggable-group="3">
                    <td class="jtable-body-row-data">
                        <div class="d-flex align-items-center">
                        	<div id="item-status-<?php echo $item->id?>" class="jtable-body-status <?php echo $item->status == 1 ?"bg-success":"bg-danger" ?> "></div>
                        </div>
                	</td>
                    <td class="jtable-body-row-data pl-3">
                        <?php
                        $iconClass = '';
                        if (!$canChange) {
                            $iconClass = ' inactive';
                        }
                        elseif (!$saveOrder) {
                            $iconClass = ' inactive tip-top hasTooltip" title="' . JHtml::tooltipText('JORDERINGDISABLED');
                        } ?>
                        <span class="sortable-handler<?php echo $iconClass ?>">
                            <i class="la la-ellipsis-v"></i>
                        </span>
                        <?php if ($canChange && $saveOrder) : ?>
                            <input type="text" style="display:none" name="order[]" size="5" value="<?php echo !empty($item->ordering)?$item->ordering : $nrcrt; ?>" />
                        <?php endif; ?>
                    </td>
                    <td class="jtable-body-row-data">
                        <?php echo HTMLHelper::_('jbdgrid.id', $i, $item->id); ?>
                    </td>
                    <td class="jtable-body-row-data"><?php echo $nrcrt++?></td>
                    
                    <td class="jtable-body-row-data">
                        <?php echo HTMLHelper::_('jbdgrid.published', $item->status, $i, 'paymentprocessors.', true, 'cb', true, true, $item->id); ?>
                    </td>

                    <td class="jtable-body-row-data jtable-body-name">
                        <a
                                href='<?php echo JRoute::_( 'index.php?option=com_jbusinessdirectory&task=paymentprocessor.edit&id='. $item->id )?>'
                                title="<?php echo JText::_('LNG_CLICK_TO_EDIT',true); ?>">
                            <B><?php echo $item->name?></B>
                        </a>
                    </td>
                    <td class="jtable-body-row-data">
                        <?php echo $item->type ?>
                    </td>
                    <td class="jtable-body-row-data">
                        <table>
                            <tr>
                                <td class="jtable-body-row-data">
                                    <?php echo JText::_('LNG_MODE',true);?>
                                </td>
                                <td class="jtable-body-row-data">
                                    <?php echo $item->mode ?>
                                </td>
                            </tr>
                            <?php foreach($item->processorFields as $field){?>
                                <tr>
                                    <td class="jtable-body-row-data">
                                        <?php echo JText::_("LNG_".strtoupper($field->column_name),true);?>
                                    </td>
                                    <td class="jtable-body-row-data">
                                        <?php echo $field->column_value ?>
                                    </td>
                                </tr>
                            <?php } ?>
                        </table>
                    </td>
                    <td class="jtable-body-row-data">
                    	<?php echo $item->company_name ?>
                    </td>
                    <td class="jtable-body-row-data">
                        <?php echo !empty($item->selServiceNames)?$item->selServiceNames:("<span class='text-warning'>".JText::_('LNG_NO_SERVICES_ASSINGED',true)."</span>"); ?>
                    </td>
                    <td class="jtable-body-row-data">
                        <img src ="<?php echo BD_ASSETS_FOLDER_PATH."images/".($item->displayfront==0? "unchecked.gif" : "checked.gif")?>"
                             onclick	="document.location.href = '<?php echo JRoute::_( 'index.php?option=com_jbusinessdirectory&task=paymentprocessors.changeFrontState&id='. $item->id )?>'"
                        />
                    </td>
                    <td class="jtable-body-row-data">
                        <?php echo $item->id?>
                    </td>
                </tr>
                <?php
                $i++;
            } ?>
            </tbody>
    	</table>
    	<?php } ?>
    	<input type="hidden" name="task" value="" /> 
    	<input type="hidden" name="boxchecked" value="0" />
    	<?php echo JHTML::_('form.token'); ?> 
    </form>
</div>