<?php
/**
 * @paymentprocessor    JBusinessDirectory
 * @subpaymentprocessor  com_jbusinessdirectory
 *
 * @copyright   Copyright (C) 2007 - 2015 CMS Junkie. All rights reserved.
 * @license     GNU General Public License version 2 or later;
 */

defined('_JEXEC') or die('Restricted access');

JBusinessUtil::enqueueScript('libraries/chosen/ajax-chosen.min.js');

// following translations will be used in js
JText::script('LNG_COLUMN_NAME');
JText::script('LNG_COLUMN_VALUE');

JBusinessUtil::includeValidation();

require_once HELPERS_PATH.'/helper.php';

/**
 * The HTML  View.
 */
class JBusinessDirectoryViewPaymentProcessor extends JBusinessDirectoryAdminView {
	protected $item;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null) {
		$this->item	 = $this->get('Item');
		$this->state = $this->get('State');

		$this->item->services = JBusinessUtil::getAvailablePayableServices();

		$this->statuses = JBusinessDirectoryHelper::getStatuses();
		$this->modes = JBusinessDirectoryHelper::getModes();

		$this->defaultProcessors = JBusinessUtil::getDefaultPaymentProcessors();

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JFactory::getApplication()->enqueueMessage(implode("\n", $errors), 'error');
			return false;
		}
		$this->addToolbar();
		
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar() {
		$canDo = JBusinessDirectoryHelper::getActions();
		$input = JFactory::getApplication()->input;
		$input->set('hidemainmenu', true);
		$isNew = ($this->item->id == 0);

		JToolbarHelper::title(JText::_($isNew ? 'COM_JBUSINESSDIRECTORY_NEW_PAYMENT_PROCESSOR' : 'COM_JBUSINESSDIRECTORY_EDIT_PAYMENT_PROCESSOR'), 'menu.png');
		
		
		
		if ($canDo->get('core.edit')) {
			JToolbarHelper::apply('paymentprocessor.apply');
			JToolbarHelper::save('paymentprocessor.save');
		}
		
		JToolbarHelper::cancel('paymentprocessor.cancel', 'JTOOLBAR_CLOSE');
		
		JToolbarHelper::divider();
		JToolBarHelper::help('', false, DOCUMENTATION_URL.'businessdiradmin.html#payment-processors');
	}
}
