<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');

// Include the component HTML helpers.
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');

// Load the tooltip behavior.
$user = JBusinessUtil::getUser();

use Joomla\CMS\Language\Language;
?>

<script type="text/javascript" xmlns="http://www.w3.org/1999/html">
window.addEventListener("load", function() {
    Joomla.submitbutton = function(task)
    {
        if (task == 'paymentprocessor.cancel' || !jbdUtils.validateCmpForm(true, false)) {
            Joomla.submitform(task, document.getElementById('item-form'));
        }
    }
})
</script>

<div class="jbd-container jbd-edit-container">
	<?php  if(isset($isProfile)) { ?>
        <div class="row py-2 mb-2">
            <div class="col-md-12">
                <div>
                    <div class="button-row">
                        <button id="save-btn" type="button" class="btn btn-success" onclick="savePaymentProcessor('apply')">
                            <i class="la la-edit"></i> <?php echo JText::_("LNG_SAVE")?>
                        </button>
                        <button type="button" class="btn btn-success" onclick="savePaymentProcessor('save');">
                            <span class="ui-button-text"><i class="la la-check"></i> <?php echo JText::_("LNG_SAVE_AND_CLOSE")?></span>
                        </button>
                        <button type="button" class="btn btn-dark" onclick="cancel()">
                            <i class="la la-close"></i> <?php echo JText::_("LNG_CANCEL")?>
                        </button>
                    </div>
                </div>
            </div>
        </div>
	<?php  } ?>

    <div class="row">
        <div class="col-md-7">
            <form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&layout=edit&id='.(int) $this->item->id); ?>" method="post" name="adminForm" id="item-form" class="form-horizontal">
                <div class="row">
                    <div class="col-12">
                        <fieldset class="boxed">
                            <h2> <?php echo JText::_('LNG_PAYMENT_PROCESSOR'); ?></h2>
                            <span id="payment_processor_details">
                                <div class="form-container">
                                    <div class="row">
                                        <div class="col-12">
                                             <div class="form-group">
                                                <label for="name"><?php echo JText::_('LNG_NAME') ?><?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY) ?></label>
                                                <input type="text" name="name" id="name"
                                                       class="input_txt form-control validate[required]"
                                                       value="<?php echo $this->escape($this->item->name) ?>" maxlength="60">
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label for="type"><?php echo JText::_('LNG_TYPE') ?><?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY) ?></label>
                                                <select name="type" id="type" class="form-control validate[required]" onchange="jbdUtils.addProcessorFieldsHTML()">
                                                    <option value=""><?php echo JText::_('LNG_SELECT_TYPE') ?></option>
                                                    <?php foreach ($this->defaultProcessors as $type => $name) {
                                                        $selected = $type == $this->item->type ? 'selected' : '';
                                                        ?>
                                                        <option value="<?php echo $type ?>" <?php echo $selected ?>><?php echo $type ?></option>
                                                    <?php } ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                        <div class="form-group">
                                            <label for="timeout"><?php echo JText::_('LNG_TIMEOUT') ?></label>
                                            <input type="text" name="timeout"s
                                                   class="input_txt form-control"
                                                   value="<?php echo $this->item->timeout ?>" size="40"  maxlength="255">
                                            <?php echo JText::_('LNG_TIMEOUT_PROCESSOR_DESC',true); ?>
                                            <div class="clear"></div>
                                        </div>
                                    </div>
                                        <div class="col-12">
                                            <?php if (JBusinessUtil::canAssignPaymentProcessor() && $this->item->company_id!=-1) { ?>
                                                <div class="form-group">
                                                    <label for="services"><?php echo JText::_('LNG_COMPANY') ?><?php echo isset($isProfile) ? JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY) : '' ?></label>
                                                    <select data-placeholder="<?php echo JText::_("LNG_SELECT_OR_SEARCH_COMPANY") ?>" class="form-control input-medium ajax-chosen-select <?php echo (isset($isProfile)) ? 'validate[required]' : '' ?>" name="company_id" id="company_id">
                                                        <option value=""><?php echo JText::_("LNG_SELECT_OR_SEARCH_COMPANY")?></option>
                                                        <option value="-1"><?php echo JText::_("LNG_DEFAULT")?></option>
                                                        <?php if (!empty($this->item->company_id))
                                                            echo JHtml::_('select.options', $this->item->companyOptions, 'id', 'name', $this->item->company_id);
                                                        ?>
                                                        <?php echo JHtml::_('select.options', $this->companyOptions, 'id', 'name', -1); ?>
                                                    </select>
                                                </div>
                                            <?php } ?>
                                            <div class="form-group">
                                                <label for="services"><?php echo JText::_('LNG_SERVICES') ?><?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY) ?></label>
                                                <select data-placeholder="<?php echo JText::_("LNG_SELECT_SERVICE") ?>" class="form-control select chosen-select validate[required]" multiple name="servicesId[]" id="services">
                                                    <?php
                                                    foreach ($this->item->services as $service) {
                                                        $selected = false;
                                                        foreach($this->item->selectedServices as $sService) {
                                                            if($sService->app_id == $service->id)
                                                                $selected = true;
                                                        } ?>
                                                        <option <?php echo $selected ? "selected" : ""?> value='<?php echo $service->id ?>'>
                                                            <?php echo $service->name ?>
                                                        </option>
                                                        <?php
                                                    } ?>
                                                </select>
                                            </div>

                                            <div class="form-group">
                                                <label for="mode"><?php echo JText::_('LNG_MODE') ?></label>
                                                    <select id='mode' name='mode' class="input_sel form-control select chosen-select">
                                                        <?php foreach ($this->modes as $allmodes){?>
                                                            <option value = '<?php echo $allmodes->value?>' <?php echo $allmodes->value==$this->item->mode? "selected" : ""?>> <?php echo $allmodes->text?></option>
                                                        <?php } ?>
                                                     </select>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="status"><?php echo JText::_('LNG_STATUS') ?></label>
                                                <fieldset id="status_fld" class="radio btn-group btn-group-yesno">
                                                    <input type="radio" class="validate[required]" name="status" id="status1" value="0" <?php echo $this->item->status==0? 'checked="checked"' :""?> />
                                                    <label class="btn" for="status1"><?php echo JText::_('LNG_INACTIVE')?></label>
                                                    <input type="radio" class="validate[required]" name="status" id="status0" value="1" <?php echo $this->item->status==1? 'checked="checked"' :""?> />
                                                    <label class="btn" for="status0"><?php echo JText::_('LNG_ACTIVE')?></label>
                                                </fieldset>
                                            </div>
                                        </div>
                                        
                                       	<div class="col-md-12">
			                                <div class="form-group">
			                                      <label for="displayfront"><?php echo JText::_('LNG_DISPLAY_FRONT') ?></label>
			                                    <fieldset id="displayfront_fld" class="radio btn-group btn-group-yesno">
			                                        <input type="radio" class="validate[required]" name="displayfront" id="displayfront1" value="0" <?php echo $this->item->displayfront==0? 'checked="checked"' :""?> />
			                                        <label class="btn" for="displayfront1"><?php echo JText::_('LNG_NO')?></label>
			                                        <input type="radio" class="validate[required]" name="displayfront" id="displayfront0" value="1" <?php echo $this->item->displayfront==1? 'checked="checked"' :""?> />
			                                        <label class="btn" for="displayfront0"><?php echo JText::_('LNG_YES')?></label>
			                                    </fieldset>
			                                </div>
			                            </div>
                                        
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="id"><?php echo JText::_('LNG_ID') ?></label>
                                                <input type="text" name="id" id="id"
                                                       class="input_txt form-control"
                                                       value="<?php echo $this->escape($this->item->id) ?>" disabled >
                                                <div class="clear"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </span>
                        </fieldset>
                        <fieldset class="boxed">
                            <h2> <?php echo JText::_('LNG_PAYMENT_PROCESSOR_FIELDS'); ?></h2>
                            <span id="payment_processor_details">
                            <div class="form-container label-w-100" id="payment_processor_fields">
                    <?php $i = 0;
                    if(count($this->item->processorFields) > 0 ) {
                        foreach ($this->item->processorFields as $key => $value) { ?>
                            <div class="row processor-fields mb-1 mr-1" id="processor_field_<?php echo $i; ?>">
                                <div class="col-md-4 d-flex align-items-center">
                                    <label class="hasTooltip" for="column_name[]"> <?php echo JText::_("LNG_" . strtoupper($value->column_name), true); ?> : </label>
                                    <span id="column_name">
                                        <input type='hidden' name='column_name[]' id='column_name[]'
                                               value='<?php echo $value->column_name ?>'">
                                    </span>
                                </div>
                                <div class="col-md-4">
                                    <span id="column_value">
                                        <input type="text" name="column_value[]" id="column_value[]"
                                               value="<?php echo $this->escape($value->column_value) ?>" size=32
                                               maxlength=128 />
                                    </span>
                                </div>

                                <div class="col-md-3 d-flex align-items-center">
                                    <select id='mode' name='column_mode[]' class="input_sel form-control">
                                            <option value = '0' <?php echo $value->column_mode=='0'? "selected" : ""?>> <?php echo JText::_('LNG_TEST')?></option>
                                            <option value = '1' <?php echo $value->column_mode=='1'? "selected" : ""?>> <?php echo JText::_('LNG_LIVE')?></option>
                                    </select>
                                </div>

                                <div class="col-md-1 d-flex align-items-center" id="delete_processor_field_<?php echo $i ?>">
                                    <a href="javascript:void(0)" class="btn btn-xs btn-danger btn-panel"
                                       onclick="jbdUtils.deleteProcessorOption(<?php echo $i ?>)">
                                        <i class="la la-trash"></i>
                                    </a>
                                </div>
                                <input type="hidden" id="field_id" value="<?php echo $i ?>"/>
                            </div>
                            <?php $i++; } ?>
                        <div class="left" id="add_processor_field">
                            <br/>
                            <a href="javascript:void(0)" class="btn btn-xs btn-success btn-panel"
                               onclick="jbdUtils.addProcessorOption(<?php echo $i - 1 ?>)">
                                <i class="la la-plus"></i>
                            </a>
                        </div>
                    <?php } else { ?>
                        <div class="row processor-fields mb-1 base-fields mr-1" id="processor_field_0">
                            <div class="col-md-4">
                                <label class="hasTooltip" for="column_name[]"></label>
                                <span id="column_name">
                                    <input type='text' name='column_name[]' id='column_name[]'
                                           placeholder="<?php echo JText::_('LNG_COLUMN_NAME', true); ?>" value=''/>
                                </span>
                            </div>
                            <div class="col-md-4">
                                <label class="hasTooltip" for="column_value[]"></label>
                                <span id="column_value">
                                    <input type="text" name="column_value[]" id="column_value[]"
                                           placeholder="<?php echo JText::_('LNG_COLUMN_VALUE', true); ?>" value=""
                                           size=32 maxlength=128/>
                                </span>
                                <div class="clear"></div>
                            </div>
                            <div class="col-md-4 d-flex align-items-center" id="delete_processor_field_0"></div>
                            <input type="hidden" id="field_id" value="0"/>
                        </div>
                        <div class="left" id="add_processor_field">
                            <br/>
                            <a href="javascript:void(0)" class="btn btn-xs btn-success btn-panel"
                               onclick="jbdUtils.addProcessorOption(0)">
                                <i class="la la-plus"></i>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                        </fieldset>
                        <input type="hidden" name="task" id="task" value="" />
                        <input type="hidden" name="id" id="id" value="<?php echo $this->item->id ?>" />

                        <?php echo JHTML::_( 'form.token' ); ?>
                    </div>
                </div>
            </form>
        </div>

	    <?php if (!empty($this->item->id) && JBusinessUtil::hasTranslation('LNG_'.strtoupper($this->item->type).'_INFO')) { ?>
            <div class="col-md-4 offset-md-1">
                <fieldset class="boxed">
                    <div class="processor-info-box">
                        <div class="info-header">
                            <i class="la la-exclamation-circle"></i>
                        </div>
                        <div class="info-body">
		                    <?php echo JText::_('LNG_'.strtoupper($this->item->type).'_INFO'); ?>
                        </div>
                    </div>
                </fieldset>
            </div>
	    <?php } ?>
    </div>
</div>

<script>
    window.addEventListener('load', function(){
        jQuery(".chosen-select").chosen({placeholder_text_single: "<?php echo JText::_('LNG_SELECT_OPTION')  ?>" , placeholder_text_multiple: "<?php echo JText::_('LNG_SELECT_OPTION')  ?>"});

        if (jbdUtils.getProperty("isProfile") != 1) {
            var isProfile = false;
            var userId = 0;
        } else {
            var userId = '<?php echo $user->id ?>';
        }

        let urlGetCompanies = jbdUtils.getAjaxUrl('getCompaniesByStringAjax', 'companies', 'managecompanies');
        jQuery("#company_id").ajaxChosen({
                type: 'GET',
                url: urlGetCompanies,
                data: {
                    isProfile: isProfile,
                    userId: userId
                },
                dataType: 'json'
            },
            function (data) {
                var results = [];
                jQuery.each(data, function (i, val) {
                    results.push({value: val.id, text: val.name});
                });
                return results;
            },
            {
                width: "95%", disable_search_threshold: -1, allow_single_deselect: true
            });
    });

    function savePaymentProcessor(task) {
        var evt = document.createEvent("HTMLEvents");
        evt.initEvent("click", true, true);

        if(jbdUtils.validateCmpForm(true, false))
            return false;
        jQuery("#task").val('managepaymentprocessor.'+task);
        var form = document.adminForm;
        form.submit();
    }

    function cancel() {
        jQuery("#task").val('managepaymentprocessor.cancel');
        var form = document.adminForm;
        form.submit();
    }

</script>