<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');

// Include the component HTML helpers.
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');

// Load the tooltip behavior.
?>

<?php 
$appSetings = JBusinessUtil::getApplicationSettings();
$options = array(
		'onActive' => 'function(title, description){
		description.setStyle("display", "block");
		title.addClass("open").removeClass("closed");
}',
		'onBackground' => 'function(title, description){
		description.setStyle("display", "none");
		title.addClass("closed").removeClass("open");
}',
		'startOffset' => 0,  // 0 starts on the first tab, 1 starts the second, etc...
		'useCookie' => true, // this must not be a string. Don't use quotes.
);

$jbdTabs = new JBDTabs();
$jbdTabs->setOptions($options);
?>

<script>
window.addEventListener('load', function() {
    Joomla.submitbutton = function(task) {	

        var defaultLang="<?php echo JBusinessUtil::getLanguageTag() ?>";

        jQuery("#item-form").validationEngine('detach');
        var evt = document.createEvent("HTMLEvents");
        evt.initEvent("click", true, true);
        var tab = ("tab-"+defaultLang);
        if(!(document.getElementsByClassName(tab)[0] === undefined || document.getElementsByClassName(tab)[0] === null))
            document.getElementsByClassName(tab)[0].dispatchEvent(evt);
        if (task == 'package.cancel' || !jbdUtils.validateCmpForm(false, false)) {
            Joomla.submitform(task, document.getElementById('item-form'));
        }
        jQuery("#item-form").validationEngine('attach');
    }
});
</script>

<div id="jbd-container" class="jbd-container jbd-edit-container">
    <form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&layout=edit&id='.(int) $this->item->id); ?>" method="post" name="adminForm" id="item-form" class="form-horizontal">
        <div class="row">
            <div class="col-md-7">
                <div class="row">
                    <div class="col-md-12">
                        <fieldset class="boxed">
                            <h2> <?php echo JText::_('LNG_PACKAGE_DETAILS');?></h2>
                            <?php
                                echo ' ( ';
                                if($this->type == PACKAGE_TYPE_BUSINESS)
                                    echo JTEXT::_('LNG_BUSINESS_PACKAGE');
                                if($this->type == PACKAGE_TYPE_USER)
                                    echo JTEXT::_('LNG_USER_PACKAGE');
                                echo ' )';
                                ?>
                            <p><?php echo JText::_('LNG_DISPLAY_INFO_TXT');?></p>
                            <div class="form-container">
                                <div class="form-group" id="name_input">
                                    <label for="subject"><?php echo JText::_('LNG_NAME')?> <?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY) ?></label>
                                    <?php
                                    if ($this->appSettings->enable_multilingual) {
                                        echo $jbdTabs->startTabSet('tab_group_name');
                                        foreach ($this->languages as $k => $lng) {
                                            echo $jbdTabs->addTab('tab_group_name', 'tab-' . $lng, $k);
                                            $langContent = isset($this->translations[$lng . "_name"]) ? $this->translations[$lng . "_name"] : "";
                                            if ($lng == JBusinessUtil::getLanguageTag() && empty($langContent)) {
                                                $langContent = $this->item->name;
                                            }
                                            $langContent = $this->escape($langContent);
                                            echo "<input type='text' name='name_$lng' id='name_$lng' class='form-control validate[required]' value=\"" . stripslashes($langContent) . "\"  maxLength='145'>";
                                            echo $jbdTabs->endTab();
                                        }
                                        echo $jbdTabs->endTabSet();
                                    }
                                    else { ?>
                                        <input type="text" name="name" id="name" class="form-control validate[required]"
                                               value="<?php echo $this->escape($this->item->name) ?>" maxlength="145">
                                    <?php } ?>
                                </div>

                                <div class="form-group">
                                    <label for="description_id"><?php echo JText::_('LNG_DESCRIPTION')?> </label>
                                    <?php
                                        if($this->appSettings->enable_multilingual) {
                                            $options = array(
                                                    'onActive' => 'function(title, description){
                                                    description.setStyle("display", "block");
                                                    title.addClass("open").removeClass("closed");
                                            }',
                                                    'onBackground' => 'function(title, description){
                                                    description.setStyle("display", "none");
                                                    title.addClass("closed").removeClass("open");
                                            }',
                                                    'startOffset' => 0,  // 0 starts on the first tab, 1 starts the second, etc...
                                                    'useCookie' => true, // this must not be a string. Don't use quotes.
                                            );
                                            $jbdTabs->setOptions($options);
                                            echo $jbdTabs->startTabSet('tab_groupsd_id');
                                            foreach( $this->languages  as $k=>$lng ) {
                                                echo $jbdTabs->addTab('tab_groupsd_id', 'tab-'.$lng, $k);
                                                $langContent = isset($this->translations[$lng])?$this->translations[$lng]:"";
                                                if($lng==JBusinessUtil::getLanguageTag() && empty($langContent)) {
                                                    $langContent = $this->item->description;
                                                }
                                                $editor = JBusinessUtil::getEditor();
                                                echo $editor->display('description_'.$lng, $langContent, '95%', '200', '70', '10', false);
                                                echo $jbdTabs->endTab();
                                            }
                                            echo $jbdTabs->endTabSet();
                                        } else {
    
                                            $editor = JBusinessUtil::getEditor();
                                            echo $editor->display('description', $this->item->description, '95%', '200', '70', '10', false);
                                        } ?>
                                </div>

                                <div class="form-group">
                                    <label for="description_id"><?php echo JText::_('LNG_PRICE_DESCRIPTION')?> </label>
                                    <?php
                                        if($this->appSettings->enable_multilingual) {
                                            $options = array(
                                                    'onActive' => 'function(title, description){
                                                    description.setStyle("display", "block");
                                                    title.addClass("open").removeClass("closed");
                                            }',
                                                    'onBackground' => 'function(title, description){
                                                    description.setStyle("display", "none");
                                                    title.addClass("closed").removeClass("open");
                                            }',
                                                    'startOffset' => 0,  // 0 starts on the first tab, 1 starts the second, etc...
                                                    'useCookie' => true, // this must not be a string. Don't use quotes.
                                            );
                                            $jbdTabs->setOptions($options);
                                            echo $jbdTabs->startTabSet('tab_groupsd_price_desc');
                                            foreach( $this->languages  as $k=>$lng ) {
                                                echo $jbdTabs->addTab('tab_groupsd_price_desc', 'tab-'.$lng, $k);
                                                $langContent = isset($this->translations[$lng . "_short"])?$this->translations[$lng . "_short"]:"";
                                                if($lng==JBusinessUtil::getLanguageTag() && empty($langContent)) {
                                                    $langContent = $this->item->price_description;
                                                }
                                                $editor = JBusinessUtil::getEditor();
                                                echo $editor->display('price_description_'.$lng, $langContent, '95%', '200', '70', '10', false);
                                                echo $jbdTabs->endTab();
                                            }
                                            echo $jbdTabs->endTabSet();
                                        } else {
    
                                            $editor = JBusinessUtil::getEditor();
                                            echo $editor->display('price_description', $this->item->price_description, '95%', '200', '70', '10', false);
                                        } ?>
                                </div>

                                <div class="form-group" style="display:none">
                                    <label for="specialPrice"><?php echo JText::_('LNG_SPECIAL_PRICE')?> <?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY)?></label>
                                    <input type="text"
                                        name=special_price id="special_price" class="form-control"
                                        value="<?php echo $this->item->special_price ?>">
                                </div>

                                <div class="form-group" style="display:none">
                                    <label for="startDate"><?php echo JText::_('LNG_SPECIAL_START_DATE')?> </label>
                                    <?php echo JHTML::_('calendar', $this->item->special_from_date, 'special_from_date', 'special_from_date', $appSetings->calendarFormat, array('class'=>'form-control calendar-date', 'size'=>'10',  'maxlength'=>'10')); ?>
                                </div>

                                <div class="form-group" style="display:none">
                                    <label for="endDate"><?php echo JText::_('LNG_SPECIAL_END_DATE');?> </label>
                                    <?php echo JHTML::_('calendar', $this->item->special_to_date, 'special_to_date', 'special_to_date', $appSetings->calendarFormat, array('class'=>'form-control calendar-date', 'size'=>'10',  'maxlength'=>'10')); ?>
                                </div>

                                <div class="form-group" >
                                    <label for="only_for_admin"><?php echo JText::_('LNG_ONLY_FOR_ADMIN')?> <?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY) ?></label>
                                    <div>
                                        <fieldset id="only_for_admin_fld" class="radio btn-group btn-group-yesno">
                                            <input type="radio" class="validate[required]" name="only_for_admin" id="only_for_admin1" value="1" <?php echo $this->item->only_for_admin==1? 'checked="checked"' :""?> />
                                            <label class="btn" for="only_for_admin1"><?php echo JText::_('LNG_YES')?></label>
                                            <input type="radio" class="validate[required]" name="only_for_admin" id="only_for_admin0" value="0" <?php echo $this->item->only_for_admin==0? 'checked="checked"' :""?> />
                                            <label class="btn" for="only_for_admin0"><?php echo JText::_('LNG_NO')?></label>
                                        </fieldset>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="state-attr"><?php echo JText::_('LNG_STATE')?> </label>
                                    <fieldset id="status_fld" class="radio btn-group btn-group-yesno">
                                        <input type="radio" class="validate[required]" name="status" id="status-1" value="1" <?php echo $this->item->status==1? 'checked="checked"' :""?> />
                                        <label class="btn" for="status-1"><?php echo JText::_('LNG_ACTIVE')?></label>
                                        <input type="radio" class="validate[required]" name="status" id="status-0" value="0" <?php echo $this->item->status==0? 'checked="checked"' :""?> />
                                        <label class="btn" for="status-0"><?php echo JText::_('LNG_INACTIVE')?></label>
                                    </fieldset>
                                </div>

                                <div class="form-group">
                                    <label id="package_usergroup-lbl" for="package_usergroup" class="hasTooltip" data-toggle="tooltip" data-original-title="<strong><?php echo JText::_('LNG_PACKAGE_USERGROUP');?></strong><br/><?php echo JText::_('LNG_PACKAGE_USERGROUP_DESCRIPTION');?>" title=""><?php echo JText::_('LNG_PACKAGE_USERGROUP'); ?></label>
                                    <div>
                                        <select	id="package_usergroup" name="package_usergroup[]" class="chosen-select-usergroup" multiple>
                                            <?php echo JHtml::_('select.options',$this->userGroups, 'value', 'name', $this->item->package_usergroup);?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </fieldset>

                        <fieldset class="boxed">
                                <div class="form-container">
                                    <div class="form-group">
                                        <label  id="expiration_type-lbl" for="expiration_type"><?php echo JText::_('LNG_TYPE')?> </label>
                                        <div class="control-group">
                                            <div class="">
                                                <fieldset id="expiration_type" class="radio btn-group btn-group-yesno">
                                                    <input id="jrepeat1" type="radio" value="1" name="expiration_type" <?php echo  $this->item->expiration_type==1 ?'checked="checked"':'';?>>
                                                    <label class="btn" for="jrepeat1"><?php echo JText::_("LNG_LIFE_TIME") ?></label>
                                                    <input id="jrepeat2" type="radio" value="2" name="expiration_type" <?php echo  $this->item->expiration_type==2 ?'checked="checked"':'';?>>
                                                    <label class="btn" for="jrepeat2"><?php echo JText::_("LNG_FIXED") ?></label>
                                                    <input id="jrepeat3" type="radio" value="3" name="expiration_type" <?php echo  $this->item->expiration_type==3 ?'checked="checked"':'';?>>
                                                    <label class="btn" for="jrepeat3"><?php echo JText::_("LNG_RECURRING") ?></label>
                                                    <input id="jrepeat4" type="radio" value="4" name="expiration_type" <?php echo  $this->item->expiration_type==4 ?'checked="checked"':'';?>>
                                                    <label class="btn" for="jrepeat4"><?php echo JText::_("LNG_RECURRING_WTIH_TRIAL") ?></label>
                                                </fieldset>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label for="price"><?php echo JText::_('LNG_PRICE')?> <?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY) ?></label>
                                        <input type="text" name="price" id="price" class="form-control validate[required]" value="<?php echo $this->item->price ?>">
                                    </div>

                                    <div class="form-group">
                                        <label for="price"><?php echo JText::_('LNG_RENEWAL_PRICE')?></label>
                                        <input type="text" name="renewal_price" id="renewal_price" class="form-control" value="<?php echo $this->item->renewal_price ?>">
                                    </div>

                                    <div class="form-group" id="type-fixed">
                                        <div class="form-detail req"></div>
                                        <label for="days"><?php echo JText::_('LNG_TIME_PERIOD')?> <?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY) ?></label>
                                        <div class="d-flex w-25">
                                            <select class="form-control input-small" name="time_unit">
                                                <option value="D" <?php echo  $this->item->time_unit=="D"?"selected":"" ?>><?php echo JText::_('LNG_DAYS')?></option>
                                                <option value="W" <?php echo  $this->item->time_unit=="W"?"selected":"" ?>><?php echo JText::_('LNG_WEEKS')?></option>
                                                <option value="M" <?php echo  $this->item->time_unit=="M"?"selected":"" ?>><?php echo JText::_('LNG_MONTHS')?></option>
                                                <option value="Y" <?php echo  $this->item->time_unit=="Y"?"selected":"" ?>><?php echo JText::_('LNG_YEARS')?></option>
                                            </select>
                                            <input class="form-control input-small validate[required]" style="width:80px" type="text" name="time_amount" id="time_amount" value="<?php echo $this->item->time_amount ?>">
                                        </div>
                                        (<?php echo $this->item->days ?> <?php echo JText::_('LNG_DAYS')?>)
                                    </div>

                                    <div id="type-recurring">
                                        <div class="form-notice"><?php echo JText::_("LNG_RECURRING_ONLY_WITH_SUBSCRIPTIONS")?></div>
                                        <div class="form-group">
                                            <label for="price"><?php echo JText::_('LNG_NUMBER_OF_OCCURRENCES')?> <?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY) ?></label>
                                            <div>
                                                <select	id="recurrence_count" name="recurrence_count" class="chosen-select">
                                                    <?php echo JHtml::_('select.options',$this->paymentOccurances, 'value', 'text', $this->item->recurrence_count);?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div id="type-recurring-trial">
                                        <div class="form-group" >

                                            <label for="price"><?php echo JText::_('LNG_TRIAL_PRICE')?> <?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY) ?></label>
                                            <input type="text" name="trial_price" id="trial_price" class="form-control validate[required]" value="<?php echo $this->item->trial_price ?>">
                                        </div>

                                        <div class="form-group">

                                            <label for="days"><?php echo JText::_('LNG_TRIAL_TIME_PERIOD')?> <?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY) ?></label>
                                            <div class="d-flex w-25">
                                                <select class="form-control input-small" name="trial_period_unit">
                                                    <option value="D" <?php echo  $this->item->trial_period_unit=="D"?"selected":"" ?>><?php echo JText::_('LNG_DAYS')?></option>
                                                    <option value="W" <?php echo  $this->item->trial_period_unit=="W"?"selected":"" ?>><?php echo JText::_('LNG_WEEKS')?></option>
                                                    <option value="M" <?php echo  $this->item->trial_period_unit=="M"?"selected":"" ?>><?php echo JText::_('LNG_MONTHS')?></option>
                                                    <option value="Y" <?php echo  $this->item->trial_period_unit=="Y"?"selected":"" ?>><?php echo JText::_('LNG_YEARS')?></option>
                                                </select>
                                                <input class="form-control input-small validate[required]" style="width:80px" type="text" name="trial_period_amount" id="trial_period_amount" value="<?php echo $this->item->trial_period_amount ?>">
                                            </div>
                                            (<?php echo $this->item->trial_days ?> <?php echo JText::_('LNG_DAYS')?>)
                                        </div>
                                    </div>
                                </div>
                            </fieldset>

                        <fieldset class="boxed">
                            <div class="form-container">
                                <?php if($this->type == PACKAGE_TYPE_BUSINESS) {?>
                                    <div class="form-group">
                                        <label  id="max_pictures-lbl" for="max_pictures"><?php echo JText::_('LNG_MAX_PICTURES')?> <?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY) ?></label>
                                        <input type="text"	name="max_pictures" id="max_pictures" class="form-control validate[required]"	value="<?php echo $this->item->max_pictures ?>">
                                    </div>

                                    <div class="form-group">
                                        <label  id="max_videos-lbl" for="max_videos"><?php echo JText::_('LNG_MAX_VIDEOS')?> <?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY) ?></label>
                                        <input type="text"	name="max_videos" id="max_videos" class="form-control validate[required]"	value="<?php echo $this->item->max_videos ?>">
                                    </div>
                                    <div class="form-group">
                                        <label  id="max_offers-lbl" for="max_offers"><?php echo JText::_('LNG_MAX_OFFERS')?> <?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY) ?></label>
                                        <input type="text"	name="max_offers" id="max_offers" class="form-control validate[required]"	value="<?php echo $this->item->max_offers ?>">
                                    </div>
                                    <div class="form-group" >
                                        <label for="offer_count_type"><?php echo JText::_('LNG_OFFERS_COUNT')?> <?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY) ?></label>
                                        <div>
                                            <fieldset id="offer_count_type_fld" class="radio btn-group btn-group-yesno">
                                                <input type="radio" class="validate[required]" name="offer_count_type" id="offer_count_type1" value="1" <?php echo $this->item->offer_count_type==1? 'checked="checked"' :""?> />
                                                <label class="btn" for="offer_count_type1"><?php echo JText::_('LNG_TOTAL_CREATED')?></label>
                                                <input type="radio" class="validate[required]" name="offer_count_type" id="offer_count_type2" value="2" <?php echo $this->item->offer_count_type==2? 'checked="checked"' :""?> />
                                                <label class="btn" for="offer_count_type2"><?php echo JText::_('LNG_TOTAL_ACTIVE')?></label>
                                            </fieldset>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label  id="max_events-lbl" for="max_events"><?php echo JText::_('LNG_MAX_EVENTS')?> <?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY) ?></label>
                                        <input type="text"	name="max_events" id="max_events" class="form-control validate[required]"	value="<?php echo $this->item->max_events ?>">
                                    </div>

                                    <div class="form-group">
                                        <label  id="max_attachments-lbl" for="max_attachments"><?php echo JText::_('LNG_MAX_ATTACHMENTS')?> <?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY) ?></label>
                                        <input type="text"	name="max_attachments" id="max_attachments" class="form-control validate[required]" value="<?php echo $this->item->max_attachments ?>">
                                    </div>

                                    <div class="form-group">
                                        <label  id="max_categories-lbl" for="max_categories"><?php echo JText::_('LNG_MAX_CATEGORIES')?> <?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY) ?></label>
                                        <input type="text"	name="max_categories" id="max_categories" class="form-control validate[required]"	value="<?php echo $this->item->max_categories ?>">
                                    </div>

                                    <div class="form-group">
                                        <label  id="max_quote_replies-lbl" for="max_quote_replies"><?php echo JText::_('LNG_MAX_QUOTE_REPLIES')?> <?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY) ?></label>
                                        <input type="text"	name="max_quote_replies" id="max_quote_replies" class="form-control validate[required]"	value="<?php echo $this->item->max_quote_replies ?>">
                                    </div>

                                    <div class="form-group">
                                        <label  id="max_zipcodes-lbl" for="max_zipcodes"><?php echo JText::_('LNG_MAX_ZIPCODES')?> <?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY) ?></label>
                                        <input type="text"	name="max_zipcodes" id="max_zipcodes" class="form-control validate[required]"	value="<?php echo $this->item->max_zipcodes ?>">
                                    </div>

                                    <div class="form-group">
                                        <label  id="max_locations-lbl" for="max_locations"><?php echo JText::_('LNG_MAX_LOCATIONS')?> <?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY) ?></label>
                                        <input type="text"	name="max_locations" id="max_locations" class="form-control validate[required]"	value="<?php echo $this->item->max_locations ?>">
                                    </div>

                                <?php } else { ?>
			                        <?php if (JBusinessUtil::isAppInstalled(JBD_APP_TRIPS)) { ?>
                                        <div class="form-group">
                                            <label  id="max_trips-lbl" for="max_trips"><?php echo JText::_('LNG_MAX_TRIPS')?> <?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY) ?></label>
                                            <input type="text"	name="max_trips" id="max_trips" class="form-control validate[required]"	value="<?php echo $this->item->max_trips ?>">
                                        </div>
			                        <?php } ?>
                                <?php } ?>


                                <div class="form-group" >
                                    <label for="show_features"><?php echo JText::_('LNG_SHOW_FEATURES')?></label>
                                    <div>
                                        <fieldset id="show_features_fld" class="radio btn-group btn-group-yesno">
                                            <input type="radio" class="" name="show_features" id="show_features1" value="1" <?php echo $this->item->show_features==1? 'checked="checked"' :""?> />
                                            <label class="btn" for="show_features1"><?php echo JText::_('LNG_YES')?></label>
                                            <input type="radio" class="" name="show_features" id="show_features0" value="0" <?php echo $this->item->show_features==0? 'checked="checked"' :""?> />
                                            <label class="btn" for="show_features0"><?php echo JText::_('LNG_NO')?></label>
                                        </fieldset>
                                    </div>
                                </div>

                                <div class="form-group" >
                                    <label for="show_disable_features"><?php echo JText::_('LNG_SHOW_DISABLED_FEATURES')?></label>
                                    <div>
                                        <fieldset id="show_disable_features_fld" class="radio btn-group btn-group-yesno">
                                            <input type="radio" class="" name="show_disable_features" id="show_disable_features1" value="1" <?php echo $this->item->show_disable_features==1? 'checked="checked"' :""?> />
                                            <label class="btn" for="show_disable_features1"><?php echo JText::_('LNG_YES')?></label>
                                            <input type="radio" class="" name="show_disable_features" id="show_disable_features0" value="0" <?php echo $this->item->show_disable_features==0? 'checked="checked"' :""?> />
                                            <label class="btn" for="show_disable_features0"><?php echo JText::_('LNG_NO')?></label>
                                        </fieldset>
                                    </div>
                                </div>

                                <div class="form-group" >
                                    <label for="show_buttons"><?php echo JText::_('LNG_SHOW_BUTTONS')?></label>
                                    <div>
                                        <fieldset id="show_buttons_fld" class="radio btn-group btn-group-yesno">
                                            <input type="radio" class="" name="show_buttons" id="show_buttons1" value="1" <?php echo $this->item->show_buttons==1? 'checked="checked"' :""?> />
                                            <label class="btn" for="show_buttons1"><?php echo JText::_('LNG_YES')?></label>
                                            <input type="radio" class="" name="show_buttons" id="show_buttons0" value="0" <?php echo $this->item->show_buttons==0? 'checked="checked"' :""?> />
                                            <label class="btn" for="show_buttons0"><?php echo JText::_('LNG_NO')?></label>
                                        </fieldset>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label  id="bg_color-lbl" for="bg_color"><?php echo JText::_('LNG_BACKGROUND_COLOR')?></label>
                                    <input type="text"	name="bg_color" id="bg_color" class="form-control"	value="<?php echo $this->item->bg_color ?>">
                                </div>

                                <div class="form-group">
                                    <label  id="text_color-lbl" for="text_color"><?php echo JText::_('LNG_TEXT_COLOR')?></label>
                                    <input type="text"	name="text_color" id="text_color" class="form-control" value="<?php echo $this->item->text_color ?>">
                                </div>

                                <div class="form-group">
                                    <label  id="border_color-lbl" for="border_color"><?php echo JText::_('LNG_BORDER_COLOR')?></label>
                                    <input type="text"	name="border_color" id="border_color" class="form-control"	value="<?php echo $this->item->border_color ?>">
                                </div>
                            </div>
                        </fieldset>

                        <fieldset class="boxed">
                            <h2> <?php echo JText::_('LNG_PACKAGE_FEATURES');?></h2>
                            <p> <?php echo JText::_('LNG_PACKAGE_FEATURES_INFORMATION_TEXT');?>.</p>
                            <div class="form-container">
                                <div class="form-group">
                                    <label for="subject"><?php echo JText::_('LNG_FEATURES')?> </label>
                                    <select id="features" class="multiselect" multiple="multiple" name="features[]" size="10">
                                    <?php
                                        foreach($this->features as $key=>$feature){
                                                if(in_array($key, $this->selectedFeatures)>0)
                                                $selected = "selected='selected'";
                                            else
                                                $selected = "";
                                            echo "<option value='$key' $selected>$feature</option>";
                                        }

                                        foreach($this->customFeatures as $feature){
                                            if(in_array($feature->code, $this->selectedFeatures)>0)
                                                $selected = "selected='selected'";
                                            else
                                                $selected = "";
                                            echo "<option value='$feature->code' $selected>$feature->name</option>";
                                        }
                                    ?>
                                     </select>
                                </div>
                            </div>
                        </fieldset>

                        <fieldset class="boxed">
                            <h2> <?php echo JText::_('LNG_CUSTOM_PACKAGE_FEATURES');?></h2>
                            <p> <?php echo JText::_('LNG_CUSTOM_PACKAGE_FEATURES_INFORMATION_TEXT');?>.</p>
                            <div class="form-container">
                                <div class="form-group">
                                <div class="">
                                    <div
                                        class="btn btn-success mb-2"
                                        onclick = "addAttributeOption('<?php echo BD_ASSETS_FOLDER_PATH."images/deleteIcon.png" ?>');">
                                        <div class="la la-plus"></div>
                                    </div>
                                    <div class="">
                                        <fieldset id="option_fld" class="btn-group w-100">
                                            <input type='hidden' name='crt_pos' id='crt_pos' value=''>
                                            <ul class="m-0 list-unstyled" id="list_feature_options">
                                                <?php
                                                if(!empty($this->extraFeatures)) {
                                                    foreach ($this->extraFeatures as $key => $value) { ?>
                                                        <li>
                                                            <div>
                                                                <div class="input-group py-1">
                                                                    <div class="input-group-prepend">
                                                                        <div class="btn btn-outline-light btn-sm d-flex">
                                                                            <div class="la la-arrows-v text-dark"></div>
                                                                        </div>
                                                                    </div>

                                                                    <input type="text" name="features[]" id="option_name"
                                                                       value="<?php echo $this->escape($value) ?>" size="32"
                                                                       class='form-control radius-0 m-0 input_txt attribute_option'
                                                                       maxlength="128"/>

                                                                    <div class="input-group-append">
                                                                        <div class="btn btn-danger btn-sm d-flex"
                                                                            onclick="var row = jQuery(this).parents('li:first');
                                                                                var row_idx = row.prevAll().length;
                                                                                jQuery('#crt_pos').val(row_idx);
                                                                                deleteAttributeOption(jQuery('#crt_pos').val())">
                                                                            <i class="la la-trash-o"></i>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <input type="hidden" name="option_id[]" id="option_id[]" value="<?php echo $value?>" >
                                                            </div>
                                                        </li>
                                                    <?php }
                                                }else {
                                                    ?>
                                                    <li>
                                                        <div class="input-group py-1">

                                                            <div class="input-group-prepend">
                                                                <div class="btn btn-outline-light btn-sm d-flex">
                                                                    <i class="la la-arrows-v text-dark"></i>
                                                                </div>
                                                            </div>

                                                            <input  type="text"
                                                                    name="features[]"
                                                                    id="option_name"
                                                                    class='input_txt form-control radius-0 m-0 attribute_option'
                                                                    value="" size="32"
                                                                    maxlength="128"/>

                                                            <div class="input-group-append">
                                                                <div class="btn btn-danger btn-sm d-flex"
                                                                    onclick="var row = jQuery(this).parents('li:first');
                                                                        var row_idx = row.prevAll().length;
                                                                        jQuery('#crt_pos').val(row_idx);
                                                                        deleteAttributeOption(jQuery('#crt_pos').val())">
                                                                    <i class="la la-trash-o"></i>
                                                                </div>
                                                            </div>

                                                        </div>
                                                    </li>
                                                    <?php
                                                } ?>
                                            </ul>
                                        </fieldset>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    </div>
                </div>
            </div>
        </div>
        <input type="hidden" name="option" value="<?php echo JBusinessUtil::getComponentName()?>" />
        <input type="hidden" name="task" id="task" value="" />
        <input type="hidden" name="id" value="<?php echo $this->item->id ?>" />
        <input type="hidden" name="view" id="view" value="package" />
		<input type="hidden" name="package_type" value="<?php echo $this->type;?>"/>
        <?php echo JHTML::_( 'form.token' ); ?>
    </form>
</div>

<script type="text/javascript">
	window.addEventListener('load', function(){
		jQuery(".chosen-select-usergroup").chosen();
		jQuery("#item-form").validationEngine('attach');
        jQuery('.multiselect').multi({
            'enable_search': true,
            'search_placeholder': '<?php echo JText::_("LNG_SEARCH") . "...";?>'
        });
	
		jQuery("#price").change(function(){
			if(jQuery(this).val() == 0 ){
				jQuery("#days").val(0);
			}
		});

		jQuery("#jrepeat1").click(function(){
			jQuery("#type-fixed").hide();
			jQuery("#type-recurring").hide();
			jQuery("#type-recurring-trial").hide();
		});

		jQuery("#jrepeat2").click(function(){
			jQuery("#type-fixed").slideDown(400);
			jQuery("#type-recurring").hide();
			jQuery("#type-recurring-trial").hide();
		});

		jQuery("#jrepeat3").click(function(){
			jQuery("#type-fixed").slideDown(400);
			jQuery("#type-recurring").slideDown(400);
			jQuery("#type-recurring-trial").hide();
		});

		jQuery("#jrepeat4").click(function(){
			jQuery("#type-fixed").slideDown(400);
			jQuery("#type-recurring").slideDown(400);
			jQuery("#type-recurring-trial").slideDown(400);
		});

		jQuery("#jrepeat<?php echo !empty($this->item->expiration_type)?$this->item->expiration_type:1 ?>").trigger( "click" );

		jQuery( "#list_feature_options" ).sortable();
		jQuery( ".selected-wrapper" ).sortable({helper : 'clone'});
	});

	  function deleteAttributeOption(pos) {
	        var lis=document.querySelectorAll('#list_feature_options li');

	        if(lis==null) {
	            alert('Undefined List, contact administrator !');
	        }

	        var count = jQuery('input[name="features[]"]').length;
	        if(count == 1)
	            return false;

	        if(pos >= lis.length)
	            pos = lis.length-1;
	        lis[pos].parentNode.removeChild(lis[pos]);

	    }

	    function addAttributeOption() {

	        var tb = document.getElementById('list_feature_options');
	        if (tb == null) {
	            alert('Undefined list, contact administrator !');
	        }

	        var li_new	= document.createElement('li');

	        var div_new = document.createElement('div');
	        div_new.setAttribute('class','input-group py-1');

	        var sort_btn_wrap = document.createElement('div');
	        sort_btn_wrap.setAttribute('class','input-group-prepend');
	        var sort_btn = document.createElement('div');
	        sort_btn.setAttribute('class','btn btn-outline-light btn-sm d-flex');
	        var sort_btn_icon = document.createElement('i');
	        sort_btn_icon.setAttribute('class','la la-arrows-v text-dark');

	        sort_btn.appendChild(sort_btn_icon);
	        sort_btn_wrap.appendChild(sort_btn);
	        div_new.appendChild(sort_btn_wrap);

	        var input_o_new = document.createElement('input');
	        input_o_new.setAttribute('type', 'text');
	        input_o_new.setAttribute('name', 'features[]');
	        input_o_new.setAttribute('class','input_txt form-control radius-0 m-0 validate[required] attribute_option');
	        input_o_new.setAttribute('id', 'features[]');
	        input_o_new.setAttribute('size', '32');
	        input_o_new.setAttribute('maxlength', '128');
	        var d = new Date();
	        var id = d.getTime();

	        var clear_btn_wrap = document.createElement('div');
	        clear_btn_wrap.setAttribute('class','input-group-append');
	        var delete_btn = document.createElement('div');
	        delete_btn.setAttribute('class','btn btn-info btn-sm d-flex');
	        delete_btn.onclick = function() {
	        	clearIcon(jQuery(this));
	        };
	        
	        var delete_btn_wrap = document.createElement('div');
	        delete_btn_wrap.setAttribute('class','input-group-append');
	        var delete_btn = document.createElement('div');
	        delete_btn.setAttribute('class','btn btn-danger btn-sm d-flex');
	        delete_btn.onclick = function() {
	            var row = jQuery(this).parents('li:first');
	            var row_idx = row.prevAll().length;
	            jQuery('#crt_pos').val(row_idx);
	            jQuery('#btn_removefile').click();
	            deleteAttributeOption(jQuery('#crt_pos').val())
	        };
	        var delete_btn_icon = document.createElement('i');
	        delete_btn_icon.setAttribute('class','la la-trash-o');
	        delete_btn.appendChild(delete_btn_icon);
	        delete_btn_wrap.appendChild(delete_btn);

	        div_new.appendChild(input_o_new);
	        div_new.appendChild(clear_btn_wrap);
	        div_new.appendChild(delete_btn_wrap);
	        li_new.appendChild(div_new);
	        tb.appendChild(li_new);

	        jQuery('.icp-auto').iconpicker({
	            placement: 'topRightCorner'
	        });
	        showIconFields();
	    }
</script>
