<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_content
 *
 * @copyright   Copyright (C) 2007 - 2015 CMS Junkie. All rights reserved.
 * @license     GNU General Public License version 2 or later;
 */

defined('_JEXEC') or die('Restricted access');

$published = $this->state->get('filter.published');
?>
<div class="jbd-container jbd-edit-container" id="collapseModal" style="display: none">
    <div class="jmodal-sm">
        <div class="jmodal-header">
            <p class="jmodal-header-title"><?php echo JText::_('COM_JBUSINESSDIRECTORY_BATCH_OPTIONS') ?></p>
            <a href="#close-modal" rel="modal:close" class="close-btn"><i class="la la-close "></i></a>
        </div>
        <div class="jmodal-body">
            <p><?php echo JText::_('COM_JBUSINESSDIRECTORY_ORDER_BATCH_TIP'); ?></p>
            <div class="row">
                <div class="col-12">
                    <div class="jinput-outline jinput-hover">
                         <?php echo  JHTML::_('calendar', null, 'batch[start_date]', 'batch-start_date', $this->appSettings->calendarFormat, array( 'class'=>'inputbox validate[required]  calendar-date form-control', 'size'=>'10',  'maxlength'=>'10','placeholder'=>JText::_("LNG_SET_START_DATE"))); ?>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="jinput-outline jinput-hover">
                         <?php echo  JHTML::_('calendar', null, 'batch[end_date]', 'batch-end_date', $this->appSettings->calendarFormat, array( 'class'=>'inputbox validate[required]  calendar-date form-control', 'size'=>'10',  'maxlength'=>'10','placeholder'=>JText::_("LNG_SET_END_DATE"))); ?>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="jinput-outline jinput-hover">
                        <?php echo JHTML::_('calendar', null, 'batch[paid_at]', 'batch-paid_at', $this->appSettings->calendarFormat, array('class'=>'inputbox validate[required] text-input  calendar-date form-control', 'size'=>'10',  'maxlength'=>'10','placeholder'=>JText::_("LNG_SET_PAYMENT_DATE"))); ?>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="jinput-outline jinput-hover">
                        <label title="" class="modalTooltip" for="batch-state_id" id="batch-state-lbl" data-original-title="&lt;strong&gt;Set State&lt;/strong&gt;&lt;br /&gt;Not making a selection will keep the original state when processing."><?php echo JText::_("LNG_SET_STATE")?></label>
                        <select id="batch-state-id" class="inputbox form-control" name="batch[state_id]">
                            <option value=""><?php echo JText::_("LNG_KEEP_ORIGINAL_STATE")?></option>
                            <?php echo JHtml::_('select.options', $this->states, 'value', 'text', $this->state->get('filter.state_id'));?>
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <div class="jmodal-footer">
            <div class="btn-group" role="group" aria-label="">
                <button type="button" class="jmodal-btn jmodal-btn-outline" onclick="document.getElementById('batch-start_date').value='';document.getElementById('batch-end_date').value='';document.getElementById('batch-paid_at').value='';document.getElementById('batch-state-id').value='';jQuery.jbdModal.close()"><?php echo JText::_("LNG_CANCEL")?></button>
                <button type="button" class="jmodal-btn" onclick="Joomla.submitbutton('order.batch');"><?php echo JText::_("JGLOBAL_BATCH_PROCESS")?></button>
            </div>
        </div>
    </div>
</div>