<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');

JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
 JBusinessUtil::initializeChosen();

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;

$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
?>

<script type="text/javascript">
window.addEventListener('load', function() {
	Joomla.submitbutton = function(task) {
		if (task != 'orders.delete' || confirm('<?php echo JText::_('COM_JBUSINESS_DIRECTORY_ORDERS_CONFIRM_DELETE', true);?>')) {
			Joomla.submitform(task);
		}
    }
});
</script>

<div id="jbd-container" class="jbd-container contaner-fluid">
    <form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=orders');?>" method="post" name="adminForm" id="adminForm">
        <div id="j-main-container" class="j-main-container">
		    <?php
		    // Search tools bar
		    echo
            JLayoutHelper::render('joomla.searchtools.default', array('view' => $this, 'options' => array('filtersHidden' =>JBusinessUtil::setFilterVisibility($this->state))));
            ?>
        </div>
        <div class="clr clearfix"></div>

	    <?php if (empty($this->items)) { ?>
            <div class="alert alert-warning">
			    <?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
            </div>
	    <?php } else { ?>

            <table class="jtable" id="itemList">
                <thead class="jtable-head">
                <tr class="jtable-head-row">
                    <td class="jtable-head-row-data"></td>
                    <th class="jtable-head-row-data">
                        <div class="d-flex justify-content-center align-items-center">
                            <div class="jradio">
                                <input id="jradio-2" type="checkbox" title="<?php echo JText::_('JGLOBAL_CHECK_ALL');?>" onclick="Joomla.checkAll(this)" />
                                <label for="jradio-2"></label>
                            </div>
                        </div>
                    </th>
                    <th class="jtable-head-row-data">
                        <div class="d-flex justify-content-center align-items-center">
                            <span class="jtable-head-row-data-title"> # </span>
                        </div>
                    </th>
                    <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_ORDER_ID', 'inv.order_id', $listDirn, $listOrder); ?></th>
                    <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_COMPANY', 'c.name', $listDirn, $listOrder); ?></th>
                    <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_AMOUNT', 'inv.amount', $listDirn, $listOrder); ?></th>
                    <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_COUPON_CODE', 'inv.discount_code', $listDirn, $listOrder); ?></th>
                    <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_CREATED', 'inv.created', $listDirn, $listOrder); ?></th>
                    <th class="jtable-head-row-data"><?php echo JHtml::_('searchtools.sort', 'LNG_START_DATE', 'inv.start_date', $listDirn, $listOrder); ?></th>
                    <th class="jtable-head-row-data"><?php echo JHtml::_('searchtools.sort', 'LNG_END_DATE', 'inv.end_date', $listDirn, $listOrder); ?></th>
                    <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_USER', 'inv.user_name', $listDirn, $listOrder); ?></th>
                    <th class="jtable-head-row-data"> <?php echo JText::_("LNG_EXPIRATION_NOTIFICATION")?></th>
                    <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_STATE', 'inv.state', $listDirn, $listOrder); ?></th>
                    <th class="jtable-head-row-data"></th>
                    <th class="jtable-head-row-data"></th>
                    <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_ID', 'inv.id', $listDirn, $listOrder); ?></th>
                </tr>
            </thead>
            <tfoot>
                <tr>
                    <td colspan="15">
                        <?php echo $this->pagination->getListFooter(); ?>
                    </td>
                </tr>
            </tfoot>
            <tbody class="jtable-body">
                <?php $nrcrt = 1; $i=0;
                foreach ($this->items as $item) { ?>
                    <TR class="jtable-body-row">

                        <td class="jtable-body-row-data">
                            <div class="d-flex align-items-center">
                                <div id="item-status-<?php echo $item->id?>" class="jtable-body-status <?php echo $item->state == 1?"bg-success":"bg-danger" ?> "></div>
                            </div>
                        </td>

                        <td class="jtable-body-row-data px-3">
                            <?php echo HTMLHelper::_('jbdgrid.id', $i, $item->id); ?>
                        </td>

                        <td class="jtable-body-row-data"><?php echo $nrcrt++?></td>

                        <td class="jtable-body-row-data">
                            <a href='<?php echo JRoute::_( 'index.php?option=com_jbusinessdirectory&task=order.edit&id='. $item->id )?>'
                                title="<?php echo JText::_('LNG_CLICK_TO_EDIT'); ?>">
                                <B><?php echo $item->order_id?></B>
                            </a>
                        </td>

                        <td class="jtable-body-row-data">
                            <?php echo $item->companyName ?>
                        </td>
                        <td class="jtable-body-row-data">
                            <?php echo $item->amount ?>
                            <?php if (isset($item->trial_initial_amount)){?>
                                (<?php echo JText::_("LNG_TRIAL")." - ".($item->trial_initial_amount>0?$item->trial_initial_amount:JText::_("LNG_FREE")) ?>)
                            <?php } ?>
                        </td>
                        <td class="jtable-body-row-data">
                            <?php echo $item->discount_code ?>
                        </td>
                        <td class="jtable-body-row-data">
                            <?php echo JBusinessUtil::getDateGeneralShortFormat($item->created) ?>
                        </td>
                        <td class="jtable-body-row-data">
                            <?php echo JBusinessUtil::getDateGeneralShortFormat($item->start_date) ?>
                        </td>
                        <td class="jtable-body-row-data">
                            <?php echo JBusinessUtil::getDateGeneralShortFormat($item->end_date) ?>
                        </td>
                        <td class="jtable-body-row-data">
                            <?php echo $item->user_name ?>
                        </td>
                        <td class="jtable-body-row-data">
                            <?php echo JBusinessUtil::getDateGeneralFormatWithTime($item->expiration_email_date)?>
                        </td>
                        <td class="jtable-body-row-data">
                            <?php
                            switch ($item->state) {
                                case 0:
                                    echo '<div class="status-badge badge-primary">'.JText::_("LNG_NOT_PAID").'</div>';
                                    break;
                                case 1:
                                    echo '<div class="status-badge badge-success">'.JText::_("LNG_PAID").'</div>';
                                    break;
                                case 2:
                                    echo '<div class="status-badge badge-danger">'.JText::_("LNG_CANCELED").'</div>';
                                    break;
                            } ?>
                        </td>
                        <td class="jtable-body-row-data">
                            <a href='<?php echo JBusinessUtil::getWebsiteUrl(true).( 'index.php?option=com_jbusinessdirectory&task=orders.generateInvoicePDF&invoiceId='. $item->id .'&'.JSession::getFormToken().'=1' )?>'
                                        title='<?php echo JText::_('LNG_DOWNLOAD'); ?>'
                                        class="jtable-btn"
                                        target="_blank">
                                        <i class="icon pdf-download"></i>
                                        </a>                        
                        </td>
                        <td class="jtable-body-row-data">
                            <a href="javascript:showInvoice(<?php echo  $item->id ?>)"><?php echo JText::_("LNG_VIEW") ?></a>
                        </td>
                        <td class="jtable-body-row-data">
                            <?php echo $item->id?>
                        </td>
                    </TR>
                <?php
                $i++;
                } ?>
            </tbody>
        </table>
        <?php } ?>

        <input type="hidden" name="option"	value="<?php echo JBusinessUtil::getComponentName()?>" />
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="boxchecked" value="0" />
        <?php echo JHTML::_( 'form.token' ); ?>

        <?php // Load the batch processing form. ?>
        <?php echo $this->loadTemplate('batch'); ?>
    </form>
</div>

<?php echo $this->loadTemplate('export'); ?>
<?php echo $this->loadTemplate('logs'); ?>


<div id="invoice" class="jbd-container" style="display: none">    
    <div class="jmodal-md">
        <div class="jmodal-header">
            <p class="jmodal-header-title"><?php echo JText::_('LNG_INVOICE') ?></p>
            <a href="#close-modal" rel="modal:close" class="close-btn"><i class="la la-close "></i></a>
        </div>
        <div class="jmodal-body">
         <iframe id="invoiceIfr" height="720" src="" scrolling="auto"></iframe>       
    </div>
</div>

<script>
    function showInvoice(invoice) {
    	var baseUrl = "<?php echo JBusinessUtil::getWebsiteUrl(true).('index.php?option=com_jbusinessdirectory&view=invoice&tmpl=component&'.JSession::getFormToken().'=1'); ?>";        
        
        baseUrl = baseUrl + "&invoiceId="+invoice;

   	 	var options = {
         	    modalClass: "jbd-modal jbd-invoice"
        };
    	
    	jQuery("#invoiceIfr").attr("src",baseUrl);
    	jQuery('#invoice').jbdModal(options);
    }
</script>