<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');

/**
 * The HTML  View.
 */
require_once HELPERS_PATH.'/helper.php';
JBusinessUtil::includeValidation();

class JBusinessDirectoryViewOfferType extends JBusinessDirectoryAdminView {
	protected $item;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null) {
		$this->item	 = $this->get('Item');
		$this->state = $this->get('State');
		$this->appSettings = JBusinessUtil::getApplicationSettings();
		$this->translations = JBusinessDirectoryTranslations::getAllTranslations(OFFER_TYPE_TRANSLATION, $this->item->id);
		$this->languages = JBusinessUtil::getLanguages();

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar() {
		$canDo = JBusinessDirectoryHelper::getActions();
		
		$input = JFactory::getApplication()->input;
		$input->set('hidemainmenu', true);

		$isNew = ($this->item->id == 0);

		JToolbarHelper::title(JText::_($isNew ? 'COM_JBUSINESSDIRECTORY_NEW_OFFER_TYPE' : 'COM_JBUSINESSDIRECTORY_EDIT_OFFER_TYPE'), 'menu.png');
		
		if ($canDo->get('core.edit')) {
			JToolbarHelper::apply('offertype.apply');
			JToolbarHelper::save('offertype.save');
		}
		
		JToolbarHelper::cancel('offertype.cancel', 'JTOOLBAR_CLOSE');
		
		JToolbarHelper::divider();
		JToolBarHelper::help('', false, DOCUMENTATION_URL.'businessdiradmin.html#event-type');
	}
}
